/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.sophisticatedvaultupgrades.upgrades.opener;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.api.ISlotChangeResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.inventory.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IInsertResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IOverflowResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.iwolfking.sophisticatedvaultupgrades.upgrades.opener.OpenerUpgradeHelper;
import xyz.iwolfking.sophisticatedvaultupgrades.upgrades.opener.OpenerUpgradeItem;

public class OpenerUpgradeWrapper
extends UpgradeWrapperBase<OpenerUpgradeWrapper, OpenerUpgradeItem>
implements IInsertResponseUpgrade,
IFilteredUpgrade,
ISlotChangeResponseUpgrade,
ITickableUpgrade,
IOverflowResponseUpgrade {
    private final FilterLogic filterLogic;
    private final Set<Integer> slotsToHandle = new HashSet<Integer>();
    private final ItemStack upgradeStack;

    public OpenerUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.upgradeStack = upgrade;
        this.filterLogic = new FilterLogic(upgrade, upgradeSaveHandler, ((OpenerUpgradeItem)this.upgradeItem).getFilterSlotCount());
    }

    @NotNull
    public ItemStack onBeforeInsert(@NotNull IItemHandlerSimpleInserter inventoryHandler, int slot, @NotNull ItemStack stack, boolean simulate) {
        if (!this.stackMatchesFilter(stack) || !this.hasSlotSpace()) {
            return stack;
        }
        if (this.filterLogic.matchesFilter(stack)) {
            List<ItemStack> outputs = OpenerUpgradeHelper.getOpenerOutput(stack);
            if (!this.hasSlotSpace(outputs.size())) {
                this.slotsToHandle.add(slot);
                return stack;
            }
            if (!outputs.isEmpty()) {
                for (ItemStack lootStack : outputs) {
                    inventoryHandler.insertItem(lootStack, simulate);
                }
                return ItemStack.f_41583_;
            }
        }
        return stack;
    }

    public void onAfterInsert(@NotNull IItemHandlerSimpleInserter inventoryHandler, int slot) {
    }

    @NotNull
    public FilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    public void setShouldWorkdInGUI(boolean shouldWorkdInGUI) {
        NBTHelper.setBoolean((ItemStack)this.upgrade, (String)"shouldWorkInGUI", (boolean)shouldWorkdInGUI);
        this.save();
    }

    public boolean shouldWorkInGUI() {
        return NBTHelper.getBoolean((ItemStack)this.upgrade, (String)"shouldWorkInGUI").orElse(false);
    }

    public void onSlotChange(@NotNull IItemHandler inventoryHandler, int slot) {
        if (!this.shouldWorkInGUI()) {
            return;
        }
        ItemStack slotStack = inventoryHandler.getStackInSlot(slot);
        if (this.stackMatchesFilter(slotStack)) {
            this.slotsToHandle.add(slot);
        }
    }

    public void tick(@Nullable LivingEntity entity, @NotNull Level world, @NotNull BlockPos pos) {
        if (this.slotsToHandle.isEmpty()) {
            return;
        }
        InventoryHandler storageInventory = this.storageWrapper.getInventoryHandler();
        for (int slot : this.slotsToHandle) {
            ItemStack stack = storageInventory.getStackInSlot(slot);
            if (!this.stackMatchesFilter(stack)) {
                this.slotsToHandle.remove(slot);
                continue;
            }
            List<ItemStack> outputs = OpenerUpgradeHelper.getOpenerOutput(stack);
            if (!this.hasSlotSpace(outputs.size())) {
                return;
            }
            for (ItemStack lootStack : outputs) {
                if (storageInventory.insertItem(lootStack, true).m_41619_()) {
                    storageInventory.insertItem(lootStack, false);
                    storageInventory.extractItem(slot, 1, false);
                    continue;
                }
                return;
            }
        }
        this.slotsToHandle.clear();
    }

    public boolean worksInGui() {
        return this.shouldWorkInGUI();
    }

    @NotNull
    public ItemStack onOverflow(@NotNull ItemStack itemStack) {
        return itemStack;
    }

    public boolean stackMatchesFilter(@NotNull ItemStack stack) {
        if (!OpenerUpgradeHelper.isSupported(stack)) {
            return false;
        }
        return this.filterLogic.matchesFilter(stack);
    }

    private boolean hasSlotSpace() {
        InventoryHandler handler = this.storageWrapper.getInventoryHandler();
        Predicate hasItemPredicate = Predicate.not(Predicate.isEqual(ItemStack.f_41583_));
        if (!handler.hasEmptySlots()) {
            return false;
        }
        return handler.getSlots() - InventoryHelper.getItemSlots((IItemHandler)handler, hasItemPredicate).size() >= 1;
    }

    private boolean hasSlotSpace(int count) {
        InventoryHandler handler = this.storageWrapper.getInventoryHandler();
        Predicate hasItemPredicate = Predicate.not(Predicate.isEqual(ItemStack.f_41583_));
        if (!handler.hasEmptySlots()) {
            return false;
        }
        return handler.getSlots() - InventoryHelper.getItemSlots((IItemHandler)handler, hasItemPredicate).size() >= count;
    }
}

