/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.sophisticatedvaultupgrades.upgrades.recycler;

import iskallia.vault.config.VaultRecyclerConfig;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.item.gear.RecyclableItem;
import java.util.List;
import java.util.Random;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import xyz.iwolfking.sophisticatedvaultupgrades.SophisticatedVaultUpgrades;
import xyz.iwolfking.vhapi.api.data.api.CustomRecyclerOutputs;

public class RecyclerUpgradeHelper {
    private static final Random random = new Random();

    public static List<ItemStack> getVaultRecyclerOutputs(ItemStack stack) {
        if (stack.m_41720_() instanceof RecyclableItem || CustomRecyclerOutputs.CUSTOM_OUTPUTS.containsKey(stack.m_41720_().getRegistryName())) {
            VaultRecyclerConfig.RecyclerOutput output;
            ItemStack input = stack.m_41777_();
            float resultPercentage = 1.0f;
            Item item = stack.m_41720_();
            if (item instanceof RecyclableItem) {
                RecyclableItem recyclableItem = (RecyclableItem)item;
                output = recyclableItem.getOutput(stack);
                resultPercentage = recyclableItem.getResultPercentage(stack);
            } else {
                output = (VaultRecyclerConfig.RecyclerOutput)CustomRecyclerOutputs.CUSTOM_OUTPUTS.get(stack.m_41720_().getRegistryName());
            }
            if (output == null) {
                SophisticatedVaultUpgrades.LOGGER.warn("A Recycler Upgrade output was null, this ideally shouldn't happen...");
                return List.of();
            }
            float additionalChance = 0.0f;
            if (input.m_41720_() instanceof VaultGearItem) {
                VaultGearRarity rarity = VaultGearData.read((ItemStack)input).getRarity();
                additionalChance = ModConfigs.VAULT_RECYCLER.getAdditionalOutputRarityChance(rarity);
            }
            if (resultPercentage < 1.0f && resultPercentage < random.nextFloat()) {
                return List.of();
            }
            if (stack.m_41720_() instanceof VaultGearItem) {
                VaultGearData data = VaultGearData.read((ItemStack)input);
                VaultGearRarity rarity = data.getRarity();
                boolean isCrafted = data.hasAttribute(ModGearAttributes.CRAFTED_BY) || data.getFirstValue(ModGearAttributes.CRAFTED_BY).isPresent();
                boolean isLegendary = (Boolean)data.get(ModGearAttributes.IS_LEGENDARY, VaultGearAttributeTypeMerger.anyTrue());
                additionalChance = ModConfigs.VAULT_RECYCLER.getAdditionalOutputRarityChance(rarity);
                return List.of(output.generateMainOutput(additionalChance), output.generateExtraOutput1(stack, additionalChance, rarity, isCrafted, isLegendary), output.generateExtraOutput2(stack, additionalChance, rarity, isCrafted, isLegendary));
            }
            return List.of(output.generateMainOutput(additionalChance), output.generateExtraOutput1(stack, additionalChance), output.generateExtraOutput2(stack, additionalChance));
        }
        return List.of();
    }
}

