/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.sophisticatedvaultupgrades.upgrades.recycler;

import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.item.IdentifiableItem;
import iskallia.vault.item.gear.RecyclableItem;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.api.ISlotChangeResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.inventory.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IInsertResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IOverflowResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.iwolfking.sophisticatedvaultupgrades.upgrades.recycler.RecyclerUpgradeHelper;
import xyz.iwolfking.sophisticatedvaultupgrades.upgrades.recycler.RecyclerUpgradeItem;
import xyz.iwolfking.vhapi.api.data.api.CustomRecyclerOutputs;

public class RecyclerUpgradeWrapper
extends UpgradeWrapperBase<RecyclerUpgradeWrapper, RecyclerUpgradeItem>
implements IInsertResponseUpgrade,
IFilteredUpgrade,
ISlotChangeResponseUpgrade,
ITickableUpgrade,
IOverflowResponseUpgrade {
    private final FilterLogic filterLogic;
    private final Set<Integer> slotsToVoid = new HashSet<Integer>();

    public RecyclerUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new FilterLogic(upgrade, upgradeSaveHandler, ((RecyclerUpgradeItem)this.upgradeItem).getFilterSlotCount());
    }

    @NotNull
    public ItemStack onBeforeInsert(@NotNull IItemHandlerSimpleInserter inventoryHandler, int slot, @NotNull ItemStack stack, boolean simulate) {
        RecyclableItem recyclableItem;
        IdentifiableItem identifiableItem;
        Object object;
        if (!(stack.m_41720_() instanceof RecyclableItem) && !CustomRecyclerOutputs.CUSTOM_OUTPUTS.containsKey(stack.m_41720_().getRegistryName())) {
            return stack;
        }
        if (!this.hasSlotSpace()) {
            return stack;
        }
        if (!this.shouldScrapUnidentified() && (object = stack.m_41720_()) instanceof IdentifiableItem && (identifiableItem = (IdentifiableItem)object).getState(stack).equals((Object)VaultGearState.UNIDENTIFIED)) {
            return stack;
        }
        object = stack.m_41720_();
        if (object instanceof RecyclableItem && !(recyclableItem = (RecyclableItem)object).isValidInput(stack)) {
            return stack;
        }
        List<ItemStack> outputs = RecyclerUpgradeHelper.getVaultRecyclerOutputs(stack);
        if (this.filterLogic.matchesFilter(stack) && !outputs.isEmpty()) {
            for (ItemStack recycleStack : outputs) {
                inventoryHandler.insertItem(recycleStack, simulate);
            }
            return ItemStack.f_41583_;
        }
        return stack;
    }

    public void onAfterInsert(@NotNull IItemHandlerSimpleInserter inventoryHandler, int slot) {
    }

    @NotNull
    public FilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    public void setShouldWorkdInGUI(boolean shouldWorkdInGUI) {
        NBTHelper.setBoolean((ItemStack)this.upgrade, (String)"shouldWorkInGUI", (boolean)shouldWorkdInGUI);
        this.save();
    }

    public boolean shouldWorkInGUI() {
        return NBTHelper.getBoolean((ItemStack)this.upgrade, (String)"shouldWorkInGUI").orElse(false);
    }

    public void onSlotChange(@NotNull IItemHandler inventoryHandler, int slot) {
        if (!this.shouldWorkInGUI()) {
            return;
        }
        ItemStack slotStack = inventoryHandler.getStackInSlot(slot);
        if (this.filterLogic.matchesFilter(slotStack) && slotStack.m_41720_() instanceof RecyclableItem || CustomRecyclerOutputs.CUSTOM_OUTPUTS.containsKey(slotStack.m_41720_().getRegistryName())) {
            RecyclableItem recyclableItem;
            Item item = slotStack.m_41720_();
            if (item instanceof RecyclableItem && !(recyclableItem = (RecyclableItem)item).isValidInput(slotStack)) {
                return;
            }
            this.slotsToVoid.add(slot);
        }
    }

    public void tick(@Nullable LivingEntity entity, @NotNull Level world, @NotNull BlockPos pos) {
        if (this.slotsToVoid.isEmpty()) {
            return;
        }
        InventoryHandler storageInventory = this.storageWrapper.getInventoryHandler();
        for (int slot : this.slotsToVoid) {
            IdentifiableItem identifiableItem;
            Object object;
            ItemStack stack = storageInventory.getStackInSlot(slot);
            if (!this.stackMatchesFilter(stack) || !this.shouldScrapUnidentified() && (object = stack.m_41720_()) instanceof IdentifiableItem && (identifiableItem = (IdentifiableItem)object).getState(stack).equals((Object)VaultGearState.UNIDENTIFIED)) continue;
            List<ItemStack> outputs = RecyclerUpgradeHelper.getVaultRecyclerOutputs(stack);
            object = outputs.iterator();
            while (object.hasNext()) {
                ItemStack recycleStack = (ItemStack)object.next();
                storageInventory.insertItem(recycleStack, false);
            }
            storageInventory.extractItem(slot, stack.m_41613_(), false);
        }
        this.slotsToVoid.clear();
    }

    public boolean worksInGui() {
        return this.shouldWorkInGUI();
    }

    @NotNull
    public ItemStack onOverflow(@NotNull ItemStack itemStack) {
        return itemStack;
    }

    public boolean stackMatchesFilter(@NotNull ItemStack stack) {
        RecyclableItem recyclableItem;
        Item item = stack.m_41720_();
        if (item instanceof RecyclableItem && !(recyclableItem = (RecyclableItem)item).isValidInput(stack)) {
            return false;
        }
        return this.filterLogic.matchesFilter(stack);
    }

    private boolean hasSlotSpace() {
        InventoryHandler handler = this.storageWrapper.getInventoryHandler();
        Predicate hasItemPredicate = Predicate.not(Predicate.isEqual(ItemStack.f_41583_));
        if (!handler.hasEmptySlots()) {
            return false;
        }
        return handler.getSlots() - InventoryHelper.getItemSlots((IItemHandler)handler, hasItemPredicate).size() >= 3;
    }

    public void setScrapUnidentified(boolean shouldScrapUnidentified) {
        NBTHelper.setBoolean((ItemStack)this.upgrade, (String)"shouldScrapUnidentified", (boolean)shouldScrapUnidentified);
        this.save();
    }

    public boolean shouldScrapUnidentified() {
        return NBTHelper.getBoolean((ItemStack)this.upgrade, (String)"shouldScrapUnidentified").orElse(false);
    }
}

