/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.rechiseled_chipped.mixin.rechiseled;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.gui.widget.BaseContainerWidget;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.rechiseled.chiseling.ChiselingEntry;
import com.supermartijn642.rechiseled.chiseling.ChiselingRecipe;
import com.supermartijn642.rechiseled.screen.BaseChiselingContainer;
import com.supermartijn642.rechiseled.screen.BaseChiselingContainerScreen;
import com.supermartijn642.rechiseled.screen.ChiselAllWidget;
import com.supermartijn642.rechiseled.screen.ConnectingToggleWidget;
import com.supermartijn642.rechiseled.screen.EntryButtonWidget;
import com.supermartijn642.rechiseled.screen.EntryPreviewWidget;
import com.supermartijn642.rechiseled.screen.PreviewModeButtonWidget;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import xyz.iwolfking.rechiseled_chipped.gui.ScrollWidget;

@Mixin(value={BaseChiselingContainerScreen.class}, remap=false)
public abstract class MixinBaseChiselingContainerScreen<T extends BaseChiselingContainer>
extends BaseContainerWidget<T> {
    @Shadow
    public static int previewMode;
    @Shadow
    private ChiselAllWidget chiselAllWidget;
    private ScrollWidget scrollWidget;
    private ChiselingRecipe previousRecipe;
    private final int numColumns = 4;
    private final int numRows = 5;
    private int numScrolls;
    private int currentScroll = 0;

    @Shadow
    protected abstract ChiselingEntry getEntry(int var1);

    @Shadow
    protected abstract void selectEntry(int var1);

    @Shadow
    protected abstract void toggleConnecting();

    @Shadow
    protected abstract void chiselAll();

    public MixinBaseChiselingContainerScreen(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    @Overwrite
    protected void addWidgets() {
        this.scrollWidget = new ScrollWidget(96, 17, 14, 110, this::scrollChanged);
        this.addWidget((Widget)this.scrollWidget);
        this.previousRecipe = ((BaseChiselingContainer)this.container).currentRecipe;
        this.updateScrollData();
        int offsetX = 9;
        int offsetY = 17;
        int entryWidth = 20;
        int entryHeight = 22;
        for (int row = 0; row < 5; ++row) {
            for (int column = 0; column < 4; ++column) {
                int index = row * 4 + column;
                int x = offsetX + entryWidth * column;
                int y = offsetY + entryHeight * row;
                EntryButtonWidget entryWidget = new EntryButtonWidget(x, y, entryWidth, entryHeight, () -> this.getEntry(4 * this.currentScroll + index), () -> ((BaseChiselingContainer)this.container).currentEntry, () -> this.selectEntry(4 * this.currentScroll + index), () -> ((BaseChiselingContainer)this.container).connecting);
                this.addWidget((Widget)entryWidget);
            }
        }
        this.addWidget((Widget)new EntryPreviewWidget(117, 17, 68, 69, () -> {
            ChiselingEntry entry = ((BaseChiselingContainer)this.container).currentEntry;
            if (entry == null) {
                return null;
            }
            return ((BaseChiselingContainer)this.container).connecting && entry.hasConnectingItem() || !entry.hasRegularItem() ? entry.getConnectingItem() : entry.getRegularItem();
        }, () -> previewMode));
        Supplier<Boolean> enablePreviewButtons = () -> {
            ChiselingEntry entry = ((BaseChiselingContainer)this.container).currentEntry;
            if (entry == null) {
                return false;
            }
            Item currentItem = ((BaseChiselingContainer)this.container).connecting && entry.hasConnectingItem() || !entry.hasRegularItem() ? entry.getConnectingItem() : entry.getRegularItem();
            return currentItem instanceof BlockItem;
        };
        this.addWidget((Widget)new PreviewModeButtonWidget(193, 18, 19, 21, 2, () -> previewMode, enablePreviewButtons, () -> {
            previewMode = 2;
        }));
        this.addWidget((Widget)new PreviewModeButtonWidget(193, 41, 19, 21, 1, () -> previewMode, enablePreviewButtons, () -> {
            previewMode = 1;
        }));
        this.addWidget((Widget)new PreviewModeButtonWidget(193, 64, 19, 21, 0, () -> previewMode, enablePreviewButtons, () -> {
            previewMode = 0;
        }));
        this.addWidget((Widget)new ConnectingToggleWidget(193, 99, 19, 21, () -> ((BaseChiselingContainer)this.container).connecting, () -> ((BaseChiselingContainer)this.container).currentEntry, this::toggleConnecting));
        this.chiselAllWidget = (ChiselAllWidget)this.addWidget((Widget)new ChiselAllWidget(127, 99, 19, 21, () -> ((BaseChiselingContainer)this.container).currentEntry, this::chiselAll));
    }

    public void render(PoseStack poseStack, int mouseX, int mouseY) {
        if (this.previousRecipe != ((BaseChiselingContainer)this.container).currentRecipe) {
            this.updateScrollData();
            this.previousRecipe = ((BaseChiselingContainer)this.container).currentRecipe;
        }
        super.render(poseStack, mouseX, mouseY);
    }

    public boolean mouseScrolled(int mouseX, int mouseY, double scrollAmount, boolean hasBeenHandled) {
        if (mouseX >= 8 && mouseX <= 110 && mouseY >= 16 && mouseY <= 127) {
            this.currentScroll -= (int)scrollAmount;
            this.clampCurrentScroll();
            if (this.scrollWidget != null) {
                this.scrollWidget.setScrollRatio(this.numScrolls == 0 ? 0.0f : (float)this.currentScroll / (float)this.numScrolls);
            }
        }
        return super.mouseScrolled(mouseX, mouseY, scrollAmount, hasBeenHandled);
    }

    private void scrollChanged() {
        this.currentScroll = (int)((float)this.numScrolls * this.scrollWidget.getScrollRatio());
        this.clampCurrentScroll();
    }

    private void updateScrollData() {
        int numRecipes;
        boolean hasRecipe = ((BaseChiselingContainer)this.container).currentRecipe != null;
        int n = numRecipes = hasRecipe ? ((BaseChiselingContainer)this.container).currentRecipe.getEntries().size() : 0;
        if (((BaseChiselingContainer)this.container).currentRecipe == null) {
            this.numScrolls = 0;
        } else {
            this.numScrolls = (int)Math.ceil((double)numRecipes / 4.0) - 5;
            if (this.numScrolls < 0) {
                this.numScrolls = 0;
            }
        }
        if (hasRecipe) {
            if (((BaseChiselingContainer)this.container).currentEntry != null) {
                int indexOfItem = ((BaseChiselingContainer)this.container).currentRecipe.getEntries().indexOf(((BaseChiselingContainer)this.container).currentEntry);
                int itemRow = (int)Math.ceil((double)(indexOfItem + 1) / (double)this.numColumns);
                this.currentScroll = itemRow - 5;
                this.clampCurrentScroll();
            }
        } else {
            this.currentScroll = 0;
        }
        if (this.scrollWidget != null) {
            this.scrollWidget.setIntSnapMax(this.numScrolls);
            this.scrollWidget.setIsActive(this.numScrolls > 0);
            this.scrollWidget.setScrollRatio((float)this.numScrolls == 0.0f ? 0.0f : (float)this.currentScroll / (float)this.numScrolls);
        }
    }

    private void clampCurrentScroll() {
        if (this.currentScroll < 0) {
            this.currentScroll = 0;
        }
        if (this.currentScroll > this.numScrolls) {
            this.currentScroll = this.numScrolls;
        }
    }
}

