/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.equipmentcompare.config;

import com.electronwill.nightconfig.core.Config;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.IConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

public class EquipmentCompareConfig {
    public static final ForgeConfigSpec SPEC;
    public static final EquipmentCompareConfig INSTANCE;
    public final ForgeConfigSpec.BooleanValue defaultOn;
    public final ForgeConfigSpec.BooleanValue strict;
    public final ForgeConfigSpec.LongValue badgeBackgroundColor;
    public final ForgeConfigSpec.LongValue badgeBorderStartColor;
    public final ForgeConfigSpec.LongValue badgeBorderEndColor;
    public final ForgeConfigSpec.BooleanValue overrideBadgeText;
    public final ForgeConfigSpec.ConfigValue<String> badgeText;
    public final ForgeConfigSpec.LongValue badgeTextColor;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> blacklist;

    public EquipmentCompareConfig(ForgeConfigSpec.Builder build) {
        build.comment("Client Configuration").push("client").push("visual_options");
        this.overrideBadgeText = build.comment(" If badge_text should override the built-in translatable text.").define("override_badge_text", false);
        this.badgeText = build.comment(" The text shown on the badge above equipped tooltips.").define("badge_text", (Object)"Equipped");
        this.badgeTextColor = build.comment(" The color of the text shown on the badge above equipped tooltips.").defineInRange("badge_text_color", 0xFFFFFFFFL, 0L, 0xFFFFFFFFL);
        this.badgeBackgroundColor = build.comment(" The background color of the \"equipped\" badge.").defineInRange("badge_bg", 0xF0101000L, 0L, 0xFFFFFFFFL);
        this.badgeBorderStartColor = build.comment(" The start border color of the \"equipped\" badge.").defineInRange("badge_border_start", 3500839187L, 0L, 0xFFFFFFFFL);
        this.badgeBorderEndColor = build.comment(" The end border color of the \"equipped\" badge.").defineInRange("badge_border_end", 1623360778L, 0L, 0xFFFFFFFFL);
        build.pop().push("control_options");
        this.defaultOn = build.comment(" If the comparison tooltip should show by default (pressing bound key hides).").define("default_on", false);
        this.strict = build.comment(" If tool comparisons should compare only the same types of tools (can't compare a sword to an axe, for example).").define("strict", false);
        this.blacklist = build.comment(" Blacklist of items to show comparisons for.  Add item IDs to prevent them from being compared when hovered over or equipped.").defineListAllowEmpty(Arrays.asList("blacklist"), () -> new ArrayList(), e -> ResourceLocation.m_135830_((String)((String)e)));
        build.pop().pop();
    }

    @SubscribeEvent
    public static void onLoad(IConfigEvent e) {
    }

    static {
        Config.setInsertionOrderPreserved((boolean)true);
        Pair specPair = new ForgeConfigSpec.Builder().configure(EquipmentCompareConfig::new);
        SPEC = (ForgeConfigSpec)specPair.getRight();
        INSTANCE = (EquipmentCompareConfig)specPair.getLeft();
    }
}

