/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;
import mcjty.lib.varia.ComponentFactory;
import mcjty.rftoolsstorage.storage.StorageEntry;
import mcjty.rftoolsstorage.storage.StorageHolder;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;

public class CommandList
implements Command<CommandSourceStack> {
    private static final CommandList CMD = new CommandList();

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"list").requires(cs -> cs.m_6761_(2))).executes((Command)CMD);
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        for (StorageEntry storage : StorageHolder.get((Level)((CommandSourceStack)context.getSource()).m_81372_()).getStorages()) {
            String createdByColor;
            Object createdBy = storage.getCreatedBy();
            String uuid = storage.getUuid().toString();
            if (createdBy == null || ((String)createdBy).isEmpty()) {
                createdByColor = String.valueOf(ChatFormatting.GRAY);
                createdBy = "(Unknown creator)";
            } else {
                createdByColor = String.valueOf(ChatFormatting.YELLOW);
                createdBy = "(" + (String)createdBy + ")";
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
            Date creationTime = new Date(storage.getCreationTime());
            Date updateTime = new Date(storage.getUpdateTime());
            String createTimeF = dateFormat.format(creationTime);
            String updateTimeF = dateFormat.format(updateTime);
            String output = String.format(ChatFormatting.GREEN + "%s: %s%s\n" + ChatFormatting.WHITE + "Create " + ChatFormatting.YELLOW + "%s" + ChatFormatting.WHITE + ", Update " + ChatFormatting.YELLOW + "%s", uuid, createdByColor, createdBy, createTimeF, updateTimeF);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)ComponentFactory.literal((String)output), false);
        }
        return 0;
    }
}

