/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.compat.jei;

import java.util.List;
import java.util.function.Supplier;
import mcjty.lib.varia.ItemStackList;
import mcjty.rftoolsbase.api.compat.JEIRecipeAcceptor;
import mcjty.rftoolsbase.modules.tablet.items.TabletItem;
import mcjty.rftoolsstorage.modules.scanner.blocks.StorageScannerContainer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class PacketSendRecipe {
    private ItemStackList stacks;
    private BlockPos pos;

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.stacks.size());
        for (ItemStack stack : this.stacks) {
            buf.m_130055_(stack);
        }
        if (this.pos != null) {
            buf.writeBoolean(true);
            buf.m_130064_(this.pos);
        } else {
            buf.writeBoolean(false);
        }
    }

    public PacketSendRecipe() {
    }

    public PacketSendRecipe(FriendlyByteBuf buf) {
        int l = buf.readInt();
        this.stacks = ItemStackList.create((int)l);
        for (int i = 0; i < l; ++i) {
            this.stacks.set(i, (Object)buf.m_130267_());
        }
        this.pos = buf.readBoolean() ? buf.m_130135_() : null;
    }

    public PacketSendRecipe(ItemStackList stacks, BlockPos pos) {
        this.stacks = stacks;
        this.pos = pos;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer player = ctx.getSender();
            Level world = player.m_20193_();
            if (this.pos == null) {
                ItemStack mainhand = player.m_21205_();
                if (!mainhand.m_41619_() && mainhand.m_41720_() instanceof TabletItem && player.f_36096_ instanceof StorageScannerContainer) {
                    StorageScannerContainer storageScannerContainer = (StorageScannerContainer)player.f_36096_;
                }
            } else {
                BlockEntity te = world.m_7702_(this.pos);
                if (te instanceof JEIRecipeAcceptor) {
                    JEIRecipeAcceptor acceptor = (JEIRecipeAcceptor)te;
                    acceptor.setGridContents((List)this.stacks);
                }
            }
        });
        ctx.setPacketHandled(true);
    }
}

