/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod;

import flash.npcmod.CommonProxy;
import flash.npcmod.capability.quests.IQuestCapability;
import flash.npcmod.capability.quests.QuestCapabilityProvider;
import flash.npcmod.client.gui.screen.FunctionBuilderScreen;
import flash.npcmod.client.gui.screen.NpcBuilderScreen;
import flash.npcmod.client.gui.screen.SavedNpcsScreen;
import flash.npcmod.client.gui.screen.dialogue.DialogueBuilderScreen;
import flash.npcmod.client.gui.screen.dialogue.DialogueScreen;
import flash.npcmod.client.gui.screen.quests.QuestEditorScreen;
import flash.npcmod.core.client.dialogues.ClientDialogueUtil;
import flash.npcmod.core.client.quests.ClientQuestUtil;
import flash.npcmod.core.quests.CommonQuestUtil;
import flash.npcmod.core.quests.Quest;
import flash.npcmod.core.quests.QuestInstance;
import flash.npcmod.core.quests.QuestObjective;
import flash.npcmod.core.trades.TradeOffers;
import flash.npcmod.entity.NpcEntity;
import flash.npcmod.network.PacketDispatcher;
import flash.npcmod.network.packets.client.CCallFunction;
import flash.npcmod.network.packets.client.CRequestQuestInfo;
import flash.npcmod.network.packets.server.SOpenScreen;
import flash.npcmod.network.packets.server.SSyncQuestCapability;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientProxy
extends CommonProxy {
    public static List<String> GLOBAL_NPCS = new ArrayList<String>();
    public static List<String> SAVED_NPCS = new ArrayList<String>();
    public static Map<String, EntityType<?>> ENTITY_TYPES = new HashMap();
    public static Map<String, EntityType<?>> RENDER_ENTITY_TYPES = new HashMap();
    Minecraft minecraft = Minecraft.m_91087_();

    @Override
    public void openScreen(SOpenScreen.EScreens screen, String data, int entityid) {
        Screen toOpen = null;
        NpcEntity npcEntity = (NpcEntity)this.minecraft.f_91073_.m_6815_(entityid);
        switch (screen) {
            case DIALOGUE: {
                toOpen = new DialogueScreen(data, npcEntity);
                break;
            }
            case EDITDIALOGUE: {
                toOpen = new DialogueBuilderScreen(data);
                break;
            }
            case FUNCTIONBUILDER: {
                toOpen = new FunctionBuilderScreen();
                break;
            }
            case EDITNPC: {
                toOpen = new NpcBuilderScreen(npcEntity);
                break;
            }
            case QUESTEDITOR: {
                if (data.isEmpty()) {
                    toOpen = new QuestEditorScreen();
                    break;
                }
                PacketDispatcher.sendToServer(new CRequestQuestInfo(data));
                Quest quest = ClientQuestUtil.loadQuest(data);
                if (quest == null) break;
                toOpen = QuestEditorScreen.fromQuest(quest);
                break;
            }
            case SAVEDNPCS: {
                toOpen = new SavedNpcsScreen(data);
            }
        }
        this.minecraft.m_91152_(toOpen);
    }

    @Override
    public void randomDialogueOption() {
        Screen screen = this.minecraft.f_91080_;
        if (screen instanceof DialogueScreen) {
            DialogueScreen screen2 = (DialogueScreen)screen;
            screen2.chooseRandomOption();
        }
    }

    @Override
    public void moveToDialogue(String dialogueName, int entityid) {
        Screen screen = this.minecraft.f_91080_;
        if (screen instanceof DialogueScreen) {
            DialogueScreen screen2 = (DialogueScreen)screen;
            ClientDialogueUtil.loadDialogue(screen2.getDialogueName());
            ClientDialogueUtil.loadDialogueOption(dialogueName);
            if (!ClientDialogueUtil.getCurrentResponse().isEmpty()) {
                if (!ClientDialogueUtil.getCurrentText().isEmpty()) {
                    screen2.addDisplayedPlayerText(ClientDialogueUtil.getCurrentText());
                }
                screen2.addDisplayedNPCText(ClientDialogueUtil.getCurrentResponse());
            } else if (!ClientDialogueUtil.getCurrentText().isEmpty()) {
                screen2.addDisplayedNPCText(ClientDialogueUtil.getCurrentText());
            }
            if (!ClientDialogueUtil.getCurrentFunction().isEmpty()) {
                PacketDispatcher.sendToServer(new CCallFunction(ClientDialogueUtil.getCurrentFunction(), entityid));
            }
            screen2.resetOptionButtons();
        }
    }

    @Override
    public void closeDialogue() {
        if (this.minecraft.f_91080_ instanceof DialogueScreen) {
            this.minecraft.f_91080_.m_7379_();
        }
    }

    @Override
    public void resetFunctionNames() {
        ClientDialogueUtil.FUNCTION_NAMES.clear();
    }

    @Override
    public void addFunctionName(String functionName) {
        if (!ClientDialogueUtil.FUNCTION_NAMES.contains(functionName)) {
            ClientDialogueUtil.FUNCTION_NAMES.add(functionName);
        }
    }

    @Override
    public boolean shouldSaveInWorld() {
        return this.minecraft.m_91091_();
    }

    @Override
    public void syncTrackedQuest(String trackedQuest) {
        IQuestCapability questCapability = QuestCapabilityProvider.getCapability((Player)this.minecraft.f_91074_);
        questCapability.setTrackedQuest(trackedQuest);
    }

    @Override
    public void syncAcceptedQuests(ArrayList<QuestInstance> acceptedQuests) {
        IQuestCapability questCapability = QuestCapabilityProvider.getCapability((Player)this.minecraft.f_91074_);
        questCapability.setAcceptedQuests(acceptedQuests);
    }

    @Override
    public void syncCompletedQuests(ArrayList<String> completedQuests) {
        IQuestCapability questCapability = QuestCapabilityProvider.getCapability((Player)this.minecraft.f_91074_);
        questCapability.setCompletedQuests(completedQuests);
    }

    @Override
    public void syncQuestProgressMap(Map<QuestObjective, Integer> progressMap) {
        IQuestCapability questCapability = QuestCapabilityProvider.getCapability((Player)this.minecraft.f_91074_);
        Map<QuestObjective, Integer> map = questCapability.getQuestProgressMap();
        map.putAll(progressMap);
    }

    @Override
    public void acceptQuest(String name, int entityid, QuestInstance.TurnInType turnInType, UUID uuid) {
        PacketDispatcher.sendToServer(new CRequestQuestInfo(name));
        Quest quest = ClientQuestUtil.loadQuest(name);
        Entity entity = this.minecraft.f_91074_.f_19853_.m_6815_(entityid);
        if (quest != null && entity instanceof NpcEntity) {
            IQuestCapability capability = QuestCapabilityProvider.getCapability((Player)this.minecraft.f_91074_);
            QuestInstance questInstance = new QuestInstance(quest, uuid, entity.m_7755_().getString(), turnInType, (Player)this.minecraft.f_91074_);
            capability.acceptQuest(questInstance);
        }
    }

    @Override
    public void completeQuest(String name, UUID uuid) {
        IQuestCapability capability = QuestCapabilityProvider.getCapability((Player)this.minecraft.f_91074_);
        QuestInstance instance = null;
        for (QuestInstance current : capability.getAcceptedQuests()) {
            if (!current.getQuest().getName().equals(name) || !current.getPickedUpFrom().equals(uuid)) continue;
            instance = current;
            break;
        }
        if (instance != null) {
            capability.completeQuest(instance);
        }
        ClientQuestUtil.loadQuest(name);
    }

    @Override
    public Player getPlayer() {
        return this.minecraft.f_91074_;
    }

    @Override
    public Level getWorld() {
        return this.minecraft.f_91073_;
    }

    @Override
    public SSyncQuestCapability decodeQuestCapabilitySync(FriendlyByteBuf buf) {
        int typeInt = buf.readInt();
        if (typeInt < 0 || typeInt >= SSyncQuestCapability.CapabilityType.values().length) {
            return new SSyncQuestCapability();
        }
        SSyncQuestCapability.CapabilityType type = SSyncQuestCapability.CapabilityType.values()[typeInt];
        switch (type) {
            default: {
                String trackedName = buf.m_130136_(51);
                if (!trackedName.isEmpty()) {
                    Quest quest = ClientQuestUtil.loadQuest(trackedName);
                    if (quest != null) {
                        return new SSyncQuestCapability(trackedName);
                    }
                    return new SSyncQuestCapability();
                }
                return new SSyncQuestCapability();
            }
            case ACCEPTED_QUESTS: {
                ArrayList<QuestInstance> acceptedQuests = new ArrayList<QuestInstance>();
                int acceptedAmount = buf.readInt();
                for (int i = 0; i < acceptedAmount; ++i) {
                    String questName = buf.m_130136_(51);
                    UUID pickedUpFrom = buf.m_130259_();
                    String pickedUpFromName = buf.m_130136_(200);
                    QuestInstance.TurnInType turnInType = QuestInstance.TurnInType.values()[buf.readInt()];
                    Quest quest = ClientQuestUtil.loadQuest(questName);
                    if (quest == null) continue;
                    acceptedQuests.add(new QuestInstance(quest, pickedUpFrom, pickedUpFromName, turnInType, (Player)this.minecraft.f_91074_, false));
                    block6: for (int j = 0; j < quest.getObjectives().size(); ++j) {
                        int id = buf.readInt();
                        for (int k = 0; k < quest.getObjectives().size(); ++k) {
                            QuestObjective objective = quest.getObjectives().get(k);
                            if (objective.getId() != id) continue;
                            int progress = buf.readInt();
                            boolean isHidden = buf.readBoolean();
                            objective.setProgress(progress);
                            objective.onComplete((Player)this.minecraft.f_91074_);
                            objective.setHidden(isHidden);
                            continue block6;
                        }
                    }
                }
                return new SSyncQuestCapability(acceptedQuests.toArray(new QuestInstance[0]));
            }
            case COMPLETED_QUESTS: {
                ArrayList<String> completedQuests = new ArrayList<String>();
                int completedAmount = buf.readInt();
                for (int i = 0; i < completedAmount; ++i) {
                    String name = buf.m_130136_(51);
                    completedQuests.add(name);
                }
                return new SSyncQuestCapability(completedQuests.toArray(new String[0]));
            }
            case PROGRESS_MAP: 
        }
        HashMap<QuestObjective, Integer> objectiveProgressMap = new HashMap<QuestObjective, Integer>();
        int progressMapAmount = buf.readInt();
        for (int i = 0; i < progressMapAmount; ++i) {
            QuestObjective objective;
            String key = buf.m_130277_();
            String[] splitKey = key.split(":::");
            int progress = buf.readInt();
            Quest quest = ClientQuestUtil.loadQuest(splitKey[0]);
            if (quest == null || (objective = Quest.getObjectiveFromName(quest, splitKey[1])) == null) continue;
            objectiveProgressMap.put(objective, progress);
            objective.setProgress(progress);
        }
        return new SSyncQuestCapability(objectiveProgressMap);
    }

    @Override
    public void syncTrades(int entityid, TradeOffers tradeOffers) {
        Entity entity = this.minecraft.f_91074_.f_19853_.m_6815_(entityid);
        if (entity instanceof NpcEntity) {
            ((NpcEntity)entity).setTradeOffers(tradeOffers);
        }
    }

    @Override
    public void loadSavedNpcs(List<String> savedNpcs, boolean isGlobal) {
        if (isGlobal) {
            GLOBAL_NPCS = savedNpcs;
        } else {
            SAVED_NPCS = savedNpcs;
        }
    }

    @Override
    public void loadEntities(String[] entities) {
        ENTITY_TYPES.clear();
        RENDER_ENTITY_TYPES.clear();
        for (String name : entities) {
            EntityType.m_20632_((String)name).ifPresent(entityType -> {
                ENTITY_TYPES.put(name, (EntityType<?>)entityType);
                if (this.minecraft.m_91290_().f_114362_.get(entityType) instanceof LivingEntityRenderer) {
                    RENDER_ENTITY_TYPES.put(name, (EntityType<?>)entityType);
                }
            });
        }
    }

    @Override
    public void getQuestInfo(String name, String questInfo) {
        CommonQuestUtil.buildQuest(name, questInfo);
    }
}

