/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.capability.quests;

import flash.npcmod.capability.quests.IQuestCapability;
import flash.npcmod.core.quests.CommonQuestUtil;
import flash.npcmod.core.quests.Quest;
import flash.npcmod.core.quests.QuestInstance;
import flash.npcmod.core.quests.QuestObjective;
import flash.npcmod.network.PacketDispatcher;
import flash.npcmod.network.packets.server.SSyncQuestCapability;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class QuestCapability
implements IQuestCapability {
    private String trackedQuest = "";
    private ArrayList<QuestInstance> acceptedQuests = new ArrayList();
    private ArrayList<String> completedQuests = new ArrayList();
    private Map<QuestObjective, Integer> questProgressMap = new HashMap<QuestObjective, Integer>();

    @Override
    public String getTrackedQuest() {
        return this.trackedQuest;
    }

    @Override
    public QuestInstance getTrackedQuestInstance() {
        for (QuestInstance questInstance : this.acceptedQuests) {
            if (!questInstance.getQuest().getName().equals(this.trackedQuest)) continue;
            return questInstance;
        }
        return null;
    }

    @Override
    public ArrayList<QuestInstance> getAcceptedQuests() {
        return this.acceptedQuests;
    }

    @Override
    public ArrayList<String> getCompletedQuests() {
        return this.completedQuests;
    }

    @Override
    public Map<QuestObjective, Integer> getQuestProgressMap() {
        return this.questProgressMap;
    }

    @Override
    public void setTrackedQuest(String quest) {
        this.trackedQuest = quest;
    }

    @Override
    public void setAcceptedQuests(ArrayList<QuestInstance> quests) {
        this.acceptedQuests = quests;
    }

    @Override
    public void setCompletedQuests(ArrayList<String> questNames) {
        this.completedQuests = questNames;
    }

    @Override
    public void setQuestProgressMap(Map<QuestObjective, Integer> map) {
        this.questProgressMap = map;
    }

    @Override
    public void acceptQuest(QuestInstance quest) {
        if (!(quest == null || quest.getQuest() == null || this.acceptedQuests.contains(quest) || !quest.getQuest().isRepeatable() && this.completedQuests.contains(quest.getQuest().getName()))) {
            this.acceptedQuests.add(quest);
            CommonQuestUtil.QUEST_INSTANCE_LIST.add(quest);
            quest.getQuest().getObjectives().forEach(objective -> this.questProgressMap.put((QuestObjective)objective, 0));
            if (this.trackedQuest == null || this.trackedQuest.isEmpty()) {
                this.setTrackedQuest(quest.getQuest().getName());
            }
        }
    }

    @Override
    public void completeQuest(QuestInstance quest) {
        if (this.acceptedQuests.contains(quest) && quest.getQuest().canComplete()) {
            quest.getQuest().complete(quest.getPlayer(), quest.getPickedUpFrom(), quest.getPickedUpFromName(), quest.getTurnInType());
            this.abandonQuest(quest);
            if (!this.completedQuests.contains(quest.getQuest().getName())) {
                this.completedQuests.add(quest.getQuest().getName());
                if (!quest.getPlayer().f_19853_.f_46443_) {
                    PacketDispatcher.sendTo(new SSyncQuestCapability(this.completedQuests.toArray(new String[0])), quest.getPlayer());
                }
            }
        }
    }

    @Override
    public void abandonQuest(QuestInstance quest) {
        if (this.acceptedQuests.contains(quest)) {
            this.acceptedQuests.remove(quest);
            ArrayList markedForRemoval = new ArrayList();
            quest.getQuest().getObjectives().forEach(objective -> this.questProgressMap.keySet().forEach(questObjective -> {
                if (this.objectiveToString((QuestObjective)objective).equals(this.objectiveToString((QuestObjective)questObjective))) {
                    markedForRemoval.add(questObjective);
                }
            }));
            markedForRemoval.forEach(objective -> this.questProgressMap.remove(objective));
            if (this.trackedQuest.equals(quest.getQuest().getName())) {
                this.trackedQuest = "";
            }
            if (CommonQuestUtil.QUEST_INSTANCE_LIST.contains(quest)) {
                CommonQuestUtil.QUEST_INSTANCE_LIST.remove(quest);
            }
        }
    }

    @Override
    public void resetAllQuestProgress() {
        this.trackedQuest = "";
        this.acceptedQuests.clear();
        this.completedQuests.clear();
        this.questProgressMap.clear();
    }

    private String objectiveToString(QuestObjective objective) {
        return objective.getQuest().getName() + ":::" + objective.getName();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (this.getTrackedQuest() != null) {
            tag.m_128359_("trackedQuest", this.getTrackedQuest());
        } else {
            tag.m_128359_("trackedQuest", "");
        }
        ListTag acceptedQuests = new ListTag();
        this.getAcceptedQuests().forEach(quest -> {
            CompoundTag tag2 = new CompoundTag();
            tag2.m_128359_("quest", quest.getQuest().getName());
            tag2.m_128362_("uuid", quest.getPickedUpFrom());
            tag2.m_128359_("npcname", quest.getPickedUpFromName());
            tag2.m_128405_("turnintype", quest.getTurnInType().ordinal());
            acceptedQuests.add((Object)tag2);
        });
        tag.m_128365_("acceptedQuests", (Tag)acceptedQuests);
        ListTag completedQuests = new ListTag();
        for (String questName : this.getCompletedQuests()) {
            CompoundTag tag2 = new CompoundTag();
            tag2.m_128359_("quest", questName);
            completedQuests.add((Object)tag2);
        }
        tag.m_128365_("completedQuests", (Tag)completedQuests);
        ListTag objectiveProgressMap = new ListTag();
        this.getQuestProgressMap().forEach((objective, progress) -> {
            CompoundTag tag2 = new CompoundTag();
            if (objective.getQuest() != null) {
                tag2.m_128405_(objective.getQuest().getName() + ":::" + objective.getName(), objective.getProgress());
                objectiveProgressMap.add((Object)tag2);
            }
        });
        tag.m_128365_("objectiveProgressMap", (Tag)objectiveProgressMap);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        ArrayList<QuestInstance> acceptedQuests = new ArrayList<QuestInstance>();
        ListTag acceptedQuestsTag = (ListTag)tag.m_128423_("acceptedQuests");
        for (int i = 0; i < acceptedQuestsTag.size(); ++i) {
            CompoundTag tag2 = acceptedQuestsTag.m_128728_(i);
            Quest quest = CommonQuestUtil.fromName(tag2.m_128461_("quest"));
            QuestInstance.TurnInType turnInType = QuestInstance.TurnInType.QuestGiver;
            try {
                turnInType = QuestInstance.TurnInType.values()[tag2.m_128451_("turnintype")];
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (quest == null) continue;
            acceptedQuests.add(new QuestInstance(quest, tag2.m_128342_("uuid"), tag2.m_128461_("npcname"), turnInType));
        }
        this.setAcceptedQuests(acceptedQuests);
        this.setTrackedQuest(tag.m_128461_("trackedQuest"));
        ArrayList<String> completedQuests = new ArrayList<String>();
        ListTag completedQuestsTag = (ListTag)tag.m_128423_("completedQuests");
        for (int i = 0; i < completedQuestsTag.size(); ++i) {
            CompoundTag tag2 = completedQuestsTag.m_128728_(i);
            completedQuests.add(tag2.m_128461_("quest"));
        }
        this.setCompletedQuests(completedQuests);
        HashMap<QuestObjective, Integer> objectiveProgressMap = new HashMap<QuestObjective, Integer>();
        ListTag objectiveProgressMapTag = (ListTag)tag.m_128423_("objectiveProgressMap");
        for (int i = 0; i < objectiveProgressMapTag.size(); ++i) {
            QuestObjective objective2;
            CompoundTag tag2 = objectiveProgressMapTag.m_128728_(i);
            String key = tag2.m_128431_().toArray(new String[0])[0];
            int progress2 = tag2.m_128451_(key);
            String[] splitKey = key.split(":::");
            Quest quest = CommonQuestUtil.fromName(splitKey[0]);
            if (quest == null || (objective2 = Quest.getObjectiveFromName(quest, splitKey[1])) == null) continue;
            objectiveProgressMap.put(objective2, progress2);
        }
        this.setQuestProgressMap(objectiveProgressMap);
        this.getQuestProgressMap().forEach((objective, progress) -> {
            for (QuestInstance quest : acceptedQuests) {
                quest.getQuest().getObjectives().forEach(questObjective -> {
                    if (questObjective.equals(objective)) {
                        if (progress >= questObjective.getAmount()) {
                            questObjective.setOnCompleteRan(true);
                        }
                        questObjective.setProgress((int)progress);
                    }
                });
            }
        });
    }
}

