/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.capability.quests;

import flash.npcmod.capability.quests.IQuestCapability;
import flash.npcmod.capability.quests.QuestCapability;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuestCapabilityProvider
implements ICapabilitySerializable<CompoundTag> {
    public static final Capability<IQuestCapability> QUEST_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IQuestCapability>(){});
    public static final ResourceLocation IDENTIFIER = new ResourceLocation("flashnpcs", "quests");
    private LazyOptional<IQuestCapability> instance = LazyOptional.of(QuestCapability::new);

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == QUEST_CAPABILITY) {
            return this.instance.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        return this.instance.map(INBTSerializable::serializeNBT).orElse(new CompoundTag());
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.instance.ifPresent(capability -> capability.deserializeNBT((Tag)nbt));
    }

    public static IQuestCapability getCapability(Player player) {
        return (IQuestCapability)player.getCapability(QUEST_CAPABILITY).orElse((Object)new QuestCapability());
    }
}

