/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.client.gui.dialogue;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import flash.npcmod.core.node.NodeData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Dialogue
extends NodeData {
    private String text;
    private String response;

    public Dialogue(String name) {
        super(name, "", new Dialogue[0]);
        this.text = "";
        this.response = "";
    }

    public Dialogue(String name, String text, String response, String function, Dialogue[] children) {
        super(name, function, children);
        this.text = text;
        this.response = response;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dialogue dialogue = (Dialogue)o;
        return this.name.equals(dialogue.name) && this.text.equals(dialogue.text) && this.response.equals(dialogue.response) && this.function.equals(dialogue.function) && this.children.equals(dialogue.children);
    }

    public static Dialogue fromJSONObject(JsonObject object) {
        Dialogue[] children = new Dialogue[]{};
        if (object.has("children")) {
            JsonArray currentChildren = object.getAsJsonArray("children");
            children = new Dialogue[currentChildren.size()];
            for (int i = 0; i < currentChildren.size(); ++i) {
                Dialogue childDialogue;
                JsonObject currentChild = currentChildren.get(i).getAsJsonObject();
                children[i] = childDialogue = Dialogue.fromJSONObject(currentChild);
            }
        }
        String name = object.get("name").getAsString();
        String text = object.get("text").getAsString();
        String response = object.has("response") ? object.get("response").getAsString() : "";
        String function = object.has("function") ? object.get("function").getAsString() : "";
        return new Dialogue(name, text, response, function, children);
    }

    public Dialogue[] getChildren() {
        Dialogue[] children = new Dialogue[this.children.size()];
        int i = 0;
        for (NodeData child : this.children) {
            children[i++] = (Dialogue)child;
        }
        return children;
    }

    public String getText() {
        return this.text;
    }

    public String getResponse() {
        return this.response;
    }

    public static Dialogue[] multipleFromJSONObject(JsonObject object) {
        if (object.has("entries")) {
            JsonArray entries = object.getAsJsonArray("entries");
            int dialogueCount = entries.size();
            if (object.has("dialogueCount")) {
                dialogueCount = object.get("dialogueCount").getAsInt();
            }
            Dialogue[] dialogues = new Dialogue[dialogueCount];
            dialogueCount = 0;
            for (int i = 0; i < entries.size() && dialogueCount < dialogues.length; ++i) {
                JsonObject nodeJson = entries.get(i).getAsJsonObject();
                if (nodeJson.has("type") && !nodeJson.get("type").getAsString().equals("dialogue")) continue;
                dialogues[dialogueCount] = Dialogue.fromJSONObject(nodeJson);
                ++dialogueCount;
            }
            return dialogues;
        }
        return new Dialogue[]{Dialogue.fromJSONObject(object)};
    }

    public static Dialogue newDialogue() {
        return new Dialogue("newDialogueNode", "New Node", "", "", new Dialogue[0]);
    }

    public void setResponse(String response) {
        this.response = response;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public JsonObject toJSON() {
        JsonObject dialogueObject = super.toJSON();
        dialogueObject.addProperty("text", this.text);
        dialogueObject.addProperty("response", this.response);
        return dialogueObject;
    }
}

