/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.client.gui.dialogue;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import flash.npcmod.client.gui.dialogue.Dialogue;
import flash.npcmod.client.gui.screen.TreeBuilderScreen;
import flash.npcmod.client.gui.screen.dialogue.DialogueBuilderScreen;
import flash.npcmod.core.node.BuilderNode;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DialogueNode
extends BuilderNode {
    protected static final int NUM_EXTRA_FIELDS = 3;
    protected Dialogue nodeData;

    public DialogueNode(@Nullable DialogueNode parent, DialogueBuilderScreen screen, Minecraft minecraft, Dialogue dialogue) {
        this(parent, screen, minecraft, dialogue, 2, 2);
    }

    public DialogueNode(@Nullable DialogueNode parent, DialogueBuilderScreen screen, Minecraft minecraft, Dialogue dialogue, int x, int y) {
        this(parent, screen, minecraft, dialogue, x, y, 50);
    }

    public DialogueNode(@Nullable DialogueNode parent, DialogueBuilderScreen screen, Minecraft minecraft, Dialogue dialogue, int x, int y, int width) {
        super(screen, minecraft, x, y, width);
        this.nodeData = dialogue;
        this.setParent(parent);
    }

    @Override
    public void calculateDimensions() {
        String text = this.getText();
        this.adjustWidth(text);
        String response = this.getResponse();
        this.adjustWidth(response);
        for (int i = 0; i < this.getConnectionNames().length; ++i) {
            this.adjustWidth(this.getConnectionNames()[i]);
        }
        super.calculateDimensions();
        List trimmedText = this.minecraft.f_91062_.m_92923_((FormattedText)new TextComponent(text), this.width - 4);
        int numOfTextLines = trimmedText.size() > 0 ? trimmedText.size() : 1;
        this.extraFieldsHeight[0] = defaultTextHeight * numOfTextLines;
        this.actualHeight += this.extraFieldsHeight[0] + 1;
        List trimmedResponse = this.minecraft.f_91062_.m_92923_((FormattedText)new TextComponent(response), this.width - 4);
        int numOfResponseLines = trimmedResponse.size() > 0 ? trimmedResponse.size() : 1;
        this.extraFieldsHeight[1] = this.isStart() ? -1 : defaultTextHeight * numOfResponseLines;
        this.actualHeight += this.extraFieldsHeight[1] + 1;
    }

    @Override
    public void clickedOn(double mouseX, double mouseY, int button, int offsetX, int offsetY, double scrollX, double scrollY) {
        if (this.isVisible(scrollX, scrollY)) {
            double minX = (double)(offsetX + 9) + (scrollX + (double)this.x);
            double maxX = minX + (double)this.width;
            double minY = (double)(offsetY + 18 + 1) + (scrollY + (double)this.y);
            double maxY = minY + (double)this.actualHeight;
            if (mouseX >= minX && mouseX <= maxX && mouseY >= minY && mouseY <= maxY) {
                if (this.checkIfConnectingNodes()) {
                    return;
                }
                if (mouseY >= minY && mouseY <= minY + (double)this.nameBarHeight) {
                    this.clickedOnNameBar(button);
                    return;
                }
                if (mouseY >= (minY += (double)(this.nameBarHeight + 1)) && mouseY <= minY + (double)this.extraFieldsHeight[0]) {
                    this.clickedOnTextBar();
                    return;
                }
                minY += (double)(this.extraFieldsHeight[0] + 1);
                if (!this.isStart() && mouseY >= minY && mouseY <= minY + (double)this.extraFieldsHeight[1]) {
                    this.clickedOnResponseBar();
                    return;
                }
                if (mouseY >= (minY += (double)(this.extraFieldsHeight[1] + 1)) && mouseY <= minY + (double)this.functionBarHeight) {
                    this.clickedOnFunctionBar();
                    return;
                }
                double optionMinY = minY + (double)this.functionBarHeight + 1.0;
                if (this.getOptionsText().length > 0) {
                    int optionIndex = -2;
                    for (int i = 0; i < this.getOptionsText().length + 1; ++i) {
                        if (this.connectionBarsHeights.length <= i) continue;
                        if (mouseY >= optionMinY) {
                            double d = optionMinY + (double)this.connectionBarsHeights[i];
                            int n = i == 0 ? 0 : 2;
                            if (mouseY <= d + (double)n) {
                                optionIndex = i;
                                break;
                            }
                        }
                        optionMinY += (double)(this.connectionBarsHeights[i] + 1);
                    }
                    if (optionIndex == this.getOptionsText().length) {
                        optionIndex = -1;
                    }
                    if (optionIndex >= -1 && optionIndex < this.getOptionsText().length) {
                        this.clickedOnOptionBar(optionIndex, button);
                        return;
                    }
                } else if (mouseY >= optionMinY && mouseY <= optionMinY + (double)defaultTextHeight) {
                    this.clickedOnOptionBar(-1, button);
                    return;
                }
            }
            if (button == 0) {
                int[] xy;
                if (!this.isStart() && mouseX >= minX - 12.0 && mouseX <= minX - 12.0 + 8.0 && mouseY >= (minY = (double)(offsetY + 18 + 1) + (scrollY + (double)this.y)) + (double)(xy = this.getEndPointLocation())[1] && mouseY <= minY + (double)xy[1] + 8.0) {
                    this.clickedOnSelectIcon(-2);
                    return;
                }
                if (mouseX >= maxX + 4.0 && mouseX <= maxX + 4.0 + 8.0) {
                    minY = (double)(offsetY + 18 + 1) + (scrollY + (double)this.y);
                    for (int i = 0; i < this.getConnectionNames().length; ++i) {
                        int[] xy2 = this.getStartPointLocation(i);
                        if (!(mouseY >= minY + (double)xy2[1]) || !(mouseY <= minY + (double)xy2[1] + 8.0)) continue;
                        this.clickedOnSelectIcon(i);
                        return;
                    }
                    int[] xy3 = this.getStartPointLocation(this.getConnectionNames().length);
                    if (mouseY >= minY + (double)xy3[1] && mouseY <= minY + (double)xy3[1] + 8.0) {
                        this.clickedOnSelectIcon(-1);
                        return;
                    }
                }
                if (mouseX >= minX - 9.0 && mouseX <= minX - 2.0) {
                    minY = (double)(offsetY + 18 + 1) + (scrollY + (double)this.y) - 9.0;
                    maxY = minY + 7.0;
                    if (mouseY >= minY && mouseY <= maxY) {
                        this.dragging = true;
                    }
                }
            }
        }
    }

    public void clickedOnResponseBar() {
        this.builderScreen.setNodeBeingEdited(this, TreeBuilderScreen.EditType.RESPONSE);
    }

    public void clickedOnTextBar() {
        this.builderScreen.setNodeBeingEdited(this, TreeBuilderScreen.EditType.TEXT);
    }

    @Override
    protected int drawExtraRectangles(PoseStack matrixStack, int minY) {
        int black = -16777216;
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)1, (int)(minY += 1 + this.extraFieldsHeight[0]), (int)(this.width - 1), (int)(minY + 1), (int)black);
        minY += 1 + this.extraFieldsHeight[1];
        if (!this.isStart()) {
            GuiComponent.m_93172_((PoseStack)matrixStack, (int)1, (int)minY, (int)(this.width - 1), (int)(minY + 1), (int)black);
        }
        return minY;
    }

    @Override
    protected int drawExtraTexts(PoseStack matrixStack, int minY) {
        String text = this.getText();
        String response = this.getResponse();
        this.drawMultilineText(matrixStack, text.isEmpty() ? "Text" : text, minY, text.isEmpty());
        minY += this.extraFieldsHeight[0] + 1;
        if (!this.isStart()) {
            this.drawMultilineText(matrixStack, response.isEmpty() ? "Response" : response, minY, response.isEmpty());
        }
        return minY += this.extraFieldsHeight[1] + 1;
    }

    @Override
    protected void drawIcons(PoseStack matrixStack) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURES);
        GuiComponent.m_93160_((PoseStack)matrixStack, (int)-9, (int)-9, (int)7, (int)7, (float)8.0f, (float)0.0f, (int)7, (int)7, (int)256, (int)256);
        if (!this.isStart() || this.equals(this.builderScreen.getSelectedNode()) && this.builderScreen.getSelectedNodeIndex() == 0) {
            int[] xy = this.getEndPointLocation();
            GuiComponent.m_93160_((PoseStack)matrixStack, (int)xy[0], (int)xy[1], (int)8, (int)8, (float)0.0f, (float)0.0f, (int)8, (int)8, (int)256, (int)256);
        }
        if (this.parent != null) {
            matrixStack.m_85836_();
            int x = this.x - this.parent.getX();
            int y = this.y - this.parent.getY();
            matrixStack.m_85837_((double)(-x), (double)(-y), 0.0);
            int index = Arrays.asList(this.parent.getNodeData().getChildren()).indexOf(this.getNodeData());
            if (index >= 0 && index < this.parent.getConnectionBarsHeights().length) {
                int[] xy = this.parent.getStartPointLocation(index);
                GuiComponent.m_93160_((PoseStack)matrixStack, (int)xy[0], (int)xy[1], (int)8, (int)8, (float)0.0f, (float)0.0f, (int)8, (int)8, (int)256, (int)256);
            }
            matrixStack.m_85849_();
        }
        matrixStack.m_85836_();
        for (int i = 0; i < this.connectionBarsHeights.length; ++i) {
            int[] xy = this.getStartPointLocation(i);
            GuiComponent.m_93160_((PoseStack)matrixStack, (int)xy[0], (int)xy[1], (int)8, (int)8, (float)0.0f, (float)0.0f, (int)8, (int)8, (int)256, (int)256);
        }
        matrixStack.m_85849_();
    }

    @Override
    protected void drawLinesToParent(PoseStack matrixStack) {
        if (this.parent != null) {
            int index = 0;
            for (int i = 0; i < this.parent.getConnectionNames().length; ++i) {
                if (!this.parent.getConnectionNames()[i].equals(this.getName())) continue;
                index = i + 1;
                break;
            }
            if (index > 0 && index < this.parent.getConnectionNames().length + 1) {
                int[] thisXY = this.getEndPointLocation();
                int[] parentXY = this.parent.getStartPointLocation(index - 1);
                int thisX = this.x + thisXY[0];
                int thisY = this.y + thisXY[1];
                int parentX = this.parent.getX() + parentXY[0];
                int parentY = this.parent.getY() + parentXY[1];
                int color = -256;
                matrixStack.m_85836_();
                matrixStack.m_85837_((double)thisXY[0], (double)thisXY[1], 0.0);
                matrixStack.m_85837_(3.5, 3.5, 0.0);
                int lineLength = -(thisX - parentX);
                int lineHeight = -(thisY - parentY);
                GuiComponent.m_93172_((PoseStack)matrixStack, (int)0, (int)0, (int)(lineLength / 2), (int)1, (int)color);
                GuiComponent.m_93172_((PoseStack)matrixStack, (int)(lineLength / 2), (int)0, (int)(lineLength / 2 + 1), (int)lineHeight, (int)color);
                GuiComponent.m_93172_((PoseStack)matrixStack, (int)(lineLength / 2 + 1), (int)lineHeight, (int)lineLength, (int)(lineHeight + 1), (int)color);
                matrixStack.m_85849_();
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DialogueNode that = (DialogueNode)o;
        return this.x == that.x && this.y == that.y && this.width == that.width && this.actualHeight == that.actualHeight && this.nodeData.equals(that.nodeData);
    }

    @Override
    public Dialogue getNodeData() {
        return this.nodeData;
    }

    @Override
    public int getNumExtraFields() {
        return 3;
    }

    private String[] getOptionsText() {
        String[] options = new String[this.nodeData.getChildren().length];
        for (int i = 0; i < options.length; ++i) {
            options[i] = this.nodeData.getChildren()[i].getText();
        }
        return options;
    }

    public String getResponse() {
        return this.nodeData.getResponse();
    }

    public String getText() {
        return this.nodeData.getText();
    }

    @Override
    public void setParent(@Nullable BuilderNode node) {
        if (!this.equals(node)) {
            if (this.parent != null) {
                this.parent.removeChild(this.getNodeData());
            }
            if (node != null) {
                node.addChild(this.getNodeData());
            } else if (this.builderScreen.getSelectedNode() == null) {
                this.getNodeData().setResponse("");
            }
            this.parent = node;
            this.calculateDimensions();
        }
    }
}

