/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import flash.npcmod.capability.quests.IQuestCapability;
import flash.npcmod.capability.quests.QuestCapabilityProvider;
import flash.npcmod.core.client.ScreenHelper;
import flash.npcmod.core.quests.Quest;
import flash.npcmod.core.quests.QuestInstance;
import flash.npcmod.core.quests.QuestObjective;
import flash.npcmod.events.ClientEvents;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class HudOverlay
extends GuiComponent {
    private static int width;
    private static int height;
    private static final Minecraft minecraft;
    private static final ResourceLocation TEXTURES;
    private static String previousTrackedQuest;
    private static int trackedQuestUpdateTick;

    public HudOverlay() {
        previousTrackedQuest = "";
        trackedQuestUpdateTick = 0;
    }

    @SubscribeEvent
    public void renderGameOverlay(RenderGameOverlayEvent.Pre event) {
        if (HudOverlay.minecraft.f_91074_ != null && HudOverlay.minecraft.f_91074_.m_6084_() && event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            width = Minecraft.m_91087_().m_91268_().m_85445_();
            height = Minecraft.m_91087_().m_91268_().m_85446_();
            PoseStack matrixStack = event.getMatrixStack();
            IQuestCapability questCapability = QuestCapabilityProvider.getCapability((Player)HudOverlay.minecraft.f_91074_);
            this.renderTrackedQuest(matrixStack, questCapability);
        }
    }

    private void renderTrackedQuest(PoseStack matrixStack, IQuestCapability capability) {
        QuestInstance trackedQuestInstance = capability.getTrackedQuestInstance();
        if (trackedQuestInstance != null) {
            Quest trackedQuest = trackedQuestInstance.getQuest();
            String name = trackedQuest.getDisplayName();
            List<QuestObjective> objectives = trackedQuest.getObjectives();
            ArrayList visibleObjectives = new ArrayList();
            objectives.forEach(objective -> {
                if (!objective.isHidden()) {
                    visibleObjectives.add(objective);
                }
            });
            int oneFourthWidth = width / 4;
            int gradientOffset = 20;
            int nameWidth = HudOverlay.minecraft.f_91062_.m_92895_(name);
            int actualWidth = Math.min(oneFourthWidth, nameWidth);
            List multiLineName = HudOverlay.minecraft.f_91062_.m_92923_((FormattedText)new TextComponent(name), actualWidth);
            int n = multiLineName.size();
            Objects.requireNonNull(HudOverlay.minecraft.f_91062_);
            int nameHeight = 5 + n * (9 + 2);
            int n2 = visibleObjectives.size();
            Objects.requireNonNull(HudOverlay.minecraft.f_91062_);
            int objectivesHeight = 6 + n2 * (9 + 2);
            int hudWidth = actualWidth + gradientOffset + 2;
            int hudX = width - hudWidth;
            int hudY = height / 2 - (nameHeight + objectivesHeight) / 2;
            int nameBackgroundColor = -1442840576;
            ScreenHelper.sidewaysFillGradient(matrixStack, hudX, hudY - 1, hudX + gradientOffset, hudY + nameHeight, 0, nameBackgroundColor);
            HudOverlay.m_93172_((PoseStack)matrixStack, (int)(hudX + gradientOffset), (int)(hudY - 1), (int)width, (int)(hudY + nameHeight), (int)nameBackgroundColor);
            int lineColor = -1728053248;
            ScreenHelper.sidewaysFillGradient(matrixStack, hudX, hudY, hudX + gradientOffset, hudY + 1, 0x22000000, lineColor);
            HudOverlay.m_93172_((PoseStack)matrixStack, (int)(hudX + gradientOffset), (int)hudY, (int)width, (int)(hudY + 1), (int)lineColor);
            ScreenHelper.sidewaysFillGradient(matrixStack, hudX, hudY + nameHeight - 2, hudX + gradientOffset, hudY + nameHeight - 1, 0x22000000, lineColor);
            HudOverlay.m_93172_((PoseStack)matrixStack, (int)(hudX + gradientOffset), (int)(hudY + nameHeight - 2), (int)width, (int)(hudY + nameHeight - 1), (int)lineColor);
            ResourceLocation icon = trackedQuest.canComplete() ? ClientEvents.QUEST_COMPLETE_ICON : ClientEvents.QUEST_ICON;
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)icon);
            Objects.requireNonNull(HudOverlay.minecraft.f_91062_);
            int iconWidth = 9 + 2;
            HudOverlay.m_93160_((PoseStack)matrixStack, (int)(hudX + 3), (int)(hudY + (nameHeight - iconWidth) / 2), (int)iconWidth, (int)iconWidth, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
            for (int i = 0; i < multiLineName.size(); ++i) {
                FormattedCharSequence processor = (FormattedCharSequence)multiLineName.get(i);
                int nameW = (int)HudOverlay.minecraft.f_91062_.m_92865_().m_92336_(processor);
                int offset = (actualWidth - nameW) / 2;
                Font font = HudOverlay.minecraft.f_91062_;
                float f = width - 5 - actualWidth + offset;
                Objects.requireNonNull(HudOverlay.minecraft.f_91062_);
                font.m_92877_(matrixStack, processor, f, (float)(hudY + 4 + (9 + 2) * i), 0xFFFF00);
            }
            ScreenHelper.sidewaysFillGradient(matrixStack, hudX, hudY + nameHeight, width, hudY + nameHeight + objectivesHeight, 0, -2030043136);
            for (int i = 0; i < visibleObjectives.size(); ++i) {
                QuestObjective objective2 = (QuestObjective)visibleObjectives.get(i);
                Objects.requireNonNull(HudOverlay.minecraft.f_91062_);
                int y = hudY + nameHeight + 3 + i * (9 + 2);
                Objects.requireNonNull(HudOverlay.minecraft.f_91062_);
                int iconSize = 9 + 2;
                int x = width - iconSize - 2;
                HudOverlay.drawObjective(matrixStack, x, y, objective2, oneFourthWidth);
            }
        }
    }

    public static void drawObjective(PoseStack matrixStack, int x, int y, QuestObjective objective, int maxObjectiveNameWidth) {
        String progress = objective.getProgress() + "/" + objective.getAmount();
        String addon = ": " + (String)(objective.shouldDisplayProgress() ? progress + " " : "");
        String objectiveName = objective.getName() + addon;
        int objectiveNameWidth = HudOverlay.minecraft.f_91062_.m_92895_(objectiveName);
        if (maxObjectiveNameWidth > 0 && objectiveNameWidth > maxObjectiveNameWidth) {
            objectiveName = HudOverlay.minecraft.f_91062_.m_92834_(objective.getName(), maxObjectiveNameWidth - HudOverlay.minecraft.f_91062_.m_92895_(addon) - HudOverlay.minecraft.f_91062_.m_92895_("...")) + "..." + addon;
            objectiveNameWidth = maxObjectiveNameWidth;
        }
        boolean isOptional = objective.isOptional();
        Objects.requireNonNull(HudOverlay.minecraft.f_91062_);
        int iconSize = 9 + 2;
        HudOverlay.m_93236_((PoseStack)matrixStack, (Font)HudOverlay.minecraft.f_91062_, (String)objectiveName, (int)(x - 2 - objectiveNameWidth), (int)(y + 2), (int)(isOptional ? 9877503 : 0xFFFFFF));
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURES);
        HudOverlay.m_93160_((PoseStack)matrixStack, (int)x, (int)y, (int)iconSize, (int)iconSize, (float)(objective.isComplete() ? 24.0f : (float)(isOptional ? 48 : 0)), (float)0.0f, (int)24, (int)24, (int)256, (int)256);
    }

    static {
        minecraft = Minecraft.m_91087_();
        TEXTURES = new ResourceLocation("flashnpcs", "textures/gui/hud.png");
    }
}

