/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.client.gui.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import flash.npcmod.network.PacketDispatcher;
import flash.npcmod.network.packets.client.CBuildFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FunctionBuilderScreen
extends Screen {
    private String name = "";
    private String parameterNames = "";
    private String callable = "";
    private final List<String> callables;
    private EditBox nameField;
    private EditBox parametersField;
    private EditBox callableField;
    private Button addCallableButton;
    private Button confirmButton;
    private Button[] removeCallableButtons;
    private static int maxCallables;
    private static final int lineHeight;
    private static final String NAME = "Name: ";
    private static final String PARAMNAMES = "Parameter Names: ";
    private static final String RUNNABLES = "Runnables: ";
    private int scrollY;
    private final Predicate<String> paramFilter = text -> {
        Pattern pattern = Pattern.compile("\\s");
        Matcher matcher = pattern.matcher((CharSequence)text);
        return !matcher.find();
    };

    public FunctionBuilderScreen() {
        super(TextComponent.f_131282_);
        this.callables = new ArrayList<String>();
    }

    protected void m_7856_() {
        this.nameField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, 5 + this.f_96547_.m_92895_(NAME), 5, 100, 20, TextComponent.f_131282_));
        this.nameField.m_94151_(this::setName);
        this.nameField.m_94153_(this.paramFilter);
        this.nameField.m_94199_(50);
        this.nameField.m_94144_(this.name);
        this.parametersField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, 5 + this.f_96547_.m_92895_(PARAMNAMES), 30, 100, 20, TextComponent.f_131282_));
        this.parametersField.m_94151_(this::setParameterNames);
        this.parametersField.m_94153_(this.paramFilter);
        this.parametersField.m_94199_(100);
        this.parametersField.m_94144_(this.parameterNames);
        this.callableField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, 5 + this.f_96547_.m_92895_(RUNNABLES), 55, 100, 20, TextComponent.f_131282_));
        this.callableField.m_94151_(this::setCallable);
        this.callableField.m_94199_(250);
        this.callableField.m_94144_("");
        this.addCallableButton = (Button)this.m_142416_((GuiEventListener)new Button(115 + this.f_96547_.m_92895_(RUNNABLES), 55, 20, 20, (Component)new TextComponent("+"), btn -> {
            if (this.canAddCallable()) {
                this.callables.add(this.callable);
            }
            this.callableField.m_94144_("");
        }));
        this.addCallableButton.f_93623_ = this.canAddCallable();
        this.confirmButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ - 50, this.f_96544_ - 20, 50, 20, (Component)new TextComponent("Confirm"), btn -> {
            PacketDispatcher.sendToServer(new CBuildFunction(this.name, this.build()));
            this.m_7379_();
        }));
        this.confirmButton.f_93623_ = this.name.length() > 0 && this.callables.size() > 0;
        maxCallables = (this.f_96544_ - 110) / lineHeight;
        this.removeCallableButtons = new Button[maxCallables];
        for (int i = 0; i < maxCallables; ++i) {
            int j = i;
            this.removeCallableButtons[i] = (Button)this.m_142416_((GuiEventListener)new Button(5, 78 + i * lineHeight, 11, 11, (Component)new TextComponent("-"), btn -> this.removeCallable(j)));
            this.removeCallableButtons[i].f_93624_ = false;
        }
    }

    private boolean canAddCallable() {
        return this.callable.startsWith("function:") || this.callable.startsWith("/");
    }

    private void removeCallable(int i) {
        if (i + this.scrollY < this.callables.size()) {
            this.callables.remove(i + this.scrollY);
            this.scrollY = this.clampScroll(this.scrollY - 1);
        }
    }

    private void setName(String s) {
        this.name = s;
    }

    private void setParameterNames(String s) {
        this.parameterNames = s;
    }

    private void setCallable(String s) {
        this.callable = s;
    }

    public void m_96624_() {
        this.nameField.m_94120_();
        this.parametersField.m_94120_();
        this.callableField.m_94120_();
        this.addCallableButton.f_93623_ = this.canAddCallable();
        this.confirmButton.f_93623_ = this.name.length() > 0 && this.callables.size() > 0;
        for (int i = 0; i < this.removeCallableButtons.length; ++i) {
            this.removeCallableButtons[i].f_93624_ = this.callables.size() > i + this.scrollY;
        }
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        Objects.requireNonNull(this.f_96547_);
        int center = (20 - 9) / 2;
        FunctionBuilderScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)NAME, (int)5, (int)(5 + center), (int)0xFFFFFF);
        FunctionBuilderScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)PARAMNAMES, (int)5, (int)(30 + center), (int)0xFFFFFF);
        FunctionBuilderScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)RUNNABLES, (int)5, (int)(55 + center), (int)0xFFFFFF);
        int size = this.callables.size();
        for (int i = 0; i < Math.min(size, maxCallables); ++i) {
            if (this.callables.size() <= i + this.scrollY) continue;
            FunctionBuilderScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)this.callables.get(i + this.scrollY), (int)20, (int)(80 + i * lineHeight), (int)0xFFFFFF);
        }
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        this.scrollY = delta > 0.0 ? this.clampScroll(this.scrollY - 1) : this.clampScroll(this.scrollY + 1);
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public int clampScroll(int newScroll) {
        int max = this.callables.size() - maxCallables;
        if (max > 0) {
            return Mth.m_14045_((int)newScroll, (int)0, (int)max);
        }
        return 0;
    }

    private String build() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.parameterNames).append("\n");
        for (int i = 0; i < this.callables.size(); ++i) {
            sb.append(this.callables.get(i));
            if (i >= this.callables.size() - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    static {
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        lineHeight = 9 + 2;
    }
}

