/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.client.gui.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.StringReader;
import flash.npcmod.client.gui.widget.ColorSliderWidget;
import flash.npcmod.client.gui.widget.CustomCheckbox;
import flash.npcmod.client.gui.widget.EntityDropdownWidget;
import flash.npcmod.client.gui.widget.EnumDropdownWidget;
import flash.npcmod.core.ColorUtil;
import flash.npcmod.entity.NpcEntity;
import flash.npcmod.init.EntityInit;
import flash.npcmod.network.PacketDispatcher;
import flash.npcmod.network.packets.client.CEditNpc;
import flash.npcmod.network.packets.client.CRequestContainer;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class NpcBuilderScreen
extends Screen {
    private static final ResourceLocation CHAIN_LINK_TEXTURE = new ResourceLocation("flashnpcs", "textures/gui/chain_icon.png");
    private final NpcEntity npcEntity;
    private final NpcData originalData;
    private final NpcData currentData;
    private final CompoundTag originalRendererTagCopy;
    public EditBox redField;
    public EditBox greenField;
    public EditBox blueField;
    public EditBox scaleXField;
    public EditBox scaleYField;
    public EditBox scaleZField;
    public EditBox rendererTagField;
    public EditBox textureField;
    private Checkbox slimCheckBox;
    private Checkbox nameVisibleCheckbox;
    private Checkbox isResourceLocationCheckbox;
    private Checkbox collisionCheckbox;
    private CustomCheckbox scaleLinkCheckbox;
    private ColorSliderWidget redSlider;
    private ColorSliderWidget greenSlider;
    private ColorSliderWidget blueSlider;
    private EnumDropdownWidget<CEditNpc.NPCPose> poseDropdown;
    private EntityDropdownWidget rendererDropdown;
    private int r;
    private int g;
    private int b;
    private boolean isConfirmClose;
    private static int minX;
    private final Predicate<String> textFilter = text -> {
        Pattern pattern = Pattern.compile("\\s");
        Matcher matcher = pattern.matcher((CharSequence)text);
        return !matcher.find();
    };
    private final Predicate<String> colorFilter = text -> {
        if (text.isEmpty()) {
            return true;
        }
        try {
            int i = Integer.parseInt(text);
            return i >= 0 && i <= 255;
        }
        catch (NumberFormatException e) {
            return false;
        }
    };
    private final Predicate<String> scaleFilter = text -> {
        if (text.isEmpty()) {
            return true;
        }
        try {
            float f = Float.parseFloat(text);
            return f >= 0.0f && f <= 15.0f;
        }
        catch (NumberFormatException e) {
            return false;
        }
    };

    public NpcBuilderScreen(NpcEntity npcEntity) {
        super(TextComponent.f_131282_);
        this.npcEntity = npcEntity;
        this.originalData = NpcData.fromNpc(npcEntity);
        this.currentData = NpcData.fromNpc(npcEntity);
        this.originalRendererTagCopy = this.originalData.rendererTag.m_6426_();
        this.r = ColorUtil.hexToR(this.currentData.textColor);
        this.g = ColorUtil.hexToG(this.currentData.textColor);
        this.b = ColorUtil.hexToB(this.currentData.textColor);
    }

    private static int max(int ... numbers) {
        int max = numbers[0];
        for (int i = 1; i < numbers.length; ++i) {
            if (numbers[i] <= max) continue;
            max = numbers[i];
        }
        return max;
    }

    protected void m_7856_() {
        minX = 5 + NpcBuilderScreen.max(this.f_96547_.m_92895_("Name: "), this.f_96547_.m_92895_("Texture: "), this.f_96547_.m_92895_("Dialogue: "), this.f_96547_.m_92895_("Text Color: "), this.f_96547_.m_92895_("Behavior: "), this.f_96547_.m_92895_("Title: "));
        EditBox nameField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, minX, 5, 120, 20, TextComponent.f_131282_));
        nameField.m_94151_(this::setName);
        nameField.m_94199_(200);
        nameField.m_94144_(this.currentData.name);
        this.nameVisibleCheckbox = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(minX + 130 + this.f_96547_.m_92895_("Visible? "), 5, 20, 20, TextComponent.f_131282_, this.currentData.isNameVisible));
        EditBox titleField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, minX, 30, 120, 20, TextComponent.f_131282_));
        titleField.m_94151_(this::setTitle);
        titleField.m_94199_(200);
        titleField.m_94144_(this.currentData.title);
        this.textureField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, minX, 55, 120, 20, TextComponent.f_131282_));
        this.textureField.m_94151_(this::setTexture);
        this.textureField.m_94153_(this.textFilter);
        this.textureField.m_94199_(200);
        this.textureField.m_94144_(this.currentData.texture);
        EditBox dialogueField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, minX, 80, 120, 20, TextComponent.f_131282_));
        dialogueField.m_94151_(this::setDialogue);
        dialogueField.m_94153_(this.textFilter);
        dialogueField.m_94199_(200);
        dialogueField.m_94144_(this.currentData.dialogue);
        this.slimCheckBox = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(minX + 130 + this.f_96547_.m_92895_("Slim? "), 30, 20, 20, TextComponent.f_131282_, this.currentData.isSlim));
        this.slimCheckBox.f_93623_ = this.currentData.renderedType == EntityInit.NPC_ENTITY.get();
        this.isResourceLocationCheckbox = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(minX + 155 + this.f_96547_.m_92895_("Slim? ") + this.f_96547_.m_92895_("ResourceLocation? "), 30, 20, 20, TextComponent.f_131282_, this.currentData.isTextureResourceLocation));
        this.redSlider = (ColorSliderWidget)this.m_142416_((GuiEventListener)new ColorSliderWidget(this, minX, 130, 20, 75, ColorSliderWidget.Color.RED));
        this.greenSlider = (ColorSliderWidget)this.m_142416_((GuiEventListener)new ColorSliderWidget(this, minX + 30, 130, 20, 75, ColorSliderWidget.Color.GREEN));
        this.blueSlider = (ColorSliderWidget)this.m_142416_((GuiEventListener)new ColorSliderWidget(this, minX + 60, 130, 20, 75, ColorSliderWidget.Color.BLUE));
        this.redField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, minX - 5, 210, 30, 20, TextComponent.f_131282_));
        this.redField.m_94151_(this::setRFromString);
        this.redField.m_94153_(this.colorFilter);
        this.redField.m_94199_(3);
        this.redField.m_94144_(String.valueOf(this.r));
        this.greenField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, minX + 25, 210, 30, 20, TextComponent.f_131282_));
        this.greenField.m_94151_(this::setGFromString);
        this.greenField.m_94153_(this.colorFilter);
        this.greenField.m_94199_(3);
        this.greenField.m_94144_(String.valueOf(this.g));
        this.blueField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, minX + 55, 210, 30, 20, TextComponent.f_131282_));
        this.blueField.m_94151_(this::setBFromString);
        this.blueField.m_94153_(this.colorFilter);
        this.blueField.m_94199_(3);
        this.blueField.m_94144_(String.valueOf(this.b));
        this.scaleLinkCheckbox = (CustomCheckbox)this.m_142416_((GuiEventListener)new CustomCheckbox(minX + 235 + this.f_96547_.m_92895_("Scale: "), 54, 22, 22, TextComponent.f_131282_, false, CHAIN_LINK_TEXTURE));
        this.scaleXField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, minX + 130 + this.f_96547_.m_92895_("Scale: "), 55, 30, 20, TextComponent.f_131282_));
        this.scaleXField.m_94151_(this::setScaleXFromString);
        this.scaleXField.m_94153_(this.scaleFilter);
        this.scaleXField.m_94199_(5);
        this.scaleXField.m_94144_(String.valueOf(this.currentData.scaleX));
        this.scaleYField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, minX + 165 + this.f_96547_.m_92895_("Scale: "), 55, 30, 20, TextComponent.f_131282_));
        this.scaleYField.m_94151_(this::setScaleYFromString);
        this.scaleYField.m_94153_(this.scaleFilter);
        this.scaleYField.m_94199_(5);
        this.scaleYField.m_94144_(String.valueOf(this.currentData.scaleY));
        this.scaleZField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, minX + 200 + this.f_96547_.m_92895_("Scale: "), 55, 30, 20, TextComponent.f_131282_));
        this.scaleZField.m_94151_(this::setScaleZFromString);
        this.scaleZField.m_94153_(this.scaleFilter);
        this.scaleZField.m_94199_(5);
        this.scaleZField.m_94144_(String.valueOf(this.currentData.scaleZ));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ - 60, this.f_96544_ - 20, 60, 20, (Component)new TextComponent("Confirm"), btn -> {
            PacketDispatcher.sendToServer(new CEditNpc(this.npcEntity.m_142049_(), this.currentData.isNameVisible, this.currentData.name, this.currentData.title, this.currentData.texture, this.currentData.isTextureResourceLocation, this.currentData.isSlim, this.currentData.dialogue, this.currentData.textColor, this.currentData.items, this.currentData.pose, this.currentData.renderedType, this.currentData.rendererTag, this.currentData.scaleX, this.currentData.scaleY, this.currentData.scaleZ, this.currentData.collision));
            this.isConfirmClose = true;
            this.f_96541_.m_91152_(null);
        }));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ - 60, this.f_96544_ - 40, 60, 20, (Component)new TextComponent("Inventory"), btn -> {
            PacketDispatcher.sendToServer(new CEditNpc(this.npcEntity.m_142049_(), this.currentData.isNameVisible, this.currentData.name, this.currentData.title, this.currentData.texture, this.currentData.isTextureResourceLocation, this.currentData.isSlim, this.currentData.dialogue, this.currentData.textColor, this.currentData.items, this.currentData.pose, this.currentData.renderedType, this.currentData.rendererTag, this.currentData.scaleX, this.currentData.scaleY, this.currentData.scaleZ, this.currentData.collision));
            PacketDispatcher.sendToServer(new CRequestContainer(this.npcEntity.m_142049_(), CRequestContainer.ContainerType.NPCINVENTORY));
        }));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ - 60, this.f_96544_ - 60, 60, 20, (Component)new TextComponent("Trades"), btn -> {
            PacketDispatcher.sendToServer(new CEditNpc(this.npcEntity.m_142049_(), this.currentData.isNameVisible, this.currentData.name, this.currentData.title, this.currentData.texture, this.currentData.isTextureResourceLocation, this.currentData.isSlim, this.currentData.dialogue, this.currentData.textColor, this.currentData.items, this.currentData.pose, this.currentData.renderedType, this.currentData.rendererTag, this.currentData.scaleX, this.currentData.scaleY, this.currentData.scaleZ, this.currentData.collision));
            PacketDispatcher.sendToServer(new CRequestContainer(this.npcEntity.m_142049_(), CRequestContainer.ContainerType.TRADE_EDITOR));
        }));
        this.poseDropdown = (EnumDropdownWidget)this.m_142416_((GuiEventListener)new EnumDropdownWidget<CEditNpc.NPCPose>(this.currentData.pose, minX + 210, 5, 80));
        this.poseDropdown.f_93623_ = this.currentData.renderedType == EntityInit.NPC_ENTITY.get();
        this.rendererDropdown = (EntityDropdownWidget)this.m_142416_((GuiEventListener)new EntityDropdownWidget(this.currentData.renderedType, minX + 125, 105, 165, 8, true));
        this.collisionCheckbox = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(minX + 130 + this.f_96547_.m_92895_("Collision: "), 120, 20, 20, TextComponent.f_131282_, this.currentData.collision, false));
        this.collisionCheckbox.f_93623_ = !this.rendererDropdown.isShowingOptions();
        this.collisionCheckbox.f_93624_ = this.collisionCheckbox.f_93623_;
        this.rendererTagField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, minX + 125, 80, 165, 20, TextComponent.f_131282_));
        this.rendererTagField.m_94151_(this::setRendererTag);
        this.rendererTagField.m_94199_(1000);
        if (this.currentData.rendererTag.m_128441_("id")) {
            this.currentData.rendererTag.m_128473_("id");
        }
        this.rendererTagField.m_94144_(this.currentData.rendererTag.m_7916_());
    }

    private void setName(String s) {
        this.currentData.name = s;
        this.npcEntity.m_6593_((Component)new TextComponent(s));
    }

    private void setTitle(String s) {
        this.currentData.title = s;
        this.npcEntity.setTitle(s);
    }

    private void setTexture(String s) {
        this.currentData.texture = s;
        this.npcEntity.setTexture(s);
    }

    private void setDialogue(String s) {
        this.currentData.dialogue = s;
    }

    public int getR() {
        return this.r;
    }

    public void setR(int i) {
        this.r = Mth.m_14045_((int)i, (int)0, (int)255);
        this.currentData.textColor = ColorUtil.rgbToHex(this.r, this.g, this.b);
    }

    private void setRFromString(String s) {
        if (s.isEmpty()) {
            this.r = 0;
        } else {
            try {
                this.r = Mth.m_14045_((int)Integer.parseInt(s), (int)0, (int)255);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.redSlider.updateColorY();
        this.currentData.textColor = ColorUtil.rgbToHex(this.r, this.g, this.b);
    }

    public int getG() {
        return this.g;
    }

    public void setG(int i) {
        this.g = Mth.m_14045_((int)i, (int)0, (int)255);
        this.currentData.textColor = ColorUtil.rgbToHex(this.r, this.g, this.b);
    }

    private void setGFromString(String s) {
        if (s.isEmpty()) {
            this.g = 0;
        } else {
            try {
                this.g = Mth.m_14045_((int)Integer.parseInt(s), (int)0, (int)255);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.npcEntity.m_6593_((Component)new TextComponent(this.currentData.name));
        }
        this.greenSlider.updateColorY();
        this.currentData.textColor = ColorUtil.rgbToHex(this.r, this.g, this.b);
    }

    public int getB() {
        return this.b;
    }

    public void setB(int i) {
        this.b = Mth.m_14045_((int)i, (int)0, (int)255);
        this.currentData.textColor = ColorUtil.rgbToHex(this.r, this.g, this.b);
    }

    private void setBFromString(String s) {
        if (s.isEmpty()) {
            this.b = 0;
        } else {
            try {
                this.b = Mth.m_14045_((int)Integer.parseInt(s), (int)0, (int)255);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.blueSlider.updateColorY();
        this.currentData.textColor = ColorUtil.rgbToHex(this.r, this.g, this.b);
    }

    private void setScaleXFromString(String s) {
        if (s.isEmpty()) {
            this.currentData.scaleX = 1.0f;
        } else {
            try {
                this.currentData.scaleX = Mth.m_14036_((float)Float.parseFloat(s), (float)0.1f, (float)15.0f);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.scaleLinkCheckbox.selected() && this.m_7222_() == this.scaleXField) {
            this.scaleYField.m_94144_(String.valueOf(this.currentData.scaleX));
            this.scaleZField.m_94144_(String.valueOf(this.currentData.scaleX));
        }
        this.npcEntity.setScale(this.currentData.scaleX, this.currentData.scaleY, this.currentData.scaleZ);
    }

    private void setScaleYFromString(String s) {
        if (s.isEmpty()) {
            this.currentData.scaleY = 1.0f;
        } else {
            try {
                this.currentData.scaleY = Mth.m_14036_((float)Float.parseFloat(s), (float)0.1f, (float)15.0f);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.scaleLinkCheckbox.selected() && this.m_7222_() == this.scaleYField) {
            this.scaleXField.m_94144_(String.valueOf(this.currentData.scaleY));
            this.scaleZField.m_94144_(String.valueOf(this.currentData.scaleY));
        }
        this.npcEntity.setScale(this.currentData.scaleX, this.currentData.scaleY, this.currentData.scaleZ);
    }

    private void setScaleZFromString(String s) {
        if (s.isEmpty()) {
            this.currentData.scaleZ = 1.0f;
        } else {
            try {
                this.currentData.scaleZ = Mth.m_14036_((float)Float.parseFloat(s), (float)0.1f, (float)15.0f);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.scaleLinkCheckbox.selected() && this.m_7222_() == this.scaleZField) {
            this.scaleXField.m_94144_(String.valueOf(this.currentData.scaleZ));
            this.scaleYField.m_94144_(String.valueOf(this.currentData.scaleZ));
        }
        this.npcEntity.setScale(this.currentData.scaleX, this.currentData.scaleY, this.currentData.scaleZ);
    }

    private void setRendererTag(String s) {
        if (s.isEmpty()) {
            this.currentData.rendererTag = this.originalRendererTagCopy;
        } else {
            try {
                this.currentData.rendererTag = new TagParser(new StringReader(s)).m_129373_();
            }
            catch (Exception ignored) {
                this.currentData.rendererTag = this.originalRendererTagCopy;
            }
        }
        this.npcEntity.setRenderedEntityFromTag(this.currentData.rendererTag);
    }

    public void m_96624_() {
        this.currentData.isSlim = this.slimCheckBox.m_93840_();
        this.npcEntity.setSlim(this.currentData.isSlim);
        this.currentData.isNameVisible = this.nameVisibleCheckbox.m_93840_();
        this.npcEntity.m_20340_(this.currentData.isNameVisible);
        this.currentData.isTextureResourceLocation = this.isResourceLocationCheckbox.m_93840_();
        this.npcEntity.setIsTextureResourceLocation(this.currentData.isTextureResourceLocation);
        if (this.poseDropdown.getSelectedOption() != this.currentData.pose) {
            this.currentData.pose = this.poseDropdown.getSelectedOption();
            switch (this.currentData.pose) {
                case CROUCHING: {
                    this.npcEntity.setCrouching(true);
                    this.npcEntity.setSitting(false);
                    break;
                }
                case SITTING: {
                    this.npcEntity.setCrouching(false);
                    this.npcEntity.setSitting(true);
                    break;
                }
                case STANDING: {
                    this.npcEntity.setCrouching(false);
                    this.npcEntity.setSitting(false);
                }
            }
        }
        this.currentData.collision = this.collisionCheckbox.m_93840_();
        this.collisionCheckbox.f_93623_ = !this.rendererDropdown.isShowingOptions();
        this.collisionCheckbox.f_93624_ = this.collisionCheckbox.f_93623_;
        this.currentData.renderedType = this.rendererDropdown.getSelectedType();
        if (!this.npcEntity.getRenderedEntityType().equals(this.currentData.renderedType)) {
            CompoundTag tag = this.currentData.rendererTag.m_6426_();
            String key = EntityType.m_20613_(this.currentData.renderedType).toString();
            this.textureField.f_93624_ = this.textureField.f_93623_ = key.equals(NpcEntity.TYPE_STRING);
            this.isResourceLocationCheckbox.f_93623_ = this.textureField.f_93623_;
            this.isResourceLocationCheckbox.f_93624_ = this.textureField.f_93623_;
            tag.m_128359_("id", key);
            this.npcEntity.setRenderedEntityFromTag(tag);
        }
        if (this.currentData.renderedType != EntityInit.NPC_ENTITY.get()) {
            this.poseDropdown.f_93623_ = false;
            this.poseDropdown.selectOption(CEditNpc.NPCPose.STANDING);
            this.slimCheckBox.f_93623_ = false;
            if (this.slimCheckBox.m_93840_()) {
                this.slimCheckBox.m_5691_();
            }
            this.rendererTagField.f_93624_ = true;
            this.rendererTagField.f_93623_ = true;
        } else {
            this.poseDropdown.f_93623_ = true;
            this.slimCheckBox.f_93623_ = true;
            this.rendererTagField.f_93624_ = false;
            this.rendererTagField.f_93623_ = false;
        }
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        int x = this.f_96543_ - 60;
        int y = (int)((float)(this.f_96544_ / 4) * 2.5f);
        float bbHeight = Math.max(this.npcEntity.m_20206_(), 1.0f);
        int scale = (int)((float)this.f_96544_ / 3.0f / bbHeight);
        InventoryScreen.m_98850_((int)x, (int)y, (int)scale, (float)40.0f, (float)-20.0f, (LivingEntity)this.npcEntity);
        Objects.requireNonNull(this.f_96547_);
        int center = (20 - 9) / 2;
        NpcBuilderScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)"Name: ", (int)5, (int)(5 + center), (int)0xFFFFFF);
        NpcBuilderScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)"Visible? ", (int)(minX + 130), (int)(5 + center), (int)0xFFFFFF);
        NpcBuilderScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)"Title: ", (int)5, (int)(30 + center), (int)0xFFFFFF);
        if (this.textureField.f_93624_) {
            NpcBuilderScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)"Texture: ", (int)5, (int)(55 + center), (int)0xFFFFFF);
        }
        NpcBuilderScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)"Slim? ", (int)(minX + 130), (int)(30 + center), (int)(this.slimCheckBox.f_93623_ ? 0xFFFFFF : 0x7D7D7D));
        if (this.isResourceLocationCheckbox.f_93624_) {
            NpcBuilderScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)"ResourceLocation? ", (int)(minX + 155 + this.f_96547_.m_92895_("Slim? ")), (int)(30 + center), (int)0xFFFFFF);
        }
        NpcBuilderScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)"Scale: ", (int)(minX + 130), (int)(55 + center), (int)0xFFFFFF);
        NpcBuilderScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)"Collision: ", (int)(minX + 130), (int)(120 + center), (int)0xFFFFFF);
        NpcBuilderScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)"Dialogue: ", (int)5, (int)(80 + center), (int)0xFFFFFF);
        Objects.requireNonNull(this.f_96547_);
        NpcBuilderScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)"Text Color: ", (int)5, (int)(130 + (100 - 9) / 2), (int)0xFFFFFF);
        NpcBuilderScreen.m_93172_((PoseStack)matrixStack, (int)(minX + 89), (int)146, (int)(minX + 116), (int)172, (int)-16777216);
        NpcBuilderScreen.m_93172_((PoseStack)matrixStack, (int)(minX + 90), (int)147, (int)(minX + 115), (int)171, (int)ColorUtil.hexToHexA(this.currentData.textColor));
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public void m_7379_() {
        if (!this.isConfirmClose) {
            this.originalData.setNpcData(this.npcEntity);
        }
        super.m_7379_();
    }

    private static class NpcData {
        private String name;
        private String title;
        private String dialogue;
        private int textColor;
        private String texture;
        private boolean isSlim;
        private boolean isNameVisible;
        private boolean isTextureResourceLocation;
        private ItemStack[] items;
        private CEditNpc.NPCPose pose;
        private EntityType<?> renderedType;
        private CompoundTag rendererTag;
        private float scaleX;
        private float scaleY;
        private float scaleZ;
        private boolean collision;

        private NpcData() {
        }

        private static NpcData fromNpc(NpcEntity npcEntity) {
            NpcData data = new NpcData();
            data.pose = npcEntity.m_6047_() ? CEditNpc.NPCPose.CROUCHING : (npcEntity.isSitting() ? CEditNpc.NPCPose.SITTING : CEditNpc.NPCPose.STANDING);
            data.name = npcEntity.m_7755_().getString();
            data.title = npcEntity.getTitle();
            data.isNameVisible = npcEntity.m_20151_();
            data.texture = npcEntity.getTexture();
            data.isTextureResourceLocation = npcEntity.isTextureResourceLocation();
            data.isSlim = npcEntity.isSlim();
            data.dialogue = npcEntity.getDialogue();
            data.textColor = npcEntity.getTextColor();
            data.items = new ItemStack[]{npcEntity.m_21205_(), npcEntity.m_21206_(), npcEntity.m_6844_(EquipmentSlot.HEAD), npcEntity.m_6844_(EquipmentSlot.CHEST), npcEntity.m_6844_(EquipmentSlot.LEGS), npcEntity.m_6844_(EquipmentSlot.FEET)};
            data.renderedType = npcEntity.getRenderedEntityType();
            data.rendererTag = npcEntity.getRenderedEntityTagWithoutId();
            data.scaleX = npcEntity.getScaleX();
            data.scaleY = npcEntity.getScaleY();
            data.scaleZ = npcEntity.getScaleZ();
            data.collision = npcEntity.hasCollision();
            return data;
        }

        private void setNpcData(NpcEntity npcEntity) {
            switch (this.pose) {
                case CROUCHING: {
                    npcEntity.setCrouching(true);
                    npcEntity.setSitting(false);
                    break;
                }
                case SITTING: {
                    npcEntity.setCrouching(false);
                    npcEntity.setSitting(true);
                    break;
                }
                case STANDING: {
                    npcEntity.setCrouching(false);
                    npcEntity.setSitting(false);
                }
            }
            npcEntity.m_6593_((Component)new TextComponent(this.name));
            npcEntity.m_20340_(this.isNameVisible);
            npcEntity.setTitle(this.title);
            npcEntity.setTexture(this.texture);
            npcEntity.setIsTextureResourceLocation(this.isTextureResourceLocation);
            npcEntity.setSlim(this.isSlim);
            npcEntity.setDialogue(this.dialogue);
            npcEntity.setTextColor(this.textColor);
            npcEntity.m_8061_(EquipmentSlot.MAINHAND, this.items[0]);
            npcEntity.m_8061_(EquipmentSlot.OFFHAND, this.items[1]);
            npcEntity.m_8061_(EquipmentSlot.HEAD, this.items[2]);
            npcEntity.m_8061_(EquipmentSlot.CHEST, this.items[3]);
            npcEntity.m_8061_(EquipmentSlot.LEGS, this.items[4]);
            npcEntity.m_8061_(EquipmentSlot.FEET, this.items[5]);
            npcEntity.setRenderedEntityFromTag(this.rendererTag);
            npcEntity.setScale(this.scaleX, this.scaleY, this.scaleZ);
            npcEntity.setCollision(this.collision);
        }
    }
}

