/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.client.gui.screen;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import flash.npcmod.ClientProxy;
import flash.npcmod.Main;
import flash.npcmod.core.trades.TradeOffer;
import flash.npcmod.entity.NpcEntity;
import flash.npcmod.network.PacketDispatcher;
import flash.npcmod.network.packets.client.CHandleSavedNpc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SavedNpcsScreen
extends Screen {
    private static final Gson GSON = new Gson();
    private int selectedIndex;
    private boolean isGlobalPage;
    private int resultTick;
    private int resultColor;
    private String resultText;
    private final String pos;
    private String newInternalName;
    private NpcEntity selected;
    private Button placeButton;
    private Button renameButton;
    private Button deleteButton;
    private Button saveGlobalButton;
    private EditBox renameTextBox;
    private Checkbox globalCheckbox;
    private List<JsonObject> savedNpcs;
    private List<JsonObject> globalNpcs;
    private NpcList list;

    public SavedNpcsScreen(String pos) {
        super(TextComponent.f_131282_);
        this.pos = pos;
        this.newInternalName = "";
        this.savedNpcs = new ArrayList<JsonObject>();
        this.globalNpcs = new ArrayList<JsonObject>();
        ClientProxy.GLOBAL_NPCS.forEach(s -> this.globalNpcs.add((JsonObject)GSON.fromJson(s, JsonObject.class)));
        ClientProxy.SAVED_NPCS.forEach(s -> this.savedNpcs.add((JsonObject)GSON.fromJson(s, JsonObject.class)));
    }

    protected void m_7856_() {
        this.list = new NpcList(this.isGlobalPage);
        this.m_7787_((GuiEventListener)this.list);
        if (this.selected != null) {
            this.list.setSelected((NpcList.Entry)((Object)this.list.m_6702_().get(this.selectedIndex)));
        }
        int buttonY = this.f_96544_ - 25;
        this.placeButton = (Button)this.m_142416_((GuiEventListener)new Button(5, buttonY, 100, 20, (Component)new TextComponent("Place"), onPress -> {
            if (this.list.m_93511_() != null) {
                JsonObject npcJson = ((NpcList.Entry)this.list.m_93511_()).asJson;
                try {
                    int[] posArray = Arrays.stream(this.pos.split(";")).mapToInt(Integer::valueOf).toArray();
                    BlockPos pos = new BlockPos(posArray[0], posArray[1], posArray[2]);
                    PacketDispatcher.sendToServer(new CHandleSavedNpc(npcJson, pos));
                }
                catch (Exception ignored) {
                    Main.LOGGER.warn("Couldn't place Saved NPC: invalid BlockPos (" + this.pos + ")");
                }
                this.m_7379_();
            }
        }));
        this.deleteButton = (Button)this.m_142416_((GuiEventListener)new Button(110, buttonY, 100, 20, (Component)new TextComponent("Delete"), onPress -> {
            if (this.list.m_93511_() != null) {
                PacketDispatcher.sendToServer(new CHandleSavedNpc(((NpcList.Entry)this.list.m_93511_()).name.getString(), this.isGlobalPage));
                List<JsonObject> jsonList = this.isGlobalPage ? this.globalNpcs : this.savedNpcs;
                jsonList.remove(this.list.getSelectedIndex());
                this.list.update();
                this.selected = null;
            }
        }));
        this.renameButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ - 5 - 100, buttonY, 100, 20, (Component)new TextComponent("Rename"), onPress -> {
            if (this.list.m_93511_() != null) {
                String prevname = ((NpcList.Entry)this.list.m_93511_()).name.getString();
                List<JsonObject> jsonList = this.isGlobalPage ? this.globalNpcs : this.savedNpcs;
                boolean exists = jsonList.stream().anyMatch(json -> json.get("internalName").getAsString().equals(this.newInternalName));
                if (!exists) {
                    ((NpcList.Entry)this.list.m_93511_()).asJson.addProperty("internalName", this.newInternalName);
                    ((NpcList.Entry)this.list.m_93511_()).name = new TextComponent(this.newInternalName);
                    PacketDispatcher.sendToServer(new CHandleSavedNpc(prevname, this.newInternalName, this.isGlobalPage));
                    this.setResult("Success!", 65280);
                } else {
                    Main.LOGGER.warn("Tried to rename saved npc to an already existing name");
                    this.setResult("A Saved NPC with this name already exists!", 0xFF0000);
                }
            }
        }));
        this.saveGlobalButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ - 5 - 100, 5, 100, 20, (Component)new TextComponent("Save to Global"), btn -> {
            if (this.list.m_93511_() != null) {
                String name = ((NpcList.Entry)this.list.m_93511_()).name.getString();
                boolean exists = this.globalNpcs.stream().anyMatch(json -> json.get("internalName").getAsString().equals(name));
                if (!exists) {
                    PacketDispatcher.sendToServer(new CHandleSavedNpc(((NpcList.Entry)this.list.m_93511_()).asJson));
                    this.globalNpcs.add(((NpcList.Entry)this.list.m_93511_()).asJson);
                    this.setResult("Success!", 65280);
                } else {
                    this.setResult("A Global NPC with this name already exists!", 0xFF0000);
                }
            }
        }));
        this.saveGlobalButton.f_93623_ = !this.isGlobalPage;
        this.globalCheckbox = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(this.saveGlobalButton.f_93620_ - 5 - 20, 5, 20, 20, TextComponent.f_131282_, this.isGlobalPage, false));
        this.renameTextBox = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, 215, buttonY, this.f_96543_ - 110 - 110 - 105, 20, TextComponent.f_131282_));
        this.renameTextBox.m_94151_(this::setNewInternalName);
        this.renameTextBox.m_94199_(50);
        this.renameTextBox.m_94144_(this.newInternalName);
        this.updateButtonValidity(this.list.m_93511_() != null);
    }

    private void setResult(String text, int color) {
        this.resultText = text;
        this.resultColor = color;
        this.resultTick = 40;
    }

    public void setNewInternalName(String newInternalName) {
        this.newInternalName = newInternalName;
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(stack);
        if (this.list != null) {
            this.list.m_6305_(stack, mouseX, mouseY, partialTicks);
        }
        if (this.selected != null) {
            float bbHeight = Math.max(this.selected.m_20206_(), 1.0f);
            int scale = (int)(54.0f / bbHeight);
            InventoryScreen.m_98850_((int)30, (int)70, (int)scale, (float)-30.0f, (float)-15.0f, (LivingEntity)this.selected);
            SavedNpcsScreen.m_93215_((PoseStack)stack, (Font)this.f_96547_, (Component)this.selected.m_7755_(), (int)(this.f_96543_ / 2), (int)8, (int)0xFFFFFF);
            if (this.selected.getDialogue() != null && !this.selected.getDialogue().isEmpty()) {
                SavedNpcsScreen.m_93236_((PoseStack)stack, (Font)this.f_96547_, (String)("Dialogue: " + this.selected.getDialogue()), (int)60, (int)20, (int)this.selected.getTextColor());
            }
            if (!this.selected.getOffers().isEmpty()) {
                SavedNpcsScreen.m_93236_((PoseStack)stack, (Font)this.f_96547_, (String)"Trades:", (int)60, (int)32, (int)0xFFFFFF);
                List<TradeOffer> tradeOffers = this.selected.getOffers().stream().filter(offer -> !offer.isEmpty()).toList();
                int w = 100 + this.f_96547_.m_92895_("-->") + 2;
                for (int i = 0; i < Math.min(6, tradeOffers.size()); ++i) {
                    int x = 62 + i / 2 * w;
                    int y = 42 + i % 2 * 18;
                    this.renderTradeOffer(tradeOffers.get(i), stack, x, y, mouseX, mouseY);
                }
                if (tradeOffers.size() > 6) {
                    SavedNpcsScreen.m_93236_((PoseStack)stack, (Font)this.f_96547_, (String)". . .", (int)(62 + 3 * w), (int)53, (int)0xFFFFFF);
                }
            }
        }
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        if (this.resultTick > 0) {
            int n = this.f_96543_ / 2;
            int n2 = this.f_96544_ / 2;
            Objects.requireNonNull(this.f_96547_);
            SavedNpcsScreen.m_93208_((PoseStack)stack, (Font)this.f_96547_, (String)this.resultText, (int)n, (int)(n2 - 9 / 2), (int)this.resultColor);
        }
    }

    private void renderTradeOffer(TradeOffer offer, PoseStack poseStack, int x, int y, int mouseX, int mouseY) {
        for (int i = 0; i < offer.getBuyingStacks().length; ++i) {
            ItemStack stack = offer.getBuyingStacks()[i];
            if (stack.m_41619_()) continue;
            this.f_96541_.m_91291_().m_115203_(stack, x + i * 16, y);
            this.f_96541_.m_91291_().m_115169_(this.f_96547_, stack, x + i * 16, y);
            if (mouseX < x + i * 16 || mouseX >= x + 16 + i * 16 || mouseY < y || mouseY > y + 16) continue;
            this.m_6057_(poseStack, stack, mouseX, mouseY);
        }
        int x2 = x + 50;
        SavedNpcsScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)"-->", (int)x2, (int)(y + 4), (int)0xFFFFFF);
        int x3 = x2 + this.f_96547_.m_92895_("-->") + 2;
        for (int i = 0; i < offer.getSellingStacks().length; ++i) {
            ItemStack stack = offer.getSellingStacks()[i];
            if (stack.m_41619_()) continue;
            this.f_96541_.m_91291_().m_115203_(stack, x3 + i * 16, y);
            this.f_96541_.m_91291_().m_115169_(this.f_96547_, stack, x3 + i * 16, y);
            if (mouseX < x3 + i * 16 || mouseX >= x3 + 16 + i * 16 || mouseY < y || mouseY > y + 16) continue;
            this.m_6057_(poseStack, stack, mouseX, mouseY);
        }
        SavedNpcsScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)"|", (int)(x3 + 48), (int)(y + 4), (int)0xFFFFFF);
    }

    public void m_96624_() {
        if (this.resultTick > 0) {
            --this.resultTick;
        }
        boolean bl = this.saveGlobalButton.f_93623_ = !this.isGlobalPage;
        if (this.globalCheckbox.m_93840_() != this.isGlobalPage) {
            this.isGlobalPage = this.globalCheckbox.m_93840_();
            this.selected = null;
            this.selectedIndex = 0;
            this.updateButtonValidity(false);
            this.renameTextBox.m_94144_("");
            this.m_169411_((GuiEventListener)this.list);
            this.list = new NpcList(this.isGlobalPage);
            this.m_7787_((GuiEventListener)this.list);
        }
    }

    public boolean m_6050_(double p_96381_, double p_96382_, double p_96383_) {
        return this.list.m_6050_(p_96381_, p_96382_, p_96383_);
    }

    public void updateButtonValidity(boolean p_96450_) {
        this.placeButton.f_93623_ = p_96450_;
        this.deleteButton.f_93623_ = p_96450_;
        this.renameButton.f_93623_ = p_96450_;
        this.renameTextBox.f_93623_ = p_96450_;
    }

    @OnlyIn(value=Dist.CLIENT)
    class NpcList
    extends ObjectSelectionList<Entry> {
        public NpcList(boolean isGlobalNpcsList) {
            super(SavedNpcsScreen.this.f_96541_, SavedNpcsScreen.this.f_96543_, SavedNpcsScreen.this.f_96544_, 80, SavedNpcsScreen.this.f_96544_ - 37, 24);
            List<NpcInfo> savedNpcs = isGlobalNpcsList ? SavedNpcsScreen.this.globalNpcs.stream().map(NpcInfo::fromJson).toList() : SavedNpcsScreen.this.savedNpcs.stream().map(NpcInfo::fromJson).toList();
            for (NpcInfo savednpcsscreen$npcinfo : savedNpcs) {
                this.m_7085_((AbstractSelectionList.Entry)new Entry(savednpcsscreen$npcinfo));
            }
        }

        public int getSelectedIndex() {
            return this.m_6702_().indexOf(this.m_93511_());
        }

        public void setSelected(@Nullable Entry p_96472_) {
            super.m_6987_((AbstractSelectionList.Entry)p_96472_);
            SavedNpcsScreen.this.updateButtonValidity(p_96472_ != null);
        }

        protected void update() {
            List<NpcInfo> savedNpcs = SavedNpcsScreen.this.isGlobalPage ? SavedNpcsScreen.this.globalNpcs.stream().map(NpcInfo::fromJson).toList() : SavedNpcsScreen.this.savedNpcs.stream().map(NpcInfo::fromJson).toList();
            this.m_93516_();
            for (NpcInfo savednpcsscreen$npcinfo : savedNpcs) {
                this.m_7085_((AbstractSelectionList.Entry)new Entry(savednpcsscreen$npcinfo));
            }
        }

        protected boolean m_5694_() {
            return SavedNpcsScreen.this.m_7222_() == this;
        }

        public boolean m_7933_(int p_96466_, int p_96467_, int p_96468_) {
            if (super.m_7933_(p_96466_, p_96467_, p_96468_)) {
                return true;
            }
            if ((p_96466_ == 257 || p_96466_ == 335) && this.m_93511_() != null) {
                ((Entry)this.m_93511_()).select();
            }
            return false;
        }

        @OnlyIn(value=Dist.CLIENT)
        public class Entry
        extends ObjectSelectionList.Entry<Entry> {
            private Component name;
            private final NpcEntity npcEntity;
            private JsonObject asJson;

            public Entry(NpcInfo npcInfo) {
                this.name = npcInfo.internalName();
                this.npcEntity = npcInfo.npcEntity();
                this.asJson = npcInfo.asJson();
            }

            public void m_6311_(PoseStack stack, int p_96490_, int y, int x, int p_96493_, int p_96494_, int p_96495_, int p_96496_, boolean p_96497_, float p_96498_) {
                float bbHeight = Math.max(this.npcEntity.m_20206_(), 1.0f);
                int scale = (int)(18.0f / bbHeight);
                InventoryScreen.m_98850_((int)(x + 10), (int)(y + 18), (int)scale, (float)-40.0f, (float)-20.0f, (LivingEntity)this.npcEntity);
                SavedNpcsScreen.this.f_96547_.m_92889_(stack, this.name, (float)(x + 18 + 5), (float)(y + 6), 0xFFFFFF);
            }

            public boolean m_6375_(double p_96481_, double p_96482_, int p_96483_) {
                if (p_96483_ == 0) {
                    this.select();
                }
                return false;
            }

            void select() {
                NpcList.this.setSelected(this);
                SavedNpcsScreen.this.selected = this.npcEntity;
                SavedNpcsScreen.this.selectedIndex = NpcList.this.getSelectedIndex();
                SavedNpcsScreen.this.renameTextBox.m_94144_(this.name.getString());
            }

            public Component m_142172_() {
                return new TranslatableComponent("narrator.select", new Object[]{this.name});
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    record NpcInfo(Component internalName, NpcEntity npcEntity, JsonObject asJson) {
        public static NpcInfo fromJson(JsonObject jsonObject) {
            return new NpcInfo((Component)new TextComponent(jsonObject.get("internalName").getAsString()), NpcEntity.fromJson((Level)Minecraft.m_91087_().f_91073_, jsonObject), jsonObject);
        }
    }
}

