/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.client.gui.screen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import flash.npcmod.client.gui.widget.DirectionalFrame;
import flash.npcmod.client.gui.widget.FunctionListWidget;
import flash.npcmod.client.gui.widget.TextWidget;
import flash.npcmod.core.client.dialogues.ClientDialogueUtil;
import flash.npcmod.core.node.BuilderNode;
import flash.npcmod.core.node.NodeData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public abstract class TreeBuilderScreen
extends Screen {
    protected String fileName;
    protected double scrollX;
    protected double scrollY;
    protected boolean isScrolling;
    public int maxX = 10000;
    public int maxY = 10000;
    protected BuilderNode initNode;
    public final List<BuilderNode> allNodes;
    public List<String> conflictingNodeDataNames;
    protected int selectedNodeIndex;
    protected FunctionListWidget<BuilderNode> functionListWidget;
    protected EditBox functionParamsField;
    protected HashMap<EditType, EditBox> allNameFields;
    protected HashMap<EditType, DirectionalFrame> allTopLevelFrames;
    protected Button saveButton;
    protected Button confirmButton;
    protected Button cancelButton;
    protected DirectionalFrame mainVFrame;
    protected DirectionalFrame buttonFrame;
    protected DirectionalFrame fileNameFrame;
    protected DirectionalFrame nodeNameFrame;
    protected String newName = "";
    protected String newFunctionParams = "";
    protected final Predicate<String> nameFilter = text -> {
        Pattern pattern = Pattern.compile("\\s|/|\\|:|\\*|\\?|\\||<|>");
        Matcher matcher = pattern.matcher((CharSequence)text);
        return !matcher.find();
    };

    public TreeBuilderScreen(String name) {
        super(TextComponent.f_131282_);
        this.fileName = name;
        this.conflictingNodeDataNames = new ArrayList<String>();
        this.allNodes = new ArrayList<BuilderNode>();
        this.loadFromJsonObject();
        if (!this.allNodes.isEmpty()) {
            this.updateNodePositionsFromJson();
        }
        this.allNameFields = new HashMap();
        this.allTopLevelFrames = new HashMap();
    }

    public JsonObject buildEditorJSON() {
        JsonArray entries = new JsonArray();
        for (BuilderNode node : this.allNodes) {
            JsonObject entry = new JsonObject();
            entry.addProperty("name", node.getName());
            entry.addProperty("x", (Number)node.getX());
            entry.addProperty("y", (Number)node.getY());
            entries.add((JsonElement)entry);
        }
        JsonObject object = new JsonObject();
        object.add("entries", (JsonElement)entries);
        return object;
    }

    public JsonObject buildNodeDataJSON() {
        JsonArray entries = new JsonArray();
        for (BuilderNode node : this.allNodes) {
            if (!node.isStart()) continue;
            entries.add((JsonElement)node.getNodeData().toJSON());
        }
        JsonObject object = new JsonObject();
        object.add("entries", (JsonElement)entries);
        return object;
    }

    public void centerScreenOnNode(BuilderNode node) {
        this.scrollX = -Mth.m_14045_((int)(node.getX() + node.getWidth() / 2 - this.f_96543_ / 2), (int)0, (int)(this.maxX - this.f_96543_));
        this.scrollY = -Mth.m_14045_((int)(node.getY() + node.getHeight() / 2 - this.f_96544_ / 2), (int)0, (int)(this.maxY - this.f_96544_));
    }

    protected void confirmEdits() {
        if (!this.newName.equals("init") && !this.newName.isEmpty()) {
            assert (this.getEditingNode() != null);
            if (!this.getEditingNode().getName().equals("init")) {
                this.getEditingNode().getNodeData().setName(this.newName);
            }
        }
        if (this.functionListWidget.isVisible()) {
            this.functionListWidget.setFunction();
        }
    }

    private void drawBackground(PoseStack matrixStack, int mouseX, int mouseY) {
        matrixStack.m_85836_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getBackground());
        int i = Mth.m_14107_((double)this.scrollX);
        int j = Mth.m_14107_((double)this.scrollY);
        int k = i % 16;
        int l = j % 16;
        int x = this.f_96543_ / 16;
        int y = this.f_96544_ / 16;
        for (int i1 = -1; i1 <= x; ++i1) {
            for (int j1 = -2; j1 <= y; ++j1) {
                TreeBuilderScreen.m_93133_((PoseStack)matrixStack, (int)(k + 16 * i1), (int)(l + 16 * j1), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            }
        }
        if (this.getSelectedNode() != null) {
            this.drawLinesToMouse(matrixStack, mouseX, mouseY);
        }
        this.allNodes.forEach(node -> node.draw(matrixStack, this.scrollX, this.scrollY));
        if (this.isAnyTextFieldVisible()) {
            this.m_93179_(matrixStack, -20, -20, this.f_96543_, this.f_96544_, -1072689136, -804253680);
        }
        matrixStack.m_85849_();
    }

    public void dragGui(double dragX, double dragY) {
        this.scrollX = Mth.m_14008_((double)(this.scrollX + dragX), (double)(-(this.maxX - this.f_96543_)), (double)0.0);
        this.scrollY = Mth.m_14008_((double)(this.scrollY + dragY), (double)(-(this.maxY - this.f_96544_)), (double)0.0);
    }

    protected void drawLinesToMouse(PoseStack matrixStack, double mouseX, double mouseY) {
        if (this.getSelectedNode() != null) {
            int index = this.getSelectedNodeIndex();
            BuilderNode selectedNode = this.getSelectedNode();
            if (index >= -2 && index < selectedNode.getConnectionNames().length + 1) {
                int[] nodeXY = index == -2 ? selectedNode.getEndPointLocation() : selectedNode.getStartPointLocation(index);
                int nodeX = selectedNode.getX() + nodeXY[0];
                int nodeY = selectedNode.getY() + nodeXY[1];
                int color = -256;
                matrixStack.m_85836_();
                matrixStack.m_85837_((double)selectedNode.getX() + this.scrollX, (double)selectedNode.getY() + this.scrollY, 0.0);
                matrixStack.m_85837_((double)nodeXY[0], (double)nodeXY[1], 0.0);
                matrixStack.m_85837_(3.5, 3.5, 0.0);
                int lineLength = (int)(-((double)nodeX + this.scrollX - mouseX + 9.0));
                int lineHeight = (int)(-((double)nodeY + this.scrollY - mouseY + 18.0));
                TreeBuilderScreen.m_93172_((PoseStack)matrixStack, (int)0, (int)0, (int)(lineLength / 2), (int)1, (int)color);
                TreeBuilderScreen.m_93172_((PoseStack)matrixStack, (int)(lineLength / 2), (int)0, (int)(lineLength / 2 + 1), (int)lineHeight, (int)color);
                TreeBuilderScreen.m_93172_((PoseStack)matrixStack, (int)(lineLength / 2 + 1), (int)lineHeight, (int)lineLength, (int)(lineHeight + 1), (int)color);
                matrixStack.m_85849_();
            }
        }
    }

    private void drawWindowBackground(PoseStack matrixStack, int mouseX, int mouseY) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(9.0, 18.0, 0.0);
        this.drawBackground(matrixStack, mouseX, mouseY);
        RenderSystem.m_69456_((int)515);
        RenderSystem.m_69465_();
        matrixStack.m_85849_();
    }

    protected abstract ResourceLocation getBackground();

    protected abstract BuilderNode getEditingNode();

    protected abstract JsonArray getEntries();

    public static int getNumWidgetRows(int height) {
        return height / 30;
    }

    public static int getNumWidgetCols(int width, int indexSize) {
        return width / (indexSize + 10);
    }

    public String getNewFunctionParams() {
        return this.newFunctionParams;
    }

    public int getSelectedNodeIndex() {
        return this.selectedNodeIndex;
    }

    @Nullable
    public abstract BuilderNode getSelectedNode();

    public static int getWidgetHeight(int rowNum, int screenHeight, @Nullable int[] rowHeights) {
        int defaultHeight = 20;
        int rowPadding = 5;
        return TreeBuilderScreen.get1DWidgetCoordinate(rowNum, screenHeight, defaultHeight, rowPadding, rowHeights);
    }

    public static int getWidgetWidth(int colNum, int screenWidth, @Nullable int[] colWidths, int padding) {
        int defaultWidth = 120;
        int colPadding = 10;
        if (padding > 0) {
            colPadding = padding;
        }
        return TreeBuilderScreen.get1DWidgetCoordinate(colNum, screenWidth, defaultWidth, colPadding, colWidths);
    }

    public static int get1DWidgetCoordinate(int indexNum, int size, int defaultIndexSize, int padding, @Nullable int[] indexSizes) {
        int space = size / 2 - defaultIndexSize / 2;
        int direction = indexNum > 0 ? -1 : 1;
        indexNum = Mth.m_14040_((int)indexNum);
        if (indexSizes != null) {
            int i;
            if (indexSizes.length > 0) {
                space = size / 2 - indexSizes[0] / 2;
            }
            for (i = 1; i <= indexNum && i < indexSizes.length; ++i) {
                space += (indexSizes[i] + padding) * direction;
            }
            while (i < indexNum) {
                space += (defaultIndexSize + padding) * direction;
                ++i;
            }
        } else {
            space += (defaultIndexSize + padding) * indexNum * direction;
        }
        return space;
    }

    protected void m_7856_() {
        this.setEditingNode(null);
        this.saveButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 50, this.f_96544_ - 25, 100, 20, (Component)new TextComponent("Save"), btn -> {
            if (this.fileName.isEmpty()) {
                this.setNodeBeingEdited(null, EditType.FILENAME);
                return;
            }
            if (this.getEditingNode() == null && this.conflictingNodeDataNames.size() == 0) {
                this.sendCEdit();
            }
        }));
        this.saveButton.f_93623_ = this.conflictingNodeDataNames.size() == 0;
        this.confirmButton = (Button)this.m_7787_((GuiEventListener)new Button(this.f_96543_ / 2 - 60, this.f_96544_ / 2 + 15, 50, 20, (Component)new TextComponent("Confirm"), btn -> {
            if (this.getEditingNode() != null) {
                this.confirmEdits();
                this.getEditingNode().calculateDimensions();
            }
            this.setNodeBeingEdited(null, EditType.NONE);
        }));
        this.cancelButton = (Button)this.m_7787_((GuiEventListener)new Button(this.f_96543_ / 2 + 10, this.f_96544_ / 2 + 15, 50, 20, (Component)new TextComponent("Cancel"), btn -> this.setNodeBeingEdited(null, EditType.NONE)));
        this.mainVFrame = (DirectionalFrame)this.m_142416_((GuiEventListener)DirectionalFrame.createVerticalFrame(this.f_96544_, DirectionalFrame.Alignment.CENTERED));
        this.buttonFrame = DirectionalFrame.createHorizontalFrame(this.f_96543_, DirectionalFrame.Alignment.CENTERED);
        this.buttonFrame.addWidget((AbstractWidget)this.confirmButton, 20);
        this.buttonFrame.addWidget((AbstractWidget)this.cancelButton, 20);
        this.buttonFrame.setVisible(false);
        this.mainVFrame.addSpacer();
        this.mainVFrame.addWidget(this.buttonFrame);
        this.nodeNameFrame = DirectionalFrame.createHorizontalFrame(this.f_96543_, DirectionalFrame.Alignment.CENTERED);
        EditBox nameField = (EditBox)this.m_7787_((GuiEventListener)new EditBox(this.f_96547_, this.f_96543_ / 2 - 60, this.f_96544_ / 2 - 10, 120, 20, TextComponent.f_131282_));
        nameField.m_94151_(this::setNewName);
        nameField.m_94153_(this.nameFilter);
        nameField.m_94199_(50);
        nameField.m_94190_(true);
        this.allNameFields.put(EditType.NAME, nameField);
        this.nodeNameFrame.addWidget(new TextWidget("Name:"));
        this.nodeNameFrame.addWidget((AbstractWidget)nameField);
        this.nodeNameFrame.setVisible(false);
        this.allTopLevelFrames.put(EditType.NAME, this.nodeNameFrame);
        this.mainVFrame.insertWidget(this.nodeNameFrame, 0, 20);
        this.fileNameFrame = DirectionalFrame.createHorizontalFrame(this.f_96543_, DirectionalFrame.Alignment.CENTERED);
        EditBox fileNameField = (EditBox)this.m_7787_((GuiEventListener)new EditBox(this.f_96547_, this.f_96543_ / 2 - 60, this.f_96544_ / 2 - 10, 120, 20, TextComponent.f_131282_));
        fileNameField.m_94151_(this::setNewFileName);
        fileNameField.m_94153_(this.nameFilter);
        fileNameField.m_94199_(50);
        fileNameField.m_94190_(true);
        this.allNameFields.put(EditType.FILENAME, fileNameField);
        this.fileNameFrame.addWidget(new TextWidget("File Name:"));
        this.fileNameFrame.addWidget((AbstractWidget)fileNameField);
        this.fileNameFrame.setVisible(false);
        this.mainVFrame.insertWidget(this.fileNameFrame, 0, 20);
        this.allTopLevelFrames.put(EditType.FILENAME, this.fileNameFrame);
        this.functionListWidget = new FunctionListWidget(this, Minecraft.m_91087_());
        this.functionListWidget.calculatePositionAndDimensions();
        this.functionParamsField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.f_96543_ / 2 - 60, this.f_96544_ - 44, 120, 20, TextComponent.f_131282_));
        this.functionParamsField.m_94151_(this::setNewFunctionParams);
        this.functionParamsField.m_94153_(this.nameFilter);
        this.functionParamsField.m_94199_(100);
        this.functionParamsField.m_94194_(false);
        this.functionParamsField.m_94190_(true);
        this.functionListWidget.setVisible(false);
    }

    public boolean m_7933_(int p_96552_, int p_96553_, int p_96554_) {
        if (p_96552_ == 256 && !this.m_6913_()) {
            this.setNodeBeingEdited(null, EditType.NONE);
            return true;
        }
        return super.m_7933_(p_96552_, p_96553_, p_96554_);
    }

    public boolean m_6913_() {
        return !this.isAnyTextFieldVisible();
    }

    protected boolean isAnyTextFieldVisible() {
        if (this.mainVFrame.isAnyVisible()) {
            return true;
        }
        return this.functionListWidget.isVisible();
    }

    protected boolean isMouseOverNode(double mouseX, double mouseY) {
        for (BuilderNode node : this.allNodes) {
            double minX = 9.0 + this.scrollX + (double)node.getX() - 12.0;
            double maxX = minX + (double)node.getWidth() + 24.0;
            double minY = 19.0 + (this.scrollY + (double)node.getY()) - 9.0;
            double maxY = minY + (double)node.getHeight() + 9.0;
            if (!(mouseX >= minX) || !(mouseX <= maxX) || !(mouseY >= minY) || !(mouseY <= maxY)) continue;
            return true;
        }
        return false;
    }

    protected abstract void loadFromJsonObject();

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button != 0) {
            this.isScrolling = false;
            return false;
        }
        if (!this.isScrolling) {
            this.isScrolling = true;
        } else {
            boolean draggingNode = false;
            for (BuilderNode node2 : this.allNodes) {
                if (!node2.isDragging()) continue;
                draggingNode = true;
                break;
            }
            if (!draggingNode) {
                this.dragGui(dragX, dragY);
            } else {
                this.allNodes.forEach(node -> {
                    if (node.isDragging()) {
                        node.setPosition((int)(-this.scrollX + mouseX), (int)(-this.scrollY + mouseY - 9.0));
                    }
                });
            }
        }
        return true;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (!this.isAnyTextFieldVisible()) {
            if (button == 0 || button == 1) {
                this.allNodes.forEach(BuilderNode::stopDragging);
            } else if (button == 2) {
                this.centerScreenOnNode(this.initNode);
            }
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        this.functionListWidget.onScrolled(delta);
        return super.m_6050_(mouseX, mouseY, delta);
    }

    protected abstract void populateNodeList(NodeData var1, @Nullable BuilderNode var2);

    public void m_6305_(@NotNull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.drawWindowBackground(matrixStack, mouseX, mouseY);
        this.functionListWidget.draw(matrixStack);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }

    protected abstract void sendCEdit();

    protected abstract void setEditingNode(BuilderNode var1);

    protected void setNewFileName(String s) {
        if (!s.isEmpty()) {
            this.fileName = s;
            if (this.conflictingNodeDataNames.size() == 0) {
                this.sendCEdit();
            }
        }
    }

    protected void setNewName(String s) {
        if (!s.isEmpty() && !s.equals("init")) {
            this.newName = s;
        }
    }

    protected void setNewFunctionParams(String s) {
        this.newFunctionParams = s;
    }

    public void setNodeBeingEdited(@Nullable BuilderNode node, EditType editType) {
        boolean isNodeNull;
        boolean bl = isNodeNull = node == null;
        if (!isNodeNull) {
            this.allNameFields.get((Object)EditType.NAME).m_94144_(node.getName());
            int i = -1;
            if (!node.getFunction().isEmpty()) {
                String[] splitFunction = node.getFunction().split("::");
                String currentFunctionName = splitFunction[0];
                for (int j = 0; j < ClientDialogueUtil.FUNCTION_NAMES.size(); ++j) {
                    String function = ClientDialogueUtil.FUNCTION_NAMES.get(j);
                    if (!function.startsWith(currentFunctionName)) continue;
                    i = j;
                    break;
                }
                this.functionListWidget.clickedOnFunction(i);
                if (splitFunction.length == 2) {
                    this.functionParamsField.m_94144_(splitFunction[1]);
                }
            }
        } else {
            this.functionParamsField.m_94144_("");
        }
        this.fileNameFrame.setVisible(editType == EditType.FILENAME);
        this.nodeNameFrame.setVisible(editType == EditType.NAME);
        for (EditType key : this.allNameFields.keySet()) {
            boolean check;
            boolean bl2 = check = editType == key;
            if (this.allNameFields.containsKey((Object)key)) {
                this.allNameFields.get((Object)key).m_94178_(check);
                this.allNameFields.get((Object)key).m_94194_(check);
            }
            if (this.allTopLevelFrames.containsKey((Object)key)) {
                this.allTopLevelFrames.get((Object)key).setVisible(check);
            }
            if (!isNodeNull) continue;
            this.allNameFields.get((Object)key).m_94144_("");
        }
        this.functionListWidget.calculatePositionAndDimensions();
        this.functionListWidget.setEditingNode(node);
        this.functionListWidget.setVisible(editType == EditType.FUNCTION);
        this.buttonFrame.setVisible(editType != EditType.NONE);
        if (editType == EditType.FUNCTION) {
            this.confirmButton.f_93620_ = this.functionParamsField.f_93620_;
            this.confirmButton.f_93621_ = this.functionParamsField.f_93621_ + 22;
            this.cancelButton.f_93620_ = this.functionParamsField.f_93620_ + this.functionParamsField.m_5711_() - this.confirmButton.m_5711_();
            this.cancelButton.f_93621_ = this.functionParamsField.f_93621_ + 22;
        }
        this.mainVFrame.recalculateSize();
        this.setEditingNode(node);
    }

    public abstract void setSelectedNode(@Nullable BuilderNode var1, int var2);

    public void m_96624_() {
        for (EditBox field : this.allNameFields.values()) {
            field.m_94120_();
        }
        this.functionParamsField.m_94120_();
        boolean isAnyTextFieldVisible = this.isAnyTextFieldVisible();
        this.saveButton.f_93624_ = !isAnyTextFieldVisible;
        this.buttonFrame.setVisible(isAnyTextFieldVisible);
        this.saveButton.f_93623_ = this.conflictingNodeDataNames.size() == 0;
        ArrayList<BuilderNode> queuedForRemoval = new ArrayList<BuilderNode>();
        for (BuilderNode node : this.allNodes) {
            if (!node.isQueuedForRemoval()) continue;
            queuedForRemoval.add(node);
        }
        for (BuilderNode node : queuedForRemoval) {
            if (node.getNodeData().getChildren().length > 0) {
                ArrayList queuedForParentRemoval = new ArrayList();
                this.allNodes.forEach(node2 -> {
                    for (int i = 0; i < node.getNodeData().getChildren().length; ++i) {
                        if (!node.getNodeData().getChildren()[i].equals(node2.getNodeData())) continue;
                        queuedForParentRemoval.add(node2);
                    }
                });
                queuedForParentRemoval.forEach(behaviorNode -> behaviorNode.setParent(null));
            }
            node.remove();
        }
        this.conflictingNodeDataNames.clear();
        block3: for (BuilderNode base : this.allNodes) {
            String name = base.getName();
            for (BuilderNode other : this.allNodes) {
                if (other.equals(base) || !other.getName().equals(name)) continue;
                if (this.conflictingNodeDataNames.contains(name)) continue block3;
                this.conflictingNodeDataNames.add(name);
                continue block3;
            }
        }
        for (BuilderNode node : this.allNodes) {
            node.hasConflictingName = this.conflictingNodeDataNames.contains(node.getName());
        }
        this.functionParamsField.f_93624_ = this.functionListWidget.isVisible() && this.functionListWidget.getSelectedFunction().contains("::");
    }

    private void updateNodePositionsFromJson() {
        JsonArray entries = this.getEntries();
        this.allNodes.forEach(node -> {
            for (int i = 0; i < entries.size(); ++i) {
                JsonObject entry = entries.get(i).getAsJsonObject();
                if (!entry.has("name") || !entry.has("x") || !entry.has("y") || !node.getNodeData().getName().equals(entry.get("name").getAsString())) continue;
                node.setPosition(entry.get("x").getAsInt(), entry.get("y").getAsInt());
            }
        });
    }

    public static enum EditType {
        NONE,
        FILENAME,
        NAME,
        FILE,
        TEXT,
        RESPONSE,
        FUNCTION;

    }
}

