/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.client.gui.screen.dialogue;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import flash.npcmod.client.gui.dialogue.Dialogue;
import flash.npcmod.client.gui.dialogue.DialogueNode;
import flash.npcmod.client.gui.screen.TreeBuilderScreen;
import flash.npcmod.core.client.dialogues.ClientDialogueUtil;
import flash.npcmod.core.node.BuilderNode;
import flash.npcmod.core.node.NodeData;
import flash.npcmod.network.PacketDispatcher;
import flash.npcmod.network.packets.client.CEditDialogue;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class DialogueBuilderScreen
extends TreeBuilderScreen {
    private String newText = "";
    private String newResponse = "";
    @Nullable
    protected DialogueNode editingNode;
    @Nullable
    protected DialogueNode selectedNode;

    public DialogueBuilderScreen(String name) {
        super(name);
    }

    @Override
    protected void confirmEdits() {
        super.confirmEdits();
        assert (this.editingNode != null);
        this.editingNode.getNodeData().setText(this.newText);
        this.editingNode.getNodeData().setResponse(this.newResponse);
    }

    private void createNode(double mouseX, double mouseY) {
        DialogueNode newNode;
        if (this.getSelectedNode() != null && this.getSelectedNodeIndex() == -2) {
            newNode = new DialogueNode(null, this, this.f_96541_, Dialogue.newDialogue());
            newNode.addChild(this.getSelectedNode().getNodeData());
            this.getSelectedNode().setParent(newNode);
        } else {
            newNode = new DialogueNode(this.getSelectedNode(), this, this.f_96541_, Dialogue.newDialogue());
        }
        newNode.setPosition((int)(-this.scrollX + mouseX - 9.0), (int)(-this.scrollY + mouseY - 18.0));
        if (this.getSelectedNode() == null || !this.getSelectedNode().getName().equals(newNode.getName())) {
            this.allNodes.add(newNode);
        }
        if (this.getSelectedNode() != null) {
            this.selectedNode = null;
        }
    }

    @Override
    protected ResourceLocation getBackground() {
        return new ResourceLocation("flashnpcs", "textures/gui/edit_dialogue/background.png");
    }

    @Override
    @Nullable
    public DialogueNode getEditingNode() {
        return this.editingNode;
    }

    @Override
    protected JsonArray getEntries() {
        if (ClientDialogueUtil.currentDialogueEditor == null) {
            return new JsonArray();
        }
        return ClientDialogueUtil.currentDialogueEditor.getAsJsonArray("entries");
    }

    @Override
    @Nullable
    public DialogueNode getSelectedNode() {
        return this.selectedNode;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        EditBox textField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.f_96543_ / 2 - 60, this.f_96544_ / 2 - 10, 120, 20, TextComponent.f_131282_));
        textField.m_94151_(this::setNewText);
        textField.m_94199_(500);
        textField.m_94194_(false);
        textField.m_94190_(true);
        this.allNameFields.put(TreeBuilderScreen.EditType.TEXT, textField);
        EditBox responseField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.f_96543_ / 2 - 60, this.f_96544_ / 2 - 10, 120, 20, TextComponent.f_131282_));
        responseField.m_94151_(this::setNewResponse);
        responseField.m_94199_(500);
        responseField.m_94194_(false);
        responseField.m_94190_(true);
        this.allNameFields.put(TreeBuilderScreen.EditType.RESPONSE, responseField);
    }

    @Override
    protected void loadFromJsonObject() {
        ClientDialogueUtil.loadDialogue(this.fileName);
        ClientDialogueUtil.loadDialogueEditor(this.fileName);
        Dialogue[] dialogues = ClientDialogueUtil.currentDialogue != null ? Dialogue.multipleFromJSONObject(ClientDialogueUtil.currentDialogue) : new Dialogue[]{new Dialogue("init")};
        this.conflictingNodeDataNames = new ArrayList();
        for (Dialogue dialogue : dialogues) {
            this.populateNodeList(dialogue, null);
        }
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.isAnyTextFieldVisible()) {
            if (button == 0 || button == 1) {
                boolean isMouseOverAnyNode = this.isMouseOverNode(mouseX, mouseY);
                if (!isMouseOverAnyNode) {
                    if (button == 0 && this.selectedNode != null) {
                        if (this.selectedNode.isStart()) {
                            this.selectedNode.getNodeData().setResponse("");
                        }
                        this.selectedNode.calculateDimensions();
                        this.selectedNode = null;
                    }
                    if (button == 1) {
                        this.createNode(mouseX, mouseY);
                    }
                }
                this.allNodes.forEach(node -> node.clickedOn(mouseX, mouseY, button, 0, 0, this.scrollX, this.scrollY));
            }
        } else if (this.functionListWidget.isVisible()) {
            this.functionListWidget.clickedOn(mouseX, mouseY);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    @Override
    protected void populateNodeList(NodeData dialogue, @Nullable BuilderNode parent) {
        DialogueNode node = new DialogueNode((DialogueNode)parent, this, Minecraft.m_91087_(), (Dialogue)dialogue);
        if (this.initNode == null && dialogue.isInitData()) {
            this.initNode = node;
        }
        this.allNodes.add(node);
        if (dialogue.getChildren().length > 0) {
            for (NodeData child : dialogue.getChildren()) {
                this.populateNodeList(child, node);
            }
        }
    }

    @Override
    public void m_6305_(@NotNull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void sendCEdit() {
        JsonObject dialogue = this.buildNodeDataJSON();
        JsonObject dialogueEditor = this.buildEditorJSON();
        PacketDispatcher.sendToServer(new CEditDialogue(this.fileName, dialogue.toString(), dialogueEditor.toString()));
    }

    @Override
    protected void setEditingNode(BuilderNode node) {
        this.editingNode = (DialogueNode)node;
    }

    private void setNewText(String s) {
        this.newText = s;
    }

    private void setNewResponse(String s) {
        this.newResponse = s;
    }

    @Override
    public void setSelectedNode(@Nullable BuilderNode node, int selectedNodeIndex) {
        this.selectedNode = (DialogueNode)node;
        this.selectedNodeIndex = selectedNodeIndex;
    }

    @Override
    public void setNodeBeingEdited(@Nullable BuilderNode node, TreeBuilderScreen.EditType editType) {
        super.setNodeBeingEdited(node, editType);
        if (node != null) {
            ((EditBox)this.allNameFields.get((Object)TreeBuilderScreen.EditType.TEXT)).m_94144_(((DialogueNode)node).getText());
            ((EditBox)this.allNameFields.get((Object)TreeBuilderScreen.EditType.RESPONSE)).m_94144_(((DialogueNode)node).getResponse());
        }
    }
}

