/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.client.gui.screen.dialogue;

import com.mojang.blaze3d.vertex.PoseStack;
import flash.npcmod.client.gui.widget.DialogueDisplayWidget;
import flash.npcmod.client.gui.widget.TextButton;
import flash.npcmod.core.client.dialogues.ClientDialogueUtil;
import flash.npcmod.entity.NpcEntity;
import flash.npcmod.network.PacketDispatcher;
import flash.npcmod.network.packets.client.CCallFunction;
import flash.npcmod.network.packets.client.CRequestQuestCapabilitySync;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DialogueScreen
extends Screen {
    private static final Random RND = new Random();
    public List<String[]> displayedText;
    private String[] currentOptions;
    private String[] currentOptionNames;
    private final NpcEntity npcEntity;
    private DialogueDisplayWidget dialogueDisplayWidget;
    private int npcTextColor;
    private String dialogueName;
    public String playerName;

    public DialogueScreen(String name, NpcEntity npcEntity) {
        super(TextComponent.f_131282_);
        this.dialogueName = name;
        ClientDialogueUtil.loadDialogue(name);
        ClientDialogueUtil.initDialogue();
        this.npcEntity = npcEntity;
        this.npcTextColor = npcEntity.getTextColor();
        this.displayedText = new ArrayList<String[]>();
        this.playerName = Minecraft.m_91087_().f_91074_.m_7755_().getString();
        if (!ClientDialogueUtil.getCurrentText().isEmpty()) {
            this.addDisplayedNPCText(ClientDialogueUtil.getCurrentText());
        }
        if (!ClientDialogueUtil.getCurrentFunction().isEmpty()) {
            PacketDispatcher.sendToServer(new CCallFunction(ClientDialogueUtil.getCurrentFunction(), npcEntity.m_142049_()));
        }
        PacketDispatcher.sendToServer(new CRequestQuestCapabilitySync());
    }

    public String getNpcName() {
        return this.npcEntity.m_7755_().getString();
    }

    public int getNpcTextColor() {
        return this.npcTextColor;
    }

    public String getDialogueName() {
        return this.dialogueName;
    }

    protected void m_7856_() {
        this.dialogueDisplayWidget = new DialogueDisplayWidget(this, 20, 20, this.f_96543_ - 120, this.f_96544_ - 60);
        this.resetOptionButtons();
    }

    public void resetOptionButtons() {
        this.currentOptions = ClientDialogueUtil.getDialogueOptionsFromChildren();
        this.currentOptionNames = ClientDialogueUtil.getDialogueOptionNamesFromChildren();
        this.m_169413_();
        if (this.currentOptionNames.length > 0) {
            int x = 20;
            int width = this.f_96543_ - 120 - x;
            int optionsHeight = 0;
            int[] optionHeights = new int[this.currentOptionNames.length];
            for (int i = 0; i < this.currentOptionNames.length; ++i) {
                int height;
                List trimmedText = this.f_96547_.m_92923_((FormattedText)new TextComponent(this.currentOptions[i]), width);
                optionHeights[i] = height = trimmedText.size() * 10;
                optionsHeight += height;
            }
            int y = this.f_96544_ - 15 - optionsHeight;
            this.dialogueDisplayWidget.setHeight(y - this.dialogueDisplayWidget.f_93621_ - 30);
            for (int i = 0; i < this.currentOptionNames.length; ++i) {
                String name = this.currentOptionNames[i];
                String text = this.currentOptions[i];
                this.m_142416_((GuiEventListener)new TextButton(x, y, width, (Component)new TextComponent(text.replaceAll("@p", this.playerName).replaceAll("@npc", this.getNpcName())), btn -> {
                    if (!text.isEmpty()) {
                        this.addDisplayedPlayerText(text);
                    }
                    ClientDialogueUtil.loadDialogueOption(name);
                    if (!ClientDialogueUtil.getCurrentResponse().isEmpty()) {
                        this.addDisplayedNPCText(ClientDialogueUtil.getCurrentResponse());
                    }
                    this.dialogueDisplayWidget.clampScroll(0);
                    if (!ClientDialogueUtil.getCurrentFunction().isEmpty()) {
                        PacketDispatcher.sendToServer(new CCallFunction(ClientDialogueUtil.getCurrentFunction(), this.npcEntity.m_142049_()));
                    }
                    this.resetOptionButtons();
                }));
                y += optionHeights[i] + 2;
            }
        }
    }

    public void chooseRandomOption() {
        ArrayList options = new ArrayList();
        this.m_6702_().forEach(btn -> {
            if (btn instanceof TextButton) {
                options.add((TextButton)((Object)btn));
            }
        });
        ((TextButton)((Object)options.get(RND.nextInt(options.size())))).m_5691_();
    }

    public void addDisplayedPlayerText(String text) {
        this.addDisplayedText(this.playerName, text);
    }

    public void addDisplayedNPCText(String text) {
        this.addDisplayedText(this.getNpcName(), text);
    }

    private void addDisplayedText(String name, String text) {
        String newText = name + ": " + text.replaceAll("@p", this.playerName).replaceAll("@npc", this.getNpcName());
        this.displayedText.add(DialogueScreen.splitTextIntoLines(newText));
    }

    public static String[] splitTextIntoLines(String text) {
        if (text.contains("\\n")) {
            ArrayList<String> lines = new ArrayList<String>();
            while (text.contains("\\n")) {
                int index = text.lastIndexOf("\\n");
                String s = text.substring(index + 2);
                lines.add(s);
                text = text.substring(0, index);
            }
            lines.add(text);
            return (String[])lines.toArray(String[]::new);
        }
        return new String[]{text};
    }

    public void m_96624_() {
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        int x = this.f_96543_ - 60;
        int y = (int)((float)(this.f_96544_ / 4) * 2.5f);
        float bbHeight = Math.max(this.npcEntity.m_20206_(), 1.0f);
        int scale = (int)((float)this.f_96544_ / 3.0f / bbHeight);
        InventoryScreen.m_98850_((int)x, (int)y, (int)scale, (float)40.0f, (float)-20.0f, (LivingEntity)this.npcEntity);
        this.dialogueDisplayWidget.m_6303_(matrixStack, mouseX, mouseY, partialTicks);
        x = 20;
        int maxX = this.f_96543_ - 120;
        int y2 = this.dialogueDisplayWidget.f_93621_ + this.dialogueDisplayWidget.m_93694_();
        this.m_93154_(matrixStack, x, maxX, y2 + 9, -16777216);
        this.m_93154_(matrixStack, x, maxX, y2 + 10, -1);
        this.m_93154_(matrixStack, x, maxX, y2 + 11, -16777216);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        this.dialogueDisplayWidget.m_6050_(mouseX, mouseY, delta);
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_7043_() {
        return false;
    }
}

