/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.client.gui.screen.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import flash.npcmod.client.gui.widget.TradeWidget;
import flash.npcmod.core.trades.TradeOffer;
import flash.npcmod.core.trades.TradeOffers;
import flash.npcmod.entity.NpcEntity;
import flash.npcmod.inventory.container.NpcTradeContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class NpcTradeScreen
extends AbstractContainerScreen<NpcTradeContainer> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("flashnpcs", "textures/gui/npc_trades.png");
    private NpcEntity npcEntity;
    private TradeOffers notEmptyTradeOffers;
    private Map<TradeOffer, Integer> offerToIndexMap;
    private double scrollY;
    private boolean isScrolling;
    private int scrollOffset;
    private int maxScrollOffset;
    private TradeWidget[] tradeWidgets;

    public NpcTradeScreen(NpcTradeContainer screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.f_96546_ = true;
        this.f_97728_ = 0;
        this.f_97729_ = -12;
        this.scrollY = 0.0;
        this.isScrolling = false;
        this.scrollOffset = 0;
        this.tradeWidgets = new TradeWidget[3];
        this.npcEntity = ((NpcTradeContainer)this.f_97732_).getNpcEntity();
        this.notEmptyTradeOffers = new TradeOffers();
        this.offerToIndexMap = new HashMap<TradeOffer, Integer>();
        for (int i = 0; i < this.npcEntity.getOffers().size(); ++i) {
            TradeOffer offer = (TradeOffer)this.npcEntity.getOffers().get(i);
            if (offer.isEmpty()) continue;
            ItemStack[] buyingStacks = this.formatArray(offer.getBuyingStacks());
            ItemStack[] sellingStacks = this.formatArray(offer.getSellingStacks());
            TradeOffer formattedOffer = new TradeOffer(buyingStacks, sellingStacks);
            this.notEmptyTradeOffers.add(formattedOffer);
            this.offerToIndexMap.put(formattedOffer, i);
        }
        this.maxScrollOffset = this.notEmptyTradeOffers.size() - 3;
    }

    public Map<TradeOffer, Integer> getOfferToIndexMap() {
        return this.offerToIndexMap;
    }

    public int getNpcId() {
        return this.npcEntity.m_142049_();
    }

    public void renderItemTooltip(PoseStack matrixStack, ItemStack itemStack, int mouseX, int mouseY) {
        super.m_6057_(matrixStack, itemStack, mouseX, mouseY);
    }

    private int getMaxTradeWidgets() {
        return this.canScroll() ? 3 : this.notEmptyTradeOffers.size();
    }

    protected void m_7856_() {
        super.m_7856_();
        int i = this.getMaxTradeWidgets();
        for (int j = 0; j < i; ++j) {
            this.tradeWidgets[j] = (TradeWidget)this.m_142416_((GuiEventListener)new TradeWidget(this, this.f_97735_ + 8, this.f_97736_ + 8 + j * 20, 153, 20, (TradeOffer)this.notEmptyTradeOffers.get(j + this.scrollOffset)));
        }
        this.updateTradeOffers();
    }

    protected void m_181908_() {
        int i = this.getMaxTradeWidgets();
        for (int j = 0; j < i; ++j) {
            this.tradeWidgets[j].activeCheck();
        }
    }

    private ItemStack[] formatArray(ItemStack[] array) {
        int i;
        ArrayList<ItemStack> notEmpty = new ArrayList<ItemStack>();
        for (ItemStack stack : array) {
            if (stack.m_41619_()) continue;
            notEmpty.add(stack);
        }
        ItemStack[] newArray = new ItemStack[array.length];
        for (i = 0; i < notEmpty.size(); ++i) {
            newArray[i] = (ItemStack)notEmpty.get(i);
        }
        for (i = notEmpty.size(); i < newArray.length; ++i) {
            newArray[i] = ItemStack.f_41583_;
        }
        return newArray;
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int x, int y) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        int i = this.f_97735_;
        int j = this.f_97736_;
        this.m_93228_(matrixStack, i, j, 0, 0, this.f_97726_, this.f_97727_);
        if (this.canScroll()) {
            matrixStack.m_85836_();
            int v = this.isMouseOverScrollBar(x, y) ? 7 : 0;
            matrixStack.m_85837_(0.0, this.scrollY, 0.0);
            this.m_93228_(matrixStack, i + 164, j + 8, this.f_97726_, v, 4, 7);
            matrixStack.m_85849_();
            if (this.scrollOffset < this.maxScrollOffset) {
                this.m_93228_(matrixStack, i + 8, j + 68, 0, 166, 153, 10);
            }
        }
        float bbHeight = Math.max(this.npcEntity.m_20206_(), 1.0f);
        int scale = (int)(108.0f / bbHeight);
        InventoryScreen.m_98850_((int)(i + this.f_97726_ + 45), (int)(j + 140), (int)scale, (float)40.0f, (float)-5.0f, (LivingEntity)this.npcEntity);
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_7025_(matrixStack, mouseX, mouseY);
    }

    protected void m_7027_(PoseStack matrixStack, int x, int y) {
        this.f_96547_.m_92889_(matrixStack, (Component)new TranslatableComponent("screen.trades.title", new Object[]{this.f_96539_.getString()}), (float)this.f_97728_, (float)this.f_97729_, 0xFFFFFF);
    }

    private boolean canScroll() {
        return this.notEmptyTradeOffers.size() > 3;
    }

    private boolean isMouseOverScrollBar(double mouseX, double mouseY) {
        int i = this.f_97735_ + 164;
        int j = this.f_97736_ + 8;
        return mouseX >= (double)i && mouseX <= (double)(i + 4) && mouseY >= (double)j && mouseY <= (double)(j + 70);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isMouseOverScrollBar(mouseX, mouseY)) {
            this.isScrolling = true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button != 0) {
            this.isScrolling = false;
        } else if (this.isScrolling) {
            this.updateScrollY(dragY);
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.isScrolling = false;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        this.updateScrollY(-delta * 3.0);
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private void updateScrollY(double delta) {
        if (this.canScroll()) {
            this.scrollY = Mth.m_14008_((double)(this.scrollY + delta), (double)0.0, (double)63.0);
            this.scrollOffset = (int)(this.scrollY * (double)this.maxScrollOffset / 63.0);
        } else {
            this.scrollY = 0.0;
            this.scrollOffset = 0;
        }
        this.updateTradeOffers();
    }

    private void updateTradeOffers() {
        if (this.notEmptyTradeOffers.size() > 0) {
            int i = this.getMaxTradeWidgets();
            for (int j = 0; j < i; ++j) {
                this.tradeWidgets[j].setTradeOffer((TradeOffer)this.notEmptyTradeOffers.get(j + this.scrollOffset));
            }
        }
    }
}

