/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.client.gui.screen.quests;

import com.mojang.blaze3d.vertex.PoseStack;
import flash.npcmod.client.gui.screen.quests.QuestObjectiveBuilderScreen;
import flash.npcmod.core.client.quests.ClientQuestUtil;
import flash.npcmod.core.quests.Quest;
import flash.npcmod.core.quests.QuestObjective;
import flash.npcmod.network.PacketDispatcher;
import flash.npcmod.network.packets.client.CBuildQuest;
import flash.npcmod.network.packets.client.CRequestContainer;
import flash.npcmod.network.packets.client.CRequestQuestInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class QuestEditorScreen
extends Screen {
    private EditBox nameField;
    private EditBox displayNameField;
    private EditBox xpRewardField;
    private EditBox runOnCompleteField;
    private EditBox loadQuestField;
    private Checkbox repeatableCheckbox;
    private Button objectiveBuilderButton;
    private Button itemsFromInventoryButton;
    private Button plusRunOnCompleteButton;
    private Button confirmButton;
    private Button loadButton;
    private Button[] objectiveEditButton;
    private Button[] objectiveRemoveButton;
    private Button[] removeRunOnCompleteButton;
    private int objectiveId = 0;
    private String name = "";
    private String displayName = "";
    protected List<QuestObjective> objectives;
    private int xpReward = 0;
    private List<ItemStack> itemRewards;
    private boolean repeatable = true;
    private List<String> runOnComplete;
    private String currentRunOnComplete = "";
    private String questToLoad = "";
    private int objectiveScrollY;
    private int runOnCompleteScrollY;
    private static final int objectiveDisplayLimit = 6;
    private static final int runOnCompleteDisplayLimit = 8;
    private static final String NAME = "Name: ";
    private static final String DISPLAYNAME = "Display name: ";
    private static final String OBJECTIVES = "Objectives: ";
    private static final String XPREWARD = "XP Reward: ";
    private static final String ITEMREWARDS = "Item Rewards: ";
    private static final String REPEATABLE = "Repeatable? ";
    private static final String RUNONCOMPLETE = "Run on completion: ";
    private static final String DOTS = "... ";
    private final Predicate<String> nameFilter = text -> {
        Pattern pattern = Pattern.compile("\\s");
        Matcher matcher = pattern.matcher((CharSequence)text);
        return !matcher.find();
    };

    public QuestEditorScreen() {
        super(TextComponent.f_131282_);
        this.objectives = new ArrayList<QuestObjective>();
        this.itemRewards = new ArrayList<ItemStack>();
        this.runOnComplete = new ArrayList<String>();
    }

    public int nextID() {
        return this.objectiveId++;
    }

    public static QuestEditorScreen fromQuest(Quest quest) {
        QuestEditorScreen questEditorScreen = new QuestEditorScreen();
        questEditorScreen.name = quest.getName();
        questEditorScreen.displayName = quest.getDisplayName();
        questEditorScreen.objectives.addAll(quest.getObjectives());
        questEditorScreen.xpReward = quest.getXpReward();
        questEditorScreen.itemRewards = quest.getItemRewards();
        questEditorScreen.repeatable = quest.isRepeatable();
        questEditorScreen.runOnComplete = quest.getRunOnComplete();
        return questEditorScreen;
    }

    public void updateObjectiveId() {
        this.objectiveId = this.objectives.size();
    }

    protected void m_7856_() {
        int j;
        int i;
        this.nameField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, 5 + this.f_96547_.m_92895_(NAME), 5, 120, 20, TextComponent.f_131282_));
        this.nameField.m_94153_(this.nameFilter);
        this.nameField.m_94151_(this::setName);
        this.nameField.m_94144_(this.name);
        this.nameField.m_94199_(50);
        this.nameField.m_94190_(true);
        this.displayNameField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, 5 + this.f_96547_.m_92895_(DISPLAYNAME), 34, 120, 20, TextComponent.f_131282_));
        this.displayNameField.m_94151_(this::setDisplayName);
        this.displayNameField.m_94144_(this.displayName);
        this.displayNameField.m_94199_(400);
        this.displayNameField.m_94190_(true);
        this.repeatableCheckbox = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(5 + this.f_96547_.m_92895_(NAME) + 130 + this.f_96547_.m_92895_(REPEATABLE), 5, 20, 20, TextComponent.f_131282_, this.repeatable));
        this.objectiveBuilderButton = (Button)this.m_142416_((GuiEventListener)new Button(5 + this.f_96547_.m_92895_(OBJECTIVES), 64, 120, 20, (Component)new TextComponent("Objective Builder"), btn -> this.f_96541_.m_91152_((Screen)new QuestObjectiveBuilderScreen(this, null))));
        this.objectiveEditButton = new Button[6];
        this.objectiveRemoveButton = new Button[6];
        for (i = 0; i < this.objectiveEditButton.length; ++i) {
            j = i;
            this.objectiveEditButton[i] = (Button)this.m_142416_((GuiEventListener)new Button(10, 86 + i * 15, 40, 14, (Component)new TextComponent("Edit"), btn -> this.editObjective(j)));
            this.objectiveRemoveButton[i] = (Button)this.m_142416_((GuiEventListener)new Button(51, 86 + i * 15, 40, 14, (Component)new TextComponent("Remove"), btn -> this.removeObjective(j)));
            this.objectiveEditButton[i].f_93624_ = false;
            this.objectiveRemoveButton[i].f_93624_ = false;
        }
        this.runOnCompleteField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.f_96543_ / 2, 64, 120, 20, TextComponent.f_131282_));
        this.runOnCompleteField.m_94151_(this::setRunOnComplete);
        this.runOnCompleteField.m_94144_(this.currentRunOnComplete);
        this.runOnCompleteField.m_94199_(400);
        this.runOnCompleteField.m_94190_(true);
        this.plusRunOnCompleteButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 125, 64, 20, 20, (Component)new TextComponent("+"), btn -> {
            if (this.canAddRunOnComplete()) {
                this.runOnComplete.add(this.currentRunOnComplete);
            }
            this.runOnCompleteField.m_94144_("");
        }));
        this.plusRunOnCompleteButton.f_93623_ = this.canAddRunOnComplete();
        this.removeRunOnCompleteButton = new Button[8];
        for (i = 0; i < this.removeRunOnCompleteButton.length; ++i) {
            j = i;
            this.removeRunOnCompleteButton[i] = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 10, 86 + i * 12, 10, 10, (Component)new TextComponent("-"), btn -> this.removeRunOnComplete(j)));
            this.removeRunOnCompleteButton[i].f_93624_ = false;
        }
        int xpRewardY = 178;
        this.xpRewardField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, 5 + this.f_96547_.m_92895_(XPREWARD), xpRewardY, 100, 20, TextComponent.f_131282_));
        this.xpRewardField.m_94151_(this::setXpReward);
        this.xpRewardField.m_94144_(String.valueOf(this.xpReward));
        this.xpRewardField.m_94199_(10);
        this.xpRewardField.m_94190_(true);
        this.itemsFromInventoryButton = (Button)this.m_142416_((GuiEventListener)new Button(5 + this.f_96547_.m_92895_(ITEMREWARDS), xpRewardY + 25, 100, 20, (Component)new TextComponent("From Inventory"), btn -> {
            String name = this.build().toJson().toString();
            PacketDispatcher.sendToServer(new CRequestContainer(name, CRequestContainer.ContainerType.QUEST_STACK_SELECTOR));
        }));
        this.confirmButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ - 100, this.f_96544_ - 20, 100, 20, (Component)new TextComponent("Build"), btn -> {
            if (this.canBuild()) {
                PacketDispatcher.sendToServer(new CBuildQuest(this.build()));
                this.m_7379_();
            }
        }));
        this.loadQuestField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.f_96543_ - 105, 5, 100, 20, TextComponent.f_131282_));
        this.loadQuestField.m_94151_(this::setQuestToLoad);
        this.loadQuestField.m_94144_(this.questToLoad);
        this.loadQuestField.m_94199_(51);
        this.loadQuestField.m_94190_(true);
        this.loadButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ - 105, 30, 100, 20, (Component)new TextComponent("Load"), btn -> {
            if (!this.questToLoad.isEmpty()) {
                PacketDispatcher.sendToServer(new CRequestQuestInfo(this.questToLoad));
                Quest quest = ClientQuestUtil.loadQuest(this.questToLoad);
                if (quest != null) {
                    QuestEditorScreen questEditorScreen = QuestEditorScreen.fromQuest(quest);
                    questEditorScreen.updateObjectiveId();
                    this.f_96541_.m_91152_((Screen)questEditorScreen);
                }
            }
        }));
    }

    public void setQuestToLoad(String questToLoad) {
        this.questToLoad = questToLoad;
    }

    private boolean canAddRunOnComplete() {
        return this.currentRunOnComplete.startsWith("/") || this.currentRunOnComplete.startsWith("acceptQuest:");
    }

    private void editObjective(int i) {
        if (i + this.objectiveScrollY < this.objectives.size()) {
            this.f_96541_.m_91152_((Screen)new QuestObjectiveBuilderScreen(this, this.objectives.get(i + this.objectiveScrollY), this.objectives.get(i + this.objectiveScrollY).getName()));
        }
    }

    private void removeObjective(int i) {
        if (i + this.objectiveScrollY < this.objectives.size()) {
            this.objectives.remove(i + this.objectiveScrollY);
            this.objectiveScrollY = this.clampObjectiveScroll(this.objectiveScrollY - 1);
            for (int j = i + this.objectiveScrollY; j < this.objectives.size(); ++j) {
                this.objectives.get(j).setId(j);
            }
        }
    }

    private void removeRunOnComplete(int i) {
        if (i + this.runOnCompleteScrollY < this.runOnComplete.size()) {
            this.runOnComplete.remove(i + this.runOnCompleteScrollY);
            this.runOnCompleteScrollY = this.clampObjectiveScroll(this.runOnCompleteScrollY - 1);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setXpReward(String xpReward) {
        try {
            this.xpReward = Integer.parseInt(xpReward);
        }
        catch (NumberFormatException nfe) {
            this.xpReward = 0;
        }
    }

    public void setRunOnComplete(String runOnComplete) {
        this.currentRunOnComplete = runOnComplete;
    }

    private int maxDisplayedObjectives() {
        return Math.min(6, this.objectives.size());
    }

    private int maxDisplayedRunOnComplete() {
        return Math.min(8, this.runOnComplete.size());
    }

    public void m_96624_() {
        int i;
        this.nameField.m_94120_();
        this.displayNameField.m_94120_();
        this.runOnCompleteField.m_94120_();
        this.xpRewardField.m_94120_();
        for (i = 0; i < this.objectiveEditButton.length; ++i) {
            this.objectiveEditButton[i].f_93624_ = this.objectives.size() > i + this.objectiveScrollY;
            this.objectiveRemoveButton[i].f_93624_ = this.objectives.size() > i + this.objectiveScrollY;
        }
        for (i = 0; i < this.removeRunOnCompleteButton.length; ++i) {
            this.removeRunOnCompleteButton[i].f_93624_ = this.runOnComplete.size() > i + this.runOnCompleteScrollY;
        }
        this.plusRunOnCompleteButton.f_93623_ = this.canAddRunOnComplete();
        this.repeatable = this.repeatableCheckbox.m_93840_();
        this.confirmButton.f_93623_ = this.canBuild();
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int i;
        this.m_7333_(matrixStack);
        QuestEditorScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)NAME, (int)5, (int)10, (int)0xFFFFFF);
        QuestEditorScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)REPEATABLE, (int)(5 + this.f_96547_.m_92895_(NAME) + 130), (int)10, (int)0xFFFFFF);
        QuestEditorScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)DISPLAYNAME, (int)5, (int)40, (int)0xFFFFFF);
        QuestEditorScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)OBJECTIVES, (int)5, (int)70, (int)0xFFFFFF);
        QuestEditorScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)RUNONCOMPLETE, (int)(this.f_96543_ / 2), (int)52, (int)0xFFFFFF);
        int xpRewardY = 184;
        QuestEditorScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)XPREWARD, (int)5, (int)xpRewardY, (int)0xFFFFFF);
        QuestEditorScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)ITEMREWARDS, (int)5, (int)(xpRewardY + 25), (int)0xFFFFFF);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        int objXpos = 10 + this.objectiveEditButton[0].m_5711_() + 1 + this.objectiveRemoveButton[0].m_5711_() + 3;
        int maxObjectiveWidth = this.f_96543_ / 2 - objXpos - 15;
        for (int i2 = 0; i2 < this.maxDisplayedObjectives(); ++i2) {
            if (i2 + this.objectiveScrollY >= this.objectives.size()) continue;
            QuestObjective objective = this.objectives.get(i2 + this.objectiveScrollY);
            int swidth = this.f_96547_.m_92895_(objective.getName());
            String name = swidth > maxObjectiveWidth ? this.f_96547_.m_92834_(objective.getName(), maxObjectiveWidth - this.f_96547_.m_92895_(DOTS)) + DOTS : objective.getName();
            QuestEditorScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)name, (int)objXpos, (int)(89 + 15 * i2), (int)0xFFFFFF);
            if (mouseX < objXpos || mouseX > objXpos + this.f_96547_.m_92895_(name) || mouseY < 86 + i2 * 15 || mouseY > 100 + i2 * 15) continue;
            this.m_96617_(matrixStack, this.getObjectiveTooltip(objective), mouseX, mouseY);
        }
        int runOnCompleteXpos = 10 + this.removeRunOnCompleteButton[0].m_5711_() + 3;
        int maxRunOnCompleteWidth = this.f_96543_ / 2 - runOnCompleteXpos - 15;
        for (i = 0; i < this.maxDisplayedRunOnComplete(); ++i) {
            if (i + this.runOnCompleteScrollY >= this.runOnComplete.size()) continue;
            String runnable = this.runOnComplete.get(i + this.runOnCompleteScrollY);
            int swidth = this.f_96547_.m_92895_(runnable);
            String name = swidth > maxRunOnCompleteWidth ? this.f_96547_.m_92834_(runnable, maxRunOnCompleteWidth - this.f_96547_.m_92895_(DOTS)) + DOTS : runnable;
            QuestEditorScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)name, (int)(this.f_96543_ / 2 + runOnCompleteXpos), (int)(87 + i * 12), (int)0xFFFFFF);
            if (mouseX < this.f_96543_ / 2 + runOnCompleteXpos || mouseX > this.f_96543_ / 2 + runOnCompleteXpos + this.f_96547_.m_92895_(name) || mouseY < 86 + i * 12 || mouseY > 96 + i * 12) continue;
            this.m_96602_(matrixStack, (Component)new TextComponent(runnable), mouseX, mouseY);
        }
        for (i = 0; i < this.itemRewards.size(); ++i) {
            ItemStack stack = this.itemRewards.get(i);
            int minX = 10 + this.f_96547_.m_92895_(ITEMREWARDS) + this.itemsFromInventoryButton.m_5711_();
            int x = minX + 17 * i;
            int y = xpRewardY + 21;
            if (x + 16 > this.f_96543_) {
                int j = (this.f_96543_ - minX) / 17;
                int k = i / j;
                x = minX + 17 * (i - j * k);
                y += k * 17;
            }
            this.f_96541_.m_91291_().m_115203_(stack, x, y);
            this.f_96541_.m_91291_().m_115169_(this.f_96547_, stack, x, y);
            if (mouseX < x || mouseX > x + 16 || mouseY < y || mouseY > y + 16) continue;
            this.m_6057_(matrixStack, stack, mouseX, mouseY);
        }
    }

    private List<FormattedCharSequence> getObjectiveTooltip(QuestObjective objective) {
        ArrayList<FormattedCharSequence> tooltips = new ArrayList<FormattedCharSequence>();
        tooltips.add(FormattedCharSequence.m_13714_((String)objective.getName(), (Style)Style.f_131099_.m_131157_(ChatFormatting.WHITE)));
        tooltips.add(FormattedCharSequence.m_13714_((String)("Type: " + objective.getType().name()), (Style)Style.f_131099_.m_131157_(ChatFormatting.GRAY)));
        Object primary = objective.primaryToString();
        if (this.f_96547_.m_92895_((String)primary) > 100) {
            primary = this.f_96547_.m_92834_((String)primary, 100 - this.f_96547_.m_92895_("...")) + "...";
        }
        tooltips.add(FormattedCharSequence.m_13714_((String)("Objective: " + (String)primary), (Style)Style.f_131099_.m_131157_(ChatFormatting.GRAY)));
        if (objective.getSecondaryObjective() != null) {
            Object secondary = objective.secondaryToString();
            if (this.f_96547_.m_92895_((String)secondary) > 100) {
                secondary = this.f_96547_.m_92834_((String)secondary, 100 - this.f_96547_.m_92895_("...")) + "...";
            }
            tooltips.add(FormattedCharSequence.m_13714_((String)("Secondary Objective: " + (String)secondary), (Style)Style.f_131099_.m_131157_(ChatFormatting.GRAY)));
        }
        tooltips.add(FormattedCharSequence.m_13714_((String)("Amount: " + objective.getAmount()), (Style)Style.f_131099_.m_131157_(ChatFormatting.GRAY)));
        if (objective.isOptional()) {
            tooltips.add(FormattedCharSequence.m_13714_((String)"Optional", (Style)Style.f_131099_.m_131157_(ChatFormatting.GREEN)));
        }
        if (objective.isHidden()) {
            tooltips.add(FormattedCharSequence.m_13714_((String)"Hidden by Default", (Style)Style.f_131099_.m_131157_(ChatFormatting.RED)));
        }
        if (!objective.shouldDisplayProgress()) {
            tooltips.add(FormattedCharSequence.m_13714_((String)"Won't display progress", (Style)Style.f_131099_.m_131157_(ChatFormatting.YELLOW)));
        }
        if (objective.getRunOnComplete() != null && !objective.getRunOnComplete().isEmpty()) {
            tooltips.add(FormattedCharSequence.m_13714_((String)"Run on Completion: ", (Style)Style.f_131099_.m_131157_(ChatFormatting.AQUA)));
            for (int i = 0; i < Math.min(3, objective.getRunOnComplete().size()); ++i) {
                Object runOnComplete = objective.getRunOnComplete().get(i);
                if (this.f_96547_.m_92895_((String)runOnComplete) > 120) {
                    runOnComplete = this.f_96547_.m_92834_((String)runOnComplete, 120 - this.f_96547_.m_92895_("...")) + "...";
                }
                tooltips.add(FormattedCharSequence.m_13714_((String)runOnComplete, (Style)Style.f_131099_.m_131157_(ChatFormatting.WHITE)));
                if (objective.getRunOnComplete().size() <= 3 || i != 2) continue;
                tooltips.add(FormattedCharSequence.m_13714_((String)"...", (Style)Style.f_131099_.m_131157_(ChatFormatting.WHITE)));
            }
        }
        return tooltips;
    }

    private boolean canBuild() {
        return !this.name.isEmpty() && !this.displayName.isEmpty() && !this.objectives.isEmpty();
    }

    public Quest build() {
        return new Quest(this.name, this.displayName, this.objectives, this.xpReward, this.itemRewards, this.repeatable, this.runOnComplete);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (delta > 0.0) {
            if (mouseX < (double)(this.f_96543_ / 2)) {
                this.objectiveScrollY = this.clampObjectiveScroll(this.objectiveScrollY - 1);
            } else {
                this.runOnCompleteScrollY = this.clampRunOnCompleteScroll(this.runOnCompleteScrollY - 1);
            }
        } else if (mouseX < (double)(this.f_96543_ / 2)) {
            this.objectiveScrollY = this.clampObjectiveScroll(this.objectiveScrollY + 1);
        } else {
            this.runOnCompleteScrollY = this.clampRunOnCompleteScroll(this.runOnCompleteScrollY + 1);
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public int clampObjectiveScroll(int newScroll) {
        int max = this.objectives.size() - 6;
        if (max > 0) {
            return Mth.m_14045_((int)newScroll, (int)0, (int)max);
        }
        return 0;
    }

    public int clampRunOnCompleteScroll(int newScroll) {
        int max = this.runOnComplete.size() - 8;
        if (max > 0) {
            return Mth.m_14045_((int)newScroll, (int)0, (int)max);
        }
        return 0;
    }
}

