/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.client.gui.screen.quests;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import flash.npcmod.capability.quests.QuestCapabilityProvider;
import flash.npcmod.client.gui.overlay.HudOverlay;
import flash.npcmod.core.quests.Quest;
import flash.npcmod.core.quests.QuestInstance;
import flash.npcmod.core.quests.QuestObjective;
import flash.npcmod.events.ClientEvents;
import flash.npcmod.network.PacketDispatcher;
import flash.npcmod.network.packets.client.CAbandonQuest;
import flash.npcmod.network.packets.client.CTrackQuest;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class QuestLogScreen
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("flashnpcs", "textures/gui/quest_log.png");
    private ImageButton[] questButtons;
    private ImageButton abandonQuestButton;
    private ImageButton trackQuestButton;
    private List<QuestInstance> acceptedQuests = new ArrayList<QuestInstance>();
    private QuestInstance currentViewingQuest;
    private int guiX;
    private int guiY;
    private int scrollOffset;
    private double scrollY;
    private boolean isScrolling;
    private int objectiveScrollY;
    private static final int LINEHEIGHT;
    private static final TranslatableComponent TITLE;
    private static final TranslatableComponent OBJECTIVES;
    private static final TranslatableComponent REWARD;
    private static final TranslatableComponent ITEMREWARD;
    private static final TranslatableComponent TRACK;
    private static final TranslatableComponent ABANDON;

    public QuestLogScreen() {
        super(TextComponent.f_131282_);
    }

    protected void m_7856_() {
        this.guiX = this.f_96543_ / 2 - 115;
        this.guiY = this.f_96544_ / 2 - 91;
        this.questButtons = new ImageButton[10];
        for (int i = 0; i < this.questButtons.length; ++i) {
            int j = i;
            this.questButtons[i] = (ImageButton)this.m_142416_((GuiEventListener)new ImageButton(this.guiX + 8, this.guiY + 14 + i * 16, 102, 16, 0, 198, 16, TEXTURE, btn -> this.selectQuest(j)));
            this.questButtons[i].f_93624_ = this.acceptedQuests.size() > i + this.scrollOffset;
        }
        this.trackQuestButton = (ImageButton)this.m_142416_((GuiEventListener)new ImageButton(this.guiX + 120, this.guiY + 142, 102, 16, 0, 198, 16, TEXTURE, btn -> {
            if (this.currentViewingQuest != null && this.acceptedQuests.contains(this.currentViewingQuest)) {
                PacketDispatcher.sendToServer(new CTrackQuest(this.currentViewingQuest.getQuest().getName()));
            }
        }));
        this.abandonQuestButton = (ImageButton)this.m_142416_((GuiEventListener)new ImageButton(this.guiX + 120, this.guiY + 158, 102, 16, 0, 198, 16, TEXTURE, btn -> {
            if (this.currentViewingQuest != null && this.acceptedQuests.contains(this.currentViewingQuest)) {
                PacketDispatcher.sendToServer(new CAbandonQuest(this.currentViewingQuest));
                this.currentViewingQuest = null;
            }
        }));
    }

    private void selectQuest(int i) {
        if (i + this.scrollOffset < this.acceptedQuests.size()) {
            this.objectiveScrollY = 0;
            this.currentViewingQuest = this.acceptedQuests.get(i + this.scrollOffset);
        }
    }

    public void m_96624_() {
        boolean isViewingQuest;
        this.acceptedQuests = QuestCapabilityProvider.getCapability((Player)this.f_96541_.f_91074_).getAcceptedQuests();
        if (this.acceptedQuests.size() > 10 && this.scrollOffset > this.acceptedQuests.size() - 10) {
            this.updateScrollY(0.0, 0.0, 0.0);
        }
        if (!this.acceptedQuests.contains(this.currentViewingQuest)) {
            this.currentViewingQuest = null;
        }
        for (int i = 0; i < this.questButtons.length; ++i) {
            this.questButtons[i].f_93624_ = this.acceptedQuests.size() > i + this.scrollOffset;
        }
        this.trackQuestButton.f_93624_ = isViewingQuest = this.currentViewingQuest != null;
        this.abandonQuestButton.f_93624_ = isViewingQuest;
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Object questName;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        this.m_93228_(matrixStack, this.guiX, this.guiY, 0, 0, 230, 182);
        this.f_96547_.m_92883_(matrixStack, TITLE.getString(), (float)(this.guiX + 7), (float)(this.guiY + 4), 0x404040);
        if (this.acceptedQuests.size() > 10) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, this.scrollY, 0.0);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
            this.m_93228_(matrixStack, this.guiX + 113, this.guiY + 14, 102, 182 + (this.isMouseOnScrollBar(mouseX, mouseY) ? 7 : 0), 4, 7);
            matrixStack.m_85849_();
        }
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.currentViewingQuest != null && this.acceptedQuests.contains(this.currentViewingQuest)) {
            int i;
            String givenBy = this.currentViewingQuest.getPickedUpFromName();
            this.f_96547_.m_92883_(matrixStack, givenBy, (float)(this.guiX + 171 - this.f_96547_.m_92895_(givenBy) / 2), (float)(this.guiY + 4), 0x404040);
            Quest quest = this.currentViewingQuest.getQuest();
            ResourceLocation questIcon = quest.canComplete() ? ClientEvents.QUEST_COMPLETE_ICON : ClientEvents.QUEST_ICON;
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)questIcon);
            QuestLogScreen.m_93160_((PoseStack)matrixStack, (int)(this.guiX + 165), (int)(this.guiY + 16), (int)12, (int)12, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
            questName = quest.getDisplayName();
            List<QuestObjective> objectives = quest.getObjectives();
            ArrayList visibleObjectives = new ArrayList();
            objectives.forEach(objective -> {
                if (!objective.isHidden()) {
                    visibleObjectives.add(objective);
                }
            });
            List<ItemStack> itemRewards = quest.getItemRewards();
            int xpReward = quest.getXpReward();
            int yOffset = LINEHEIGHT;
            if (this.f_96547_.m_92895_((String)questName) > 100) {
                List trimmedQuestName = this.f_96547_.m_92923_((FormattedText)new TextComponent((String)questName), 100);
                yOffset = trimmedQuestName.size() * LINEHEIGHT;
                for (i = 0; i < trimmedQuestName.size(); ++i) {
                    FormattedCharSequence processor = (FormattedCharSequence)trimmedQuestName.get(i);
                    int nameWidth = (int)this.f_96547_.m_92865_().m_92336_(processor);
                    this.f_96547_.m_92877_(matrixStack, processor, (float)(this.guiX + 171 - nameWidth / 2), (float)(this.guiY + 29 + LINEHEIGHT * i), 0xFFFF00);
                }
            } else {
                QuestLogScreen.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)questName, (int)(this.guiX + 171), (int)(this.guiY + 29), (int)0xFFFF00);
            }
            QuestLogScreen.m_93243_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)OBJECTIVES, (int)(this.guiX + 123), (int)(this.guiY + 29 + yOffset), (int)0xFFFFFF);
            int maxVisibleObjectives = Math.min(6 - ((yOffset += LINEHEIGHT) / LINEHEIGHT - 1), visibleObjectives.size());
            for (i = 0; i < maxVisibleObjectives; ++i) {
                if (i + this.objectiveScrollY < visibleObjectives.size()) {
                    QuestObjective objective2 = (QuestObjective)visibleObjectives.get(i + this.objectiveScrollY);
                    int x = this.guiX + 218 - LINEHEIGHT;
                    int y = this.guiY + 29 + yOffset + LINEHEIGHT * i;
                    if (visibleObjectives.size() > maxVisibleObjectives && i + this.objectiveScrollY <= visibleObjectives.size() - maxVisibleObjectives && i == maxVisibleObjectives - 1) {
                        QuestLogScreen.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)"...", (int)(this.guiX + 171), (int)y, (int)0xFFFFFF);
                        continue;
                    }
                    HudOverlay.drawObjective(matrixStack, x, y, objective2, 80);
                    if (mouseX < this.guiX + 121 || mouseX > this.guiX + 221 || mouseY < y || mouseY >= y + LINEHEIGHT) continue;
                    this.m_96602_(matrixStack, (Component)new TextComponent(objective2.getName()), mouseX, mouseY);
                    continue;
                }
                this.objectiveScrollY = 0;
            }
            QuestLogScreen.m_93243_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)REWARD, (int)(this.guiX + 123), (int)(this.guiY + 107), (int)0xFFFFFF);
            if (xpReward > 0) {
                QuestLogScreen.m_93243_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)new TranslatableComponent("screen.quest_log.reward.xp", new Object[]{xpReward}), (int)(this.guiX + 126), (int)(this.guiY + 107 + LINEHEIGHT), (int)0xFFFFFF);
            }
            if (itemRewards.size() > 0) {
                int itemRewardY = this.guiY + 107 + LINEHEIGHT * 2;
                QuestLogScreen.m_93243_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)ITEMREWARD, (int)(this.guiX + 126), (int)itemRewardY, (int)0xFFFFFF);
                int itemRewardStringWidth = this.f_96547_.m_92852_((FormattedText)ITEMREWARD);
                int maxDisplayedRewards = Math.min((93 - itemRewardStringWidth) / 16, itemRewards.size());
                int itemRewardX = this.guiX + 123 + itemRewardStringWidth + 2;
                itemRewardY -= 4;
                for (int i2 = 0; i2 < maxDisplayedRewards; ++i2) {
                    if (itemRewards.size() > maxDisplayedRewards && i2 == maxDisplayedRewards - 1) {
                        QuestLogScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)"...", (int)itemRewardX, (int)itemRewardY, (int)0xFFFFFF);
                    } else {
                        ItemStack itemStack = itemRewards.get(i2);
                        this.f_96541_.m_91291_().m_115203_(itemStack, itemRewardX, itemRewardY);
                        this.f_96541_.m_91291_().m_115169_(this.f_96547_, itemStack, itemRewardX, itemRewardY);
                        if (mouseX >= itemRewardX && mouseX <= itemRewardX + 16 && mouseY >= itemRewardY && mouseY <= itemRewardY + 16) {
                            this.m_6057_(matrixStack, itemStack, mouseX, mouseY);
                        }
                    }
                    itemRewardX += 16;
                }
            }
            QuestLogScreen.m_93215_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)TRACK, (int)(this.trackQuestButton.f_93620_ + this.trackQuestButton.m_5711_() / 2), (int)(this.trackQuestButton.f_93621_ + 4), (int)0xFFFFFF);
            QuestLogScreen.m_93215_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)ABANDON, (int)(this.abandonQuestButton.f_93620_ + this.abandonQuestButton.m_5711_() / 2), (int)(this.abandonQuestButton.f_93621_ + 4), (int)0xFFFFFF);
        }
        for (int i = 0; i < this.questButtons.length; ++i) {
            ImageButton questButton = this.questButtons[i];
            if (!questButton.f_93624_ || this.acceptedQuests.size() <= i + this.scrollOffset) continue;
            Quest quest = this.acceptedQuests.get(i + this.scrollOffset).getQuest();
            questName = quest.getDisplayName();
            if (this.f_96547_.m_92895_((String)questName) > 85) {
                questName = this.f_96547_.m_92834_((String)questName, 85 - this.f_96547_.m_92895_("...")) + "...";
            }
            QuestLogScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)questName, (int)(questButton.f_93620_ + 15), (int)(questButton.f_93621_ + 4), (int)(questButton.m_198029_() ? 0xFFFF00 : 0xFFFFFF));
            ResourceLocation questIcon = quest.canComplete() ? ClientEvents.QUEST_COMPLETE_ICON : ClientEvents.QUEST_ICON;
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)questIcon);
            QuestLogScreen.m_93160_((PoseStack)matrixStack, (int)(questButton.f_93620_ + 2), (int)(questButton.f_93621_ + 2), (int)12, (int)12, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
        }
    }

    private boolean isMouseOnScrollBar(double mouseX, double mouseY) {
        return mouseX >= (double)(this.guiX + 113) && mouseX <= (double)(this.guiX + 117) && mouseY >= 14.0 && mouseY <= 174.0;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isMouseOnScrollBar(mouseX, mouseY)) {
            this.isScrolling = true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button != 0) {
            this.isScrolling = false;
        } else if (this.isScrolling) {
            this.updateScrollY(mouseX, mouseY, dragY);
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.isScrolling = false;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        this.updateScrollY(mouseX, mouseY, -delta * 6.0);
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private void updateScrollY(double mouseX, double mouseY, double delta) {
        if (this.currentViewingQuest != null && mouseX >= (double)(this.guiX + 120) && mouseX <= (double)(this.guiX + 222) && mouseY >= (double)(this.guiY + 14) && mouseY <= (double)(this.guiY + 174)) {
            String questName = this.currentViewingQuest.getQuest().getDisplayName();
            List trimmedQuestName = this.f_96547_.m_92923_((FormattedText)new TextComponent(questName), 100);
            int yOffset = trimmedQuestName.size() * LINEHEIGHT + LINEHEIGHT;
            List<QuestObjective> objectives = this.currentViewingQuest.getQuest().getObjectives();
            ArrayList visibleObjectives = new ArrayList();
            objectives.forEach(objective -> {
                if (!objective.isHidden()) {
                    visibleObjectives.add(objective);
                }
            });
            int maxVisibleObjectives = Math.min(6 - (yOffset / LINEHEIGHT - 1), visibleObjectives.size());
            if (maxVisibleObjectives < visibleObjectives.size()) {
                int d = delta > 0.0 ? 1 : -1;
                this.objectiveScrollY = Mth.m_14045_((int)(this.objectiveScrollY + d), (int)0, (int)(visibleObjectives.size() - maxVisibleObjectives));
            } else {
                this.objectiveScrollY = 0;
            }
        } else if (this.acceptedQuests.size() > 10) {
            this.scrollY = Mth.m_14008_((double)(this.scrollY + delta), (double)0.0, (double)153.0);
            this.scrollOffset = (int)(this.scrollY * (double)(this.acceptedQuests.size() - 10) / 153.0);
        } else {
            this.scrollY = 0.0;
            this.scrollOffset = 0;
        }
    }

    public boolean m_7043_() {
        return false;
    }

    static {
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        LINEHEIGHT = 9 + 2;
        TITLE = new TranslatableComponent("screen.quest_log.title");
        OBJECTIVES = new TranslatableComponent("screen.quest_log.objectives");
        REWARD = new TranslatableComponent("screen.quest_log.reward");
        ITEMREWARD = new TranslatableComponent("screen.quest_log.reward.items");
        TRACK = new TranslatableComponent("screen.quest_log.track");
        ABANDON = new TranslatableComponent("screen.quest_log.abandon");
    }
}

