/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.client.gui.screen.quests;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.StringReader;
import flash.npcmod.client.gui.screen.quests.QuestEditorScreen;
import flash.npcmod.client.gui.widget.EntityDropdownWidget;
import flash.npcmod.client.gui.widget.EnumDropdownWidget;
import flash.npcmod.core.quests.QuestObjective;
import flash.npcmod.core.quests.QuestObjectiveTypes;
import flash.npcmod.network.PacketDispatcher;
import flash.npcmod.network.packets.client.CRequestContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class QuestObjectiveBuilderScreen
extends Screen {
    private EnumDropdownWidget<QuestObjective.ObjectiveType> typeDropdown;
    private EntityDropdownWidget entityDropdown;
    private EditBox nameField;
    private EditBox amountField;
    private EditBox primaryObjectiveField;
    private EditBox secondaryObjectiveField;
    private EditBox entityObjectiveTagField;
    private EditBox runOnCompleteField;
    private Checkbox optionalCheckbox;
    private Checkbox hiddenCheckbox;
    private Checkbox displayProgressCheckbox;
    private Button itemFromInventoryButton;
    private Button plusRunOnCompleteButton;
    private Button[] removeRunOnCompletionButtons;
    private QuestEditorScreen questEditorScreen;
    private String originalObjectiveName = "";
    private ItemStack itemStackObjective;
    private EntityType<?> entityObjective;
    private CompoundTag entityObjectiveTag;
    private BlockState blockStateObjective;
    private QuestObjective.ObjectiveType objectiveType;
    private String name;
    private String primaryObjective;
    private String secondaryObjective;
    private String currentRunOnComplete;
    private int amount;
    private List<String> runOnComplete;
    private boolean optional;
    private boolean isHidden;
    private boolean displayProgress;
    private int scrollY;
    private static final String TYPE = "Type: ";
    private static final String OPTIONAL = "Optional? ";
    private static final String NAME = "Name: ";
    private static final String AMOUNT = "Amount: ";
    private static final String HIDDEN = "Hidden by Default? ";
    private static final String DISPLAY_PROGRESS = "Display Progress? ";
    private static final String PRIMARY = "Primary Objective: ";
    private static final String SECONDARY = "Secondary Objective: ";
    private static final String RUNONCOMPLETE = "Run on completion: ";
    private static final String CANSAVE = "Changes will be saved on exit...";
    private static final String CANNOTSAVE = "Changes will NOT be saved on exit...";
    private String tip1;
    private String tip2;
    private final Predicate<String> amountFilter = text -> {
        if (text.isEmpty()) {
            return true;
        }
        try {
            Integer.parseInt(text);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    };

    public QuestObjectiveBuilderScreen(QuestEditorScreen questEditorScreen, @Nullable QuestObjective originalObjective, String originalObjectiveName) {
        this(questEditorScreen, originalObjective);
        this.originalObjectiveName = originalObjectiveName;
    }

    public QuestObjectiveBuilderScreen(QuestEditorScreen questEditorScreen, QuestObjective questObjective) {
        super(TextComponent.f_131282_);
        this.questEditorScreen = questEditorScreen;
        this.objectiveType = QuestObjective.ObjectiveType.Gather;
        this.name = "";
        this.primaryObjective = "";
        this.secondaryObjective = "";
        this.currentRunOnComplete = "";
        this.itemStackObjective = ItemStack.f_41583_;
        this.displayProgress = true;
        this.runOnComplete = new ArrayList<String>();
        this.entityObjectiveTag = new CompoundTag();
        this.amount = 1;
        this.tip1 = "";
        this.tip2 = "";
        if (questObjective != null) {
            this.name = questObjective.getName();
            this.amount = questObjective.getAmount();
            if (questObjective.getRunOnComplete() != null) {
                this.runOnComplete = questObjective.getRunOnComplete();
            }
            this.isHidden = questObjective.isHidden();
            this.displayProgress = questObjective.shouldDisplayProgress();
            this.optional = questObjective.isOptional();
            if (questObjective.getObjective() instanceof ItemStack) {
                this.itemStackObjective = (ItemStack)questObjective.getObjective();
            } else if (questObjective.getObjective() instanceof BlockState) {
                this.blockStateObjective = (BlockState)questObjective.getObjective();
            }
            this.primaryObjective = questObjective.primaryToString();
            if (questObjective.getSecondaryObjective() instanceof ItemStack) {
                this.itemStackObjective = (ItemStack)questObjective.getSecondaryObjective();
            } else if (questObjective.getSecondaryObjective() instanceof BlockState) {
                this.blockStateObjective = (BlockState)questObjective.getSecondaryObjective();
            }
            this.secondaryObjective = questObjective.secondaryToString();
            if (this.isEntityObjective(questObjective)) {
                switch (questObjective.getType()) {
                    case Kill: {
                        QuestObjectiveTypes.KillObjective killObjective = (QuestObjectiveTypes.KillObjective)questObjective;
                        try {
                            this.entityObjective = (EntityType)EntityType.m_20632_((String)killObjective.getEntityKey()).get();
                        }
                        catch (Exception e) {
                            this.entityObjective = EntityType.f_20510_;
                        }
                        this.entityObjectiveTag = killObjective.getEntityTag();
                        break;
                    }
                    case UseOnEntity: {
                        QuestObjectiveTypes.UseOnEntityObjective useOnEntityObjective = (QuestObjectiveTypes.UseOnEntityObjective)questObjective;
                        try {
                            this.entityObjective = (EntityType)EntityType.m_20632_((String)useOnEntityObjective.getEntityKey()).get();
                        }
                        catch (Exception e) {
                            this.entityObjective = EntityType.f_20510_;
                        }
                        this.entityObjectiveTag = useOnEntityObjective.getEntityTag();
                        break;
                    }
                    case DeliverToEntity: {
                        QuestObjectiveTypes.DeliverToEntityObjective deliverToEntityObjective = (QuestObjectiveTypes.DeliverToEntityObjective)questObjective;
                        try {
                            this.entityObjective = (EntityType)EntityType.m_20632_((String)deliverToEntityObjective.getEntityKey()).get();
                        }
                        catch (Exception e) {
                            this.entityObjective = EntityType.f_20510_;
                        }
                        this.entityObjectiveTag = deliverToEntityObjective.getEntityTag();
                    }
                }
            }
            this.objectiveType = questObjective.getType();
        }
    }

    private boolean isEntityObjective(QuestObjective objective) {
        return switch (objective.getType()) {
            case QuestObjective.ObjectiveType.Kill, QuestObjective.ObjectiveType.UseOnEntity, QuestObjective.ObjectiveType.DeliverToEntity -> true;
            default -> false;
        };
    }

    protected void m_7856_() {
        this.optionalCheckbox = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(5 + this.f_96547_.m_92895_(TYPE) + 120 + this.f_96547_.m_92895_(OPTIONAL), 0, 20, 20, TextComponent.f_131282_, this.optional));
        this.nameField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, 5 + this.f_96547_.m_92895_(NAME), 19, 100, 20, TextComponent.f_131282_));
        this.nameField.m_94144_(this.name);
        this.nameField.m_94151_(this::setName);
        this.nameField.m_94199_(250);
        this.nameField.m_94190_(true);
        this.amountField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, 5 + this.f_96547_.m_92895_(NAME) + 105 + this.f_96547_.m_92895_(AMOUNT), 19, 100, 20, TextComponent.f_131282_));
        this.amountField.m_94144_(String.valueOf(this.amount));
        this.amountField.m_94153_(this.amountFilter);
        this.amountField.m_94151_(this::setAmount);
        this.amountField.m_94199_(3);
        this.amountField.m_94190_(true);
        this.hiddenCheckbox = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(5 + this.f_96547_.m_92895_(HIDDEN), 46, 20, 20, TextComponent.f_131282_, this.isHidden));
        this.displayProgressCheckbox = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(5 + this.f_96547_.m_92895_(HIDDEN) + 25 + this.f_96547_.m_92895_(DISPLAY_PROGRESS), 46, 20, 20, TextComponent.f_131282_, this.displayProgress));
        this.primaryObjectiveField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, 5 + this.f_96547_.m_92895_(PRIMARY), 76, 100, 20, TextComponent.f_131282_));
        this.primaryObjectiveField.m_94151_(this::setPrimaryObjective);
        this.primaryObjectiveField.m_94144_(this.primaryObjective);
        this.primaryObjectiveField.m_94199_(600);
        this.primaryObjectiveField.m_94190_(true);
        this.secondaryObjectiveField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, 5 + this.f_96547_.m_92895_(SECONDARY), 106, 100, 20, TextComponent.f_131282_));
        this.secondaryObjectiveField.m_94151_(this::setSecondaryObjective);
        this.secondaryObjectiveField.m_94144_(this.secondaryObjective);
        this.secondaryObjectiveField.m_94199_(600);
        this.secondaryObjectiveField.m_94190_(true);
        this.entityObjectiveTagField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, 5 + this.f_96547_.m_92895_(PRIMARY) + 200, 76, 100, 20, TextComponent.f_131282_));
        this.entityObjectiveTagField.m_94151_(this::setEntityObjectiveTag);
        if (this.entityObjectiveTag.m_128441_("id")) {
            this.entityObjectiveTag.m_128473_("id");
        }
        this.entityObjectiveTagField.m_94144_(this.entityObjectiveTag.m_7916_());
        this.secondaryObjectiveField.m_94199_(1000);
        this.secondaryObjectiveField.m_94190_(true);
        this.itemFromInventoryButton = (Button)this.m_142416_((GuiEventListener)new Button(5 + this.f_96547_.m_92895_(PRIMARY), 76, 100, 20, (Component)new TextComponent("From Inventory"), btn -> {
            String jsons = this.create().toJson().toString() + "::::::::::" + this.questEditorScreen.build().toJson().toString() + (String)(this.originalObjectiveName == null ? "" : "::::::::::" + this.originalObjectiveName);
            PacketDispatcher.sendToServer(new CRequestContainer(jsons, CRequestContainer.ContainerType.OBJECTIVE_STACK_SELECTOR));
        }));
        this.runOnCompleteField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, 5 + this.f_96547_.m_92895_(RUNONCOMPLETE), 136, 100, 20, TextComponent.f_131282_));
        this.runOnCompleteField.m_94144_(this.currentRunOnComplete);
        this.runOnCompleteField.m_94151_(this::setRunOnComplete);
        this.runOnCompleteField.m_94199_(500);
        this.runOnCompleteField.m_94190_(true);
        this.plusRunOnCompleteButton = (Button)this.m_142416_((GuiEventListener)new Button(5 + this.f_96547_.m_92895_(RUNONCOMPLETE) + 105, 136, 20, 20, (Component)new TextComponent("+"), btn -> {
            if (this.canAddRunOnComplete()) {
                this.runOnComplete.add(this.currentRunOnComplete);
                this.runOnCompleteField.m_94144_("");
            }
        }));
        EntityType<?> entity = this.entityObjective != null ? this.entityObjective : EntityType.f_20510_;
        this.entityDropdown = (EntityDropdownWidget)this.m_142416_((GuiEventListener)new EntityDropdownWidget(entity, 5 + this.f_96547_.m_92895_(PRIMARY), 80, 200, 10, false));
        this.typeDropdown = (EnumDropdownWidget)this.m_142416_((GuiEventListener)new EnumDropdownWidget<QuestObjective.ObjectiveType>(this.objectiveType, 5 + this.f_96547_.m_92895_(TYPE), 3, 100));
        this.removeRunOnCompletionButtons = new Button[6];
        for (int i = 0; i < this.removeRunOnCompletionButtons.length; ++i) {
            int j = i;
            this.removeRunOnCompletionButtons[i] = (Button)this.m_142416_((GuiEventListener)new Button(5, 161 + i * 12, 10, 10, (Component)new TextComponent("-"), btn -> this.removeRunOnComplete(j)));
        }
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ - 100, 0, 100, 20, (Component)new TextComponent("Cancel"), btn -> this.f_96541_.m_91152_((Screen)this.questEditorScreen)));
    }

    private void removeRunOnComplete(int i) {
        if (i + this.scrollY < this.runOnComplete.size()) {
            this.runOnComplete.remove(i + this.scrollY);
            this.scrollY = this.clampScroll(this.scrollY - 1);
        }
    }

    private boolean canAddRunOnComplete() {
        return this.currentRunOnComplete.startsWith("/") || this.currentRunOnComplete.startsWith("hide:") || this.currentRunOnComplete.startsWith("unhide:") || this.currentRunOnComplete.startsWith("forceComplete");
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAmount(String amount) {
        try {
            this.amount = Integer.parseInt(amount);
        }
        catch (NumberFormatException ignored) {
            this.amount = 0;
        }
    }

    public void setPrimaryObjective(String primaryObjective) {
        this.primaryObjective = primaryObjective;
    }

    public void setSecondaryObjective(String secondaryObjective) {
        this.secondaryObjective = secondaryObjective;
    }

    public void setEntityObjectiveTag(String s) {
        if (s.isEmpty()) {
            this.entityObjectiveTag = new CompoundTag();
        } else {
            try {
                this.entityObjectiveTag = new TagParser(new StringReader(s)).m_129373_();
            }
            catch (Exception ignored) {
                this.entityObjectiveTag = new CompoundTag();
            }
        }
    }

    private String getActualEntityObjective() {
        String actualEntityObjective = EntityType.m_20613_(this.entityObjective) + "::" + this.entityObjectiveTag.m_7916_();
        return actualEntityObjective;
    }

    public void setRunOnComplete(String runOnComplete) {
        this.currentRunOnComplete = runOnComplete;
    }

    public void m_96624_() {
        this.nameField.m_94120_();
        this.amountField.m_94120_();
        this.primaryObjectiveField.m_94120_();
        this.secondaryObjectiveField.m_94120_();
        this.entityObjectiveTagField.m_94120_();
        this.runOnCompleteField.m_94120_();
        for (int i = 0; i < this.removeRunOnCompletionButtons.length; ++i) {
            this.removeRunOnCompletionButtons[i].f_93624_ = this.runOnComplete.size() > i + this.scrollY;
        }
        this.objectiveType = this.typeDropdown.getSelectedOption();
        this.primaryObjectiveField.f_93624_ = !this.typeDropdown.isShowingOptions() && (this.typeDropdown.getSelectedOption().equals((Object)QuestObjective.ObjectiveType.Talk) || this.typeDropdown.getSelectedOption().equals((Object)QuestObjective.ObjectiveType.Find) || this.typeDropdown.getSelectedOption().equals((Object)QuestObjective.ObjectiveType.Scoreboard));
        boolean bl = this.secondaryObjectiveField.f_93624_ = !this.typeDropdown.isShowingOptions() && !this.entityDropdown.isShowingOptions() && (this.typeDropdown.getSelectedOption().equals((Object)QuestObjective.ObjectiveType.DeliverToLocation) || this.typeDropdown.getSelectedOption().equals((Object)QuestObjective.ObjectiveType.Talk) || this.typeDropdown.getSelectedOption().equals((Object)QuestObjective.ObjectiveType.Scoreboard) || this.typeDropdown.getSelectedOption().equals((Object)QuestObjective.ObjectiveType.UseOnBlock));
        if (this.typeDropdown.getSelectedOption().equals((Object)QuestObjective.ObjectiveType.Talk)) {
            this.tip1 = "NPC Name";
            this.tip2 = "Dialouge Name";
        } else if (this.typeDropdown.getSelectedOption().equals((Object)QuestObjective.ObjectiveType.Scoreboard)) {
            this.tip1 = "Objective Name";
            this.tip2 = "min|max|exact";
        } else if (this.typeDropdown.getSelectedOption().equals((Object)QuestObjective.ObjectiveType.Find)) {
            this.tip1 = "x1;y1;z1,x2;y2;z2";
            this.tip2 = "";
        } else if (this.typeDropdown.getSelectedOption().equals((Object)QuestObjective.ObjectiveType.DeliverToLocation)) {
            this.tip1 = "";
            this.tip2 = "x1;y1;z1,x2;y2;z2";
        } else if (this.typeDropdown.getSelectedOption().equals((Object)QuestObjective.ObjectiveType.UseOnBlock)) {
            this.tip1 = "";
            this.tip2 = "Blockstate";
        } else {
            this.tip1 = "";
            this.tip2 = "";
        }
        if (this.typeDropdown.getSelectedOption().equals((Object)QuestObjective.ObjectiveType.UseOnBlock)) {
            this.blockStateObjective = QuestObjectiveTypes.blockStateFromString(this.secondaryObjective);
        }
        boolean isPrimaryEntityObjective = this.typeDropdown.getSelectedOption().equals((Object)QuestObjective.ObjectiveType.Kill);
        boolean isSecondaryEntityObjective = this.typeDropdown.getSelectedOption().equals((Object)QuestObjective.ObjectiveType.DeliverToEntity) || this.typeDropdown.getSelectedOption().equals((Object)QuestObjective.ObjectiveType.UseOnEntity);
        this.entityDropdown.f_93623_ = !this.typeDropdown.isShowingOptions();
        this.entityDropdown.f_93624_ = isPrimaryEntityObjective || isSecondaryEntityObjective;
        boolean bl2 = this.entityObjectiveTagField.f_93624_ = isPrimaryEntityObjective || isSecondaryEntityObjective;
        if (isPrimaryEntityObjective) {
            this.entityDropdown.f_93620_ = 5 + this.f_96547_.m_92895_(PRIMARY);
            this.entityDropdown.f_93621_ = 80;
            this.entityObjective = this.entityDropdown.getSelectedType();
            this.entityObjectiveTagField.f_93620_ = this.entityDropdown.f_93620_ + 210;
            this.entityObjectiveTagField.f_93621_ = this.entityDropdown.f_93621_ - 4;
        } else if (isSecondaryEntityObjective) {
            this.entityDropdown.f_93620_ = 5 + this.f_96547_.m_92895_(SECONDARY);
            this.entityDropdown.f_93621_ = 110;
            this.entityObjective = this.entityDropdown.getSelectedType();
            this.entityObjectiveTagField.f_93620_ = this.entityDropdown.f_93620_ + 210;
            this.entityObjectiveTagField.f_93621_ = this.entityDropdown.f_93621_ - 4;
        }
        this.itemFromInventoryButton.f_93624_ = this.typeDropdown.getSelectedOption().equals((Object)QuestObjective.ObjectiveType.Gather) || this.typeDropdown.getSelectedOption().equals((Object)QuestObjective.ObjectiveType.DeliverToEntity) || this.typeDropdown.getSelectedOption().equals((Object)QuestObjective.ObjectiveType.DeliverToLocation) || this.typeDropdown.getSelectedOption().equals((Object)QuestObjective.ObjectiveType.UseOnEntity) || this.typeDropdown.getSelectedOption().equals((Object)QuestObjective.ObjectiveType.UseOnBlock) || this.typeDropdown.getSelectedOption().equals((Object)QuestObjective.ObjectiveType.Use) || this.typeDropdown.getSelectedOption().equals((Object)QuestObjective.ObjectiveType.CraftItem) || this.typeDropdown.getSelectedOption().equals((Object)QuestObjective.ObjectiveType.SmeltItem);
        this.itemFromInventoryButton.f_93623_ = !this.typeDropdown.isShowingOptions();
        boolean isNotEscortObjective = !this.objectiveType.equals((Object)QuestObjective.ObjectiveType.Escort);
        this.nameField.f_93624_ = isNotEscortObjective && !this.typeDropdown.isShowingOptions();
        this.amountField.f_93624_ = isNotEscortObjective;
        this.runOnCompleteField.f_93624_ = isNotEscortObjective && !this.typeDropdown.isShowingOptions() && !this.entityDropdown.isShowingOptions();
        this.plusRunOnCompleteButton.f_93624_ = isNotEscortObjective;
        this.plusRunOnCompleteButton.f_93623_ = this.canAddRunOnComplete() && !this.typeDropdown.isShowingOptions() && !this.entityDropdown.isShowingOptions();
        this.optionalCheckbox.f_93624_ = isNotEscortObjective;
        this.hiddenCheckbox.f_93624_ = isNotEscortObjective;
        this.displayProgressCheckbox.f_93624_ = isNotEscortObjective;
        this.optional = this.optionalCheckbox.m_93840_();
        this.isHidden = this.hiddenCheckbox.m_93840_();
        this.displayProgress = this.displayProgressCheckbox.m_93840_();
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        QuestObjectiveBuilderScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)TYPE, (int)5, (int)5, (int)0xFFFFFF);
        QuestObjectiveBuilderScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)OPTIONAL, (int)(5 + this.f_96547_.m_92895_(TYPE) + 120), (int)5, (int)0xFFFFFF);
        QuestObjectiveBuilderScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)NAME, (int)5, (int)25, (int)0xFFFFFF);
        QuestObjectiveBuilderScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)AMOUNT, (int)(5 + this.f_96547_.m_92895_(NAME) + 105), (int)25, (int)0xFFFFFF);
        QuestObjectiveBuilderScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)HIDDEN, (int)5, (int)52, (int)0xFFFFFF);
        QuestObjectiveBuilderScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)DISPLAY_PROGRESS, (int)(5 + this.f_96547_.m_92895_(HIDDEN) + 25), (int)52, (int)0xFFFFFF);
        QuestObjectiveBuilderScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)PRIMARY, (int)5, (int)82, (int)0xFFFFFF);
        QuestObjectiveBuilderScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)SECONDARY, (int)5, (int)112, (int)0xFFFFFF);
        if (!this.tip1.isEmpty()) {
            QuestObjectiveBuilderScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)this.tip1, (int)(5 + this.f_96547_.m_92895_(PRIMARY) + 105), (int)82, (int)0xFFFFFF);
        }
        if (!this.tip2.isEmpty()) {
            QuestObjectiveBuilderScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)this.tip2, (int)(5 + this.f_96547_.m_92895_(SECONDARY) + 105), (int)112, (int)0xFFFFFF);
        }
        if (this.itemStackObjective != null && !this.itemStackObjective.m_41619_() && this.itemFromInventoryButton.f_93624_) {
            int x = 5 + this.f_96547_.m_92895_(PRIMARY) + 105;
            int y = 78;
            this.f_96541_.m_91291_().m_115218_(this.itemStackObjective, x, y);
            if (mouseX >= x && mouseX <= x + 16 && mouseY >= y && mouseY <= y + 16) {
                this.m_6057_(matrixStack, this.itemStackObjective, mouseX, mouseY);
            }
        }
        QuestObjectiveBuilderScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)RUNONCOMPLETE, (int)5, (int)142, (int)0xFFFFFF);
        for (int i = 0; i < Math.min(6, this.runOnComplete.size()); ++i) {
            if (i + this.scrollY >= this.runOnComplete.size()) continue;
            QuestObjectiveBuilderScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)this.runOnComplete.get(i + this.scrollY), (int)20, (int)(162 + i * 12), (int)0xFFFFFF);
        }
        boolean canSave = !this.name.isEmpty() && this.canCreateObjective();
        String save = canSave ? CANSAVE : CANNOTSAVE;
        int color = canSave ? 65280 : 0xFF0000;
        int n = this.f_96543_ - 2 - this.f_96547_.m_92895_(save);
        Objects.requireNonNull(this.f_96547_);
        QuestObjectiveBuilderScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)save, (int)n, (int)(this.f_96544_ - 9 - 2), (int)color);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }

    private boolean canCreateObjective() {
        return switch (this.typeDropdown.getSelectedOption()) {
            default -> throw new IncompatibleClassChangeError();
            case QuestObjective.ObjectiveType.Gather, QuestObjective.ObjectiveType.Use, QuestObjective.ObjectiveType.CraftItem, QuestObjective.ObjectiveType.SmeltItem -> {
                if (this.itemStackObjective != null && !this.itemStackObjective.m_41619_() && this.amount > 0) {
                    yield true;
                }
                yield false;
            }
            case QuestObjective.ObjectiveType.Kill -> {
                if (this.entityObjective != null && this.amount > 0) {
                    yield true;
                }
                yield false;
            }
            case QuestObjective.ObjectiveType.UseOnEntity, QuestObjective.ObjectiveType.DeliverToEntity -> {
                if (this.itemStackObjective != null && !this.itemStackObjective.m_41619_() && this.entityObjective != null && this.amount > 0) {
                    yield true;
                }
                yield false;
            }
            case QuestObjective.ObjectiveType.DeliverToLocation -> {
                if (this.itemStackObjective != null && !this.itemStackObjective.m_41619_() && this.canConvertToArea(this.secondaryObjective) && this.amount > 0) {
                    yield true;
                }
                yield false;
            }
            case QuestObjective.ObjectiveType.Escort -> false;
            case QuestObjective.ObjectiveType.Talk -> {
                if (!this.primaryObjective.isEmpty() && !this.secondaryObjective.isEmpty()) {
                    yield true;
                }
                yield false;
            }
            case QuestObjective.ObjectiveType.Find -> this.canConvertToArea(this.primaryObjective);
            case QuestObjective.ObjectiveType.UseOnBlock -> {
                if (this.itemStackObjective != null && !this.itemStackObjective.m_41619_() && this.blockStateObjective != null && !this.blockStateObjective.m_60734_().equals(Blocks.f_50016_) && this.amount > 0) {
                    yield true;
                }
                yield false;
            }
            case QuestObjective.ObjectiveType.Scoreboard -> !this.primaryObjective.isEmpty();
        };
    }

    @Nullable
    private QuestObjective create() {
        QuestObjective questObjective = null;
        int id = this.questEditorScreen.objectives.size();
        if (this.originalObjectiveName != null && !this.originalObjectiveName.isEmpty()) {
            for (QuestObjective objective : this.questEditorScreen.objectives) {
                if (!objective.getName().equals(this.originalObjectiveName)) continue;
                id = objective.getId();
                break;
            }
        }
        switch (this.typeDropdown.getSelectedOption()) {
            case Gather: {
                questObjective = new QuestObjectiveTypes.GatherObjective(id, this.name, this.itemStackObjective, this.amount);
                break;
            }
            case Kill: {
                questObjective = new QuestObjectiveTypes.KillObjective(id, this.name, this.getActualEntityObjective(), this.amount);
                break;
            }
            case DeliverToEntity: {
                questObjective = new QuestObjectiveTypes.DeliverToEntityObjective(id, this.name, this.itemStackObjective, this.getActualEntityObjective(), this.amount);
                break;
            }
            case DeliverToLocation: {
                questObjective = new QuestObjectiveTypes.DeliverToLocationObjective(id, this.name, this.itemStackObjective, QuestObjectiveTypes.areaFromString(this.secondaryObjective), this.amount);
                break;
            }
            case Escort: {
                break;
            }
            case Talk: {
                questObjective = new QuestObjectiveTypes.TalkObjective(id, this.name, this.primaryObjective, this.secondaryObjective);
                break;
            }
            case Find: {
                questObjective = new QuestObjectiveTypes.FindObjective(id, this.name, QuestObjectiveTypes.areaFromString(this.primaryObjective));
                break;
            }
            case UseOnEntity: {
                questObjective = new QuestObjectiveTypes.UseOnEntityObjective(id, this.name, this.itemStackObjective, this.getActualEntityObjective(), this.amount);
                break;
            }
            case UseOnBlock: {
                questObjective = new QuestObjectiveTypes.UseOnBlockObjective(id, this.name, this.itemStackObjective, this.blockStateObjective, this.amount);
                break;
            }
            case Use: {
                questObjective = new QuestObjectiveTypes.UseObjective(id, this.name, this.itemStackObjective, this.amount);
                break;
            }
            case Scoreboard: {
                questObjective = new QuestObjectiveTypes.ScoreboardObjective(id, this.name, this.primaryObjective, this.amount);
                break;
            }
            case CraftItem: {
                questObjective = new QuestObjectiveTypes.CraftItemObjective(id, this.name, this.itemStackObjective, this.amount);
                break;
            }
            case SmeltItem: {
                questObjective = new QuestObjectiveTypes.SmeltItemObjective(id, this.name, this.itemStackObjective, this.amount);
            }
        }
        if (questObjective != null) {
            questObjective.setRunOnComplete(this.runOnComplete);
            questObjective.setOptional(this.optional);
            questObjective.setHidden(this.isHidden);
            questObjective.setShouldDisplayProgress(this.displayProgress);
        }
        return questObjective;
    }

    public void m_7379_() {
        QuestObjective questObjective;
        if (!this.name.isEmpty() && this.canCreateObjective() && (questObjective = this.create()) != null) {
            int j = -1;
            if (this.originalObjectiveName != null && !this.originalObjectiveName.isEmpty()) {
                for (int i = 0; i < this.questEditorScreen.objectives.size(); ++i) {
                    QuestObjective objective = this.questEditorScreen.objectives.get(i);
                    if (!objective.getName().equals(this.originalObjectiveName)) continue;
                    j = i;
                    break;
                }
                if (j >= 0 && j < this.questEditorScreen.objectives.size()) {
                    this.questEditorScreen.objectives.set(j, questObjective);
                }
            } else {
                for (int i = 0; i < this.questEditorScreen.objectives.size(); ++i) {
                    QuestObjective objective = this.questEditorScreen.objectives.get(i);
                    if (!objective.getName().equals(this.originalObjectiveName)) continue;
                    j = i;
                    break;
                }
                if (j >= 0 && j < this.questEditorScreen.objectives.size()) {
                    this.questEditorScreen.objectives.set(j, questObjective);
                } else {
                    this.questEditorScreen.objectives.add(questObjective);
                }
            }
        }
        this.f_96541_.m_91152_((Screen)this.questEditorScreen);
    }

    private boolean canConvertToArea(String s) {
        if (s.isEmpty() || !s.contains(",") || !s.contains(";")) {
            return false;
        }
        String[] split = s.split(",");
        if (split.length != 2 || !split[0].contains(";") || !split[1].contains(";")) {
            return false;
        }
        String[] firstSplit = split[0].split(";");
        String[] secondSplit = split[1].split(";");
        if (firstSplit.length != 3 || secondSplit.length != 3) {
            return false;
        }
        for (String coord : firstSplit) {
            try {
                Integer.parseInt(coord);
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        for (String coord : secondSplit) {
            try {
                Integer.parseInt(coord);
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        return true;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        this.scrollY = delta > 0.0 ? this.clampScroll(this.scrollY - 1) : this.clampScroll(this.scrollY + 1);
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public int clampScroll(int newScroll) {
        int max = this.runOnComplete.size() - 6;
        if (max > 0) {
            return Mth.m_14045_((int)newScroll, (int)0, (int)max);
        }
        return 0;
    }
}

