/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.client.gui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import flash.npcmod.client.gui.screen.NpcBuilderScreen;
import flash.npcmod.core.ColorUtil;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ColorSliderWidget
extends AbstractWidget {
    private Color color;
    private NpcBuilderScreen screen;
    private double colorY;

    public void m_142291_(NarrationElementOutput p_169152_) {
    }

    public ColorSliderWidget(NpcBuilderScreen screen, int x, int y, int width, int height, Color color) {
        super(x, y, width, height, TextComponent.f_131282_);
        this.color = color;
        this.screen = screen;
        this.updateColorY();
    }

    public void updateColorY() {
        this.colorY = (double)this.color.getColor(this.screen) / 255.0;
    }

    public void m_6303_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        ColorSliderWidget.m_93172_((PoseStack)matrixStack, (int)(this.f_93620_ - 1), (int)(this.f_93621_ - 1), (int)(this.f_93620_ + this.f_93618_ + 1), (int)(this.f_93621_ + this.f_93619_ + 1), (int)-16777216);
        int mask = this.color.getMask(this.screen);
        this.m_93179_(matrixStack, this.f_93620_, this.f_93621_, this.f_93620_ + this.f_93618_, this.f_93621_ + this.f_93619_, this.color.getColorHex() | mask, 0xFF000000 | mask);
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, (double)this.f_93619_ - this.colorY * (double)this.f_93619_, 0.0);
        this.m_93154_(matrixStack, this.f_93620_, this.f_93620_ + this.f_93618_, this.f_93621_, -16777216);
        matrixStack.m_85849_();
    }

    public void m_5716_(double mouseX, double mouseY) {
        this.getColorAtMouse(mouseY);
    }

    protected void m_7212_(double mouseX, double mouseY, double dragX, double dragY) {
        this.getColorAtMouse(mouseY);
    }

    private void getColorAtMouse(double mouseY) {
        if (mouseY < (double)this.f_93621_) {
            mouseY = this.f_93621_;
        } else if (mouseY > (double)(this.f_93621_ + this.f_93619_)) {
            mouseY = this.f_93621_ + this.f_93619_;
        }
        this.colorY = (mouseY - (double)this.f_93621_) / (double)this.f_93619_;
        int color = 255 - (int)(this.colorY * 255.0);
        this.color.setColor(this.screen, color);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Color {
        RED(-65536){

            @Override
            public int getMask(NpcBuilderScreen screen) {
                return ColorUtil.rgbToHex(0, screen.getG(), screen.getB());
            }

            @Override
            public void setColor(NpcBuilderScreen screen, int color) {
                screen.setR(color);
                screen.redField.m_94144_(String.valueOf(color));
            }

            @Override
            public int getColor(NpcBuilderScreen screen) {
                return screen.getR();
            }
        }
        ,
        GREEN(-16711936){

            @Override
            public int getMask(NpcBuilderScreen screen) {
                return ColorUtil.rgbToHex(screen.getR(), 0, screen.getB());
            }

            @Override
            public void setColor(NpcBuilderScreen screen, int color) {
                screen.setG(color);
                screen.greenField.m_94144_(String.valueOf(color));
            }

            @Override
            public int getColor(NpcBuilderScreen screen) {
                return screen.getG();
            }
        }
        ,
        BLUE(-16776961){

            @Override
            public int getMask(NpcBuilderScreen screen) {
                return ColorUtil.rgbToHex(screen.getR(), screen.getG(), 0);
            }

            @Override
            public void setColor(NpcBuilderScreen screen, int color) {
                screen.setB(color);
                screen.blueField.m_94144_(String.valueOf(color));
            }

            @Override
            public int getColor(NpcBuilderScreen screen) {
                return screen.getB();
            }
        };

        private int colorHex;

        private Color(int colorHex) {
            this.colorHex = colorHex;
        }

        public int getColorHex() {
            return this.colorHex;
        }

        public int getMask(NpcBuilderScreen screen) {
            return -16777216;
        }

        public void setColor(NpcBuilderScreen screen, int color) {
        }

        public int getColor(NpcBuilderScreen screen) {
            return 0;
        }
    }
}

