/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import flash.npcmod.client.gui.screen.dialogue.DialogueScreen;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DialogueDisplayWidget
extends AbstractWidget {
    private DialogueScreen screen;
    private int scrollY;

    public DialogueDisplayWidget(DialogueScreen screen, int x, int y, int width, int height) {
        super(x, y, width, height, TextComponent.f_131282_);
        this.screen = screen;
        this.scrollY = 0;
    }

    public void m_6303_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        matrixStack.m_85836_();
        Minecraft minecraft = Minecraft.m_91087_();
        Font fontrenderer = minecraft.f_91062_;
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69482_();
        int prevHeight = 0;
        for (int i = this.screen.displayedText.size() - 1 - this.scrollY; i >= 0; --i) {
            String[] lines = this.screen.displayedText.get(i);
            int textColor = lines[lines.length - 1].startsWith(this.screen.playerName) ? 0xFFFFFF : this.screen.getNpcTextColor();
            Objects.requireNonNull(fontrenderer);
            int lineHeight = 9 + 1;
            for (String line : lines) {
                if (line.isEmpty()) {
                    prevHeight += lineHeight;
                    continue;
                }
                List trimmedText = fontrenderer.m_92923_((FormattedText)new TextComponent(line), this.f_93618_);
                this.drawMultilineText(matrixStack, trimmedText, fontrenderer, this.f_93620_, this.f_93621_ + this.f_93619_ - prevHeight - lineHeight * trimmedText.size(), textColor);
                prevHeight += lineHeight * trimmedText.size();
            }
            prevHeight += lineHeight;
        }
        matrixStack.m_85849_();
    }

    private void drawMultilineText(PoseStack matrixStack, List<FormattedCharSequence> trimmedText, Font font, int x, int y, int color) {
        for (int i = 0; i < trimmedText.size(); ++i) {
            Objects.requireNonNull(font);
            int y2 = y + (9 + 1) * i;
            if (y2 < this.f_93621_) continue;
            FormattedCharSequence processor = trimmedText.get(i);
            font.m_92877_(matrixStack, processor, (float)x, (float)y2, color);
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        this.scrollY = delta > 0.0 ? this.clampScroll(this.scrollY + 1) : this.clampScroll(this.scrollY - 1);
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public int clampScroll(int newScroll) {
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        Objects.requireNonNull(fontRenderer);
        int lineHeight = 9 + 1;
        int numOfLines = 0;
        for (int i = 0; i < this.screen.displayedText.size(); ++i) {
            String[] lines;
            for (String line : lines = this.screen.displayedText.get(i)) {
                List trimmedText = fontRenderer.m_92923_((FormattedText)new TextComponent(line), this.f_93618_);
                numOfLines += trimmedText.size();
            }
            ++numOfLines;
        }
        int maxLinesInHeight = this.f_93619_ / lineHeight;
        int max = numOfLines - maxLinesInHeight;
        if (max > 0) {
            return Mth.m_14045_((int)newScroll, (int)0, (int)(max / 2));
        }
        return this.scrollY;
    }

    public void m_142291_(NarrationElementOutput p_169152_) {
    }
}

