/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.client.gui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import flash.npcmod.client.gui.widget.SpacerWidget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import org.jetbrains.annotations.NotNull;

public class DirectionalFrame
extends AbstractWidget {
    public static final int MINIMUM_PADDING = 5;
    private final Alignment alignment;
    private final Direction direction;
    private final DirectionalWidget directionalWidget;
    private int numSpacers = 0;
    private final List<Integer> padding;
    private boolean sizeChanged;
    private final List<AbstractWidget> widgets = new ArrayList<AbstractWidget>();

    public DirectionalFrame(int x, int y, int width, int height, Direction direction, Alignment alignment) {
        super(x, y, width, height, (Component)new TextComponent(""));
        this.padding = new ArrayList<Integer>();
        this.direction = direction;
        this.sizeChanged = false;
        this.alignment = alignment;
        this.directionalWidget = direction == Direction.HORIZONTAL ? new DirectionalWidget(){

            @Override
            public int getSizeAlongAxis(AbstractWidget widget) {
                return widget.m_5711_();
            }

            @Override
            public void setSecondaryAxisPos(AbstractWidget widget) {
                widget.f_93621_ = DirectionalFrame.this.f_93621_;
            }

            @Override
            public void setMainAxisPos(AbstractWidget widget, int pos) {
                widget.f_93620_ = pos;
            }

            @Override
            public void setSizeAlongAxis(AbstractWidget widget, int size) {
                widget.m_93674_(size);
            }
        } : new DirectionalWidget(){

            @Override
            public int getSizeAlongAxis(AbstractWidget widget) {
                return widget.m_93694_();
            }

            @Override
            public void setSecondaryAxisPos(AbstractWidget widget) {
                widget.f_93620_ = DirectionalFrame.this.f_93620_;
            }

            @Override
            public void setMainAxisPos(AbstractWidget widget, int pos) {
                widget.f_93621_ = pos;
            }

            @Override
            public void setSizeAlongAxis(AbstractWidget widget, int size) {
                widget.setHeight(size);
            }
        };
    }

    public void addSpacer() {
        this.widgets.add(new SpacerWidget(0, this.f_93621_));
        this.padding.add(0);
        ++this.numSpacers;
        this.sizeChanged = true;
    }

    public void addWidget(AbstractWidget widget) {
        this.directionalWidget.setSecondaryAxisPos(widget);
        this.widgets.add(widget);
        this.padding.add(5);
        this.sizeChanged = true;
    }

    public void addWidget(AbstractWidget widget, int padding) {
        this.directionalWidget.setSecondaryAxisPos(widget);
        this.widgets.add(widget);
        this.padding.add(padding);
        this.sizeChanged = true;
    }

    public boolean m_5534_(char key, int p_94733_) {
        if (this.f_93623_ && this.isAnyVisible()) {
            for (AbstractWidget widget : this.widgets) {
                if (!widget.f_93624_ || !widget.m_5534_(key, p_94733_)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean m_5755_(boolean p_94756_) {
        if (this.f_93623_ && this.isAnyVisible()) {
            for (AbstractWidget widget : this.widgets) {
                if (!widget.f_93624_ || !widget.m_5755_(p_94756_)) continue;
                return true;
            }
        }
        return false;
    }

    public static DirectionalFrame createHorizontalFrame(int frameWidth, Alignment alignment) {
        return new DirectionalFrame(0, 0, frameWidth, 0, Direction.HORIZONTAL, alignment);
    }

    public static DirectionalFrame createVerticalFrame(int frameHeight, Alignment alignment) {
        return new DirectionalFrame(0, 0, 0, frameHeight, Direction.VERTICAL, alignment);
    }

    public int m_93694_() {
        int height = 0;
        if (this.direction == Direction.HORIZONTAL) {
            for (AbstractWidget widget : this.widgets) {
                height = Math.max(widget.m_93694_(), height);
            }
        } else {
            height = this.getMinimumSize();
        }
        return height;
    }

    public int getMinimumSize() {
        int size = 0;
        for (int i = 0; i < this.widgets.size(); ++i) {
            AbstractWidget widget = this.widgets.get(i);
            if (!widget.f_93624_ || widget instanceof DirectionalFrame && !((DirectionalFrame)widget).isAnyVisible() || widget instanceof SpacerWidget) continue;
            size += this.directionalWidget.getSizeAlongAxis(this.widgets.get(i)) + 2 * this.padding.get(i);
        }
        return size;
    }

    public int m_5711_() {
        int width = 0;
        if (this.direction == Direction.VERTICAL) {
            for (AbstractWidget widget : this.widgets) {
                width = Math.max(widget.m_5711_(), width);
            }
        } else {
            width = this.getMinimumSize();
        }
        return width;
    }

    public void insertWidget(AbstractWidget widget, int index, int padding) {
        this.directionalWidget.setSecondaryAxisPos(widget);
        this.widgets.add(index, widget);
        this.padding.add(index, padding);
        this.sizeChanged = true;
    }

    public boolean isAnyVisible() {
        if (!this.f_93624_) {
            return false;
        }
        for (AbstractWidget widget : this.widgets) {
            if (!widget.f_93624_ || widget instanceof SpacerWidget) continue;
            return true;
        }
        return false;
    }

    public void recalculateSize() {
        int emptySpaceSize;
        int nextSpot;
        this.sizeChanged = false;
        int minimumSize = this.getMinimumSize();
        if (this.direction == Direction.HORIZONTAL) {
            nextSpot = this.f_93620_;
            emptySpaceSize = minimumSize > this.f_93618_ ? minimumSize : this.f_93618_ - minimumSize;
        } else {
            nextSpot = this.f_93621_;
            emptySpaceSize = minimumSize > this.f_93619_ ? minimumSize : this.f_93619_ - minimumSize;
        }
        if (this.numSpacers > 0) {
            int spacerSize = (emptySpaceSize - nextSpot) / this.numSpacers;
            for (int i = 0; i < this.widgets.size(); ++i) {
                AbstractWidget widget = this.widgets.get(i);
                if (widget instanceof SpacerWidget) {
                    this.directionalWidget.setSizeAlongAxis(widget, spacerSize);
                } else if (!widget.f_93624_) continue;
                this.directionalWidget.setMainAxisPos(widget, nextSpot += this.padding.get(i).intValue());
                nextSpot += this.directionalWidget.getSizeAlongAxis(widget) + this.padding.get(i);
            }
        } else {
            int whiteSpaceSize = 0;
            switch (this.alignment) {
                case CENTERED: {
                    nextSpot += emptySpaceSize / 2;
                    break;
                }
                case END_ALIGNED: {
                    nextSpot += emptySpaceSize;
                    break;
                }
                case EQUALLY_SPACED: {
                    whiteSpaceSize = (emptySpaceSize - nextSpot) / (this.widgets.size() + 1);
                    nextSpot += whiteSpaceSize;
                }
            }
            for (int i = 0; i < this.widgets.size(); ++i) {
                AbstractWidget widget = this.widgets.get(i);
                if (!widget.f_93624_) continue;
                this.directionalWidget.setMainAxisPos(widget, nextSpot += this.padding.get(i).intValue());
                nextSpot += this.directionalWidget.getSizeAlongAxis(widget) + this.padding.get(i) + whiteSpaceSize;
            }
        }
    }

    public void m_6305_(@NotNull PoseStack poseStack, int x, int y, float partialTicks) {
        if (this.f_93624_) {
            if (this.sizeChanged) {
                this.recalculateSize();
            }
            for (AbstractWidget widget : this.widgets) {
                if (!widget.f_93624_) continue;
                this.directionalWidget.setSecondaryAxisPos(widget);
                widget.m_6305_(poseStack, x, y, partialTicks);
            }
        }
    }

    public void setVisible(boolean visible) {
        this.f_93624_ = visible;
        this.recalculateSize();
    }

    public void m_142291_(@NotNull NarrationElementOutput p_169152_) {
    }

    public static enum Direction {
        HORIZONTAL,
        VERTICAL;

    }

    public static enum Alignment {
        START_ALIGNED,
        CENTERED,
        END_ALIGNED,
        EQUALLY_SPACED;

    }

    static interface DirectionalWidget {
        public int getSizeAlongAxis(AbstractWidget var1);

        public void setSecondaryAxisPos(AbstractWidget var1);

        public void setMainAxisPos(AbstractWidget var1, int var2);

        public void setSizeAlongAxis(AbstractWidget var1, int var2);
    }
}

