/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import flash.npcmod.ClientProxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;

public class EntityDropdownWidget
extends AbstractWidget {
    private static final Minecraft minecraft = Minecraft.m_91087_();
    private static final ResourceLocation TEXTURE = new ResourceLocation("flashnpcs", "textures/gui/quest_objective_builder.png");
    List<String> names;
    List<EntityType<?>> types;
    EntityType<?> selectedType;
    private boolean showOptions;
    private int scrollY;
    private final int maxDisplayedOptions;

    public EntityDropdownWidget(EntityType<?> defaultOption, int x, int y, int width, boolean isRenderOnly) {
        this(defaultOption, x, y, width, 0, isRenderOnly);
    }

    public EntityDropdownWidget(EntityType<?> defaultOption, int x, int y, int width, int maxDisplayedOptions, boolean isRenderOnly) {
        super(x, y, Mth.m_14045_((int)width, (int)0, (int)200), 13, (Component)new TextComponent(EntityType.m_20613_(defaultOption).toString()));
        Map<String, EntityType<?>> mapToUse = isRenderOnly ? ClientProxy.RENDER_ENTITY_TYPES : ClientProxy.ENTITY_TYPES;
        this.names = mapToUse.keySet().stream().sorted().toList();
        this.types = new ArrayList();
        for (String name : this.names) {
            this.types.add(mapToUse.get(name));
        }
        String selectedName = EntityType.m_20613_(defaultOption).toString();
        if (!this.names.contains(selectedName)) {
            throw new IllegalArgumentException("This entity is not in the list of known valid entities: " + selectedName);
        }
        this.selectedType = defaultOption;
        this.maxDisplayedOptions = maxDisplayedOptions == 0 ? (minecraft.m_91268_().m_85446_() - (y + 13 + this.names.size() * 13)) / 13 : Math.abs(maxDisplayedOptions);
        this.scrollY = this.clampScroll(this.names.indexOf(selectedName));
    }

    public void m_6303_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Font fontrenderer = EntityDropdownWidget.minecraft.f_91062_;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69482_();
        int maxTextWidth = this.f_93618_ - 8;
        int i = this.m_7202_(this.m_198029_());
        Object name = fontrenderer.m_92895_(this.m_6035_().getString()) > maxTextWidth ? fontrenderer.m_92834_(this.m_6035_().getString(), maxTextWidth - fontrenderer.m_92895_("...")) + "..." : this.m_6035_().getString();
        this.drawOption(matrixStack, this.f_93620_, this.f_93621_, i, mouseX, mouseY, (String)name);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        this.m_93228_(matrixStack, this.f_93620_ + this.f_93618_, this.f_93621_, 200 + (this.showOptions ? 15 : 0), i * 13, 15, 13);
        if (this.showOptions) {
            for (i = 0; i < this.maxDisplayedOptions(); ++i) {
                int j = Mth.m_14045_((int)(i + this.scrollY), (int)0, (int)this.names.size());
                String entityTypeName = this.names.get(j);
                Object name2 = fontrenderer.m_92895_(entityTypeName) > maxTextWidth ? fontrenderer.m_92834_(entityTypeName, maxTextWidth - fontrenderer.m_92895_("...")) + "..." : entityTypeName;
                this.drawOption(matrixStack, this.f_93620_, this.f_93621_ + 13 + i * 13, this.m_7202_(this.isMouseOverOption(i, mouseX, mouseY)), mouseX, mouseY, (String)name2);
            }
        }
    }

    private int maxDisplayedOptions() {
        return Math.min(this.names.size(), this.maxDisplayedOptions);
    }

    private void drawOption(PoseStack matrixStack, int x, int y, int yImage, int mouseX, int mouseY, String text) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        this.m_93228_(matrixStack, x, y, 0, yImage * 13, this.f_93618_ / 2, 13);
        this.m_93228_(matrixStack, x + this.f_93618_ / 2, y, 200 - this.f_93618_ / 2, yImage * 13, this.f_93618_ / 2, 13);
        this.m_7906_(matrixStack, minecraft, mouseX, mouseY);
        int j = this.getFGColor();
        EntityDropdownWidget.m_93208_((PoseStack)matrixStack, (Font)EntityDropdownWidget.minecraft.f_91062_, (String)text, (int)(x + this.f_93618_ / 2), (int)(y + 3), (int)(j | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24));
    }

    private boolean isMouseOverOption(int index, double mouseX, double mouseY) {
        double minY = this.f_93621_ + 13 + index * 13;
        return mouseX >= (double)this.f_93620_ && mouseX <= (double)(this.f_93620_ + this.f_93618_) && mouseY >= minY && mouseY <= minY + 13.0;
    }

    private boolean isMouseOverAnyOption(double mouseX, double mouseY) {
        return mouseX >= (double)this.f_93620_ && mouseX <= (double)(this.f_93620_ + this.f_93618_) && mouseY >= (double)(this.f_93621_ + 13) && mouseY <= (double)(this.f_93621_ + this.f_93619_);
    }

    private void selectOption(int i) {
        i = Mth.m_14045_((int)(i + this.scrollY), (int)0, (int)this.names.size());
        this.selectedType = this.types.get(i);
        this.m_93666_((Component)new TextComponent(this.names.get(i)));
        this.setShowOptions(false);
    }

    public void selectOption(EntityType<?> option) {
        this.selectOption(this.types.indexOf(option));
    }

    public EntityType<?> getSelectedType() {
        return this.selectedType;
    }

    private void setShowOptions(boolean b) {
        this.showOptions = b;
        if (!this.showOptions) {
            this.f_93619_ = 13;
            this.m_93692_(false);
        } else {
            this.f_93619_ = 13 + this.maxDisplayedOptions() * 13;
            this.m_93692_(true);
        }
    }

    public boolean isShowingOptions() {
        return this.showOptions;
    }

    public void m_5716_(double mouseX, double mouseY) {
        if (!this.showOptions) {
            this.setShowOptions(true);
        } else if (!this.isMouseOverAnyOption(mouseX, mouseY)) {
            this.setShowOptions(false);
        } else {
            for (int i = 0; i < this.maxDisplayedOptions(); ++i) {
                double minY = this.f_93621_ + 13 + i * 13;
                if (!(mouseY >= minY) || !(mouseY <= minY + 13.0)) continue;
                this.selectOption(i);
                break;
            }
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        this.scrollY = delta > 0.0 ? this.clampScroll(this.scrollY - 1) : this.clampScroll(this.scrollY + 1);
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public int clampScroll(int newScroll) {
        int max = this.names.size() - this.maxDisplayedOptions;
        if (max > 0) {
            return Mth.m_14045_((int)newScroll, (int)0, (int)max);
        }
        return this.scrollY;
    }

    public void m_142291_(NarrationElementOutput p_169152_) {
    }
}

