/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.client.gui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import flash.npcmod.client.gui.screen.TreeBuilderScreen;
import flash.npcmod.core.client.dialogues.ClientDialogueUtil;
import flash.npcmod.core.node.BuilderNode;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FunctionListWidget<T extends BuilderNode> {
    private TreeBuilderScreen screen;
    private Minecraft minecraft;
    @Nullable
    private T editingNode;
    private int x;
    private int y;
    private int width;
    private int height;
    private boolean visible;
    private int scrollY;
    private int maxSize = 7;
    private String selectedFunction;
    private static final int lineHeight;

    public FunctionListWidget(TreeBuilderScreen screen, Minecraft minecraft) {
        this.screen = screen;
        this.minecraft = minecraft;
        this.visible = false;
        this.selectedFunction = "";
        this.calculatePositionAndDimensions();
    }

    public void setEditingNode(@Nullable T editingNode) {
        this.editingNode = editingNode;
    }

    public void calculatePositionAndDimensions() {
        this.width = 0;
        for (String name : ClientDialogueUtil.FUNCTION_NAMES) {
            this.width = Math.max(this.width, this.minecraft.f_91062_.m_92895_(name) + 4);
        }
        this.x = this.screen.f_96543_ / 2 - this.width / 2;
        int n = Math.min(ClientDialogueUtil.FUNCTION_NAMES.size(), this.maxSize);
        Objects.requireNonNull(this.minecraft.f_91062_);
        this.height = n * (9 + 2);
        this.y = this.screen.f_96544_ / 2 - this.height / 2;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.calculatePositionAndDimensions();
    }

    public void draw(PoseStack matrixStack) {
        if (this.isVisible()) {
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)this.x, (double)this.y, 0.0);
            this.drawRectangles(matrixStack);
            this.drawText(matrixStack);
            matrixStack.m_85849_();
        }
    }

    private void drawRectangles(PoseStack matrixStack) {
        int black = -16777216;
        int white = -1;
        int green = -16711936;
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)0, (int)0, (int)this.width, (int)1, (int)black);
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)0, (int)0, (int)1, (int)this.height, (int)black);
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)(this.width - 1), (int)0, (int)this.width, (int)this.height, (int)black);
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)0, (int)this.height, (int)this.width, (int)(this.height + 1), (int)black);
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)1, (int)1, (int)(this.width - 1), (int)this.height, (int)white);
        int minY = lineHeight;
        int size = ClientDialogueUtil.FUNCTION_NAMES.size();
        for (int i = 0; i < (size > this.maxSize ? this.maxSize : size); ++i) {
            boolean isSelected = ClientDialogueUtil.FUNCTION_NAMES.get(Mth.m_14045_((int)(i + this.scrollY), (int)0, (int)(ClientDialogueUtil.FUNCTION_NAMES.size() - 1))).equals(this.selectedFunction);
            GuiComponent.m_93172_((PoseStack)matrixStack, (int)1, (int)(minY - (i == 0 ? 0 : 1 * i)), (int)(this.width - 1), (int)(minY + 1 - (i == 0 ? 0 : 1 * i)), (int)black);
            if (isSelected) {
                GuiComponent.m_93172_((PoseStack)matrixStack, (int)1, (int)(minY - lineHeight + (i == 0 ? 1 : (i - 1) * -1)), (int)(this.width - 1), (int)(minY - i), (int)green);
            }
            minY += 1 + lineHeight;
        }
    }

    private void drawText(PoseStack matrixStack) {
        int size = ClientDialogueUtil.FUNCTION_NAMES.size();
        for (int i = 0; i < (size > this.maxSize ? this.maxSize : size); ++i) {
            String name = ClientDialogueUtil.FUNCTION_NAMES.get(i + this.scrollY);
            int y = 2 + i * lineHeight;
            this.minecraft.f_91062_.m_92883_(matrixStack, name, (float)(this.width / 2 - this.minecraft.f_91062_.m_92895_(name) / 2), (float)y, 0);
        }
    }

    public void clickedOn(double mouseX, double mouseY) {
        if (this.isVisible() && mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height) && ClientDialogueUtil.FUNCTION_NAMES.size() > 0) {
            int minY = this.y + 1;
            int size = ClientDialogueUtil.FUNCTION_NAMES.size();
            for (int i = 0; i < (size > this.maxSize ? this.maxSize : size); ++i) {
                if (mouseY >= (double)minY && mouseY <= (double)(minY + lineHeight)) {
                    this.clickedOnFunction(i);
                }
                minY += lineHeight + 1;
            }
        }
    }

    public void clickedOnFunction(int i) {
        int index = Mth.m_14045_((int)(i + this.scrollY), (int)0, (int)(ClientDialogueUtil.FUNCTION_NAMES.size() - 1));
        String newSelection = ClientDialogueUtil.FUNCTION_NAMES.get(index);
        this.selectedFunction = this.selectedFunction.equals(newSelection) || i == -1 ? "" : newSelection;
    }

    public void setFunction() {
        Object function = this.selectedFunction.split("::")[0];
        if (!this.screen.getNewFunctionParams().isEmpty()) {
            function = (String)function + "::" + this.screen.getNewFunctionParams();
        }
        ((BuilderNode)this.editingNode).getNodeData().setFunction((String)function);
        this.selectedFunction = "";
    }

    public String getSelectedFunction() {
        return this.selectedFunction;
    }

    public void onScrolled(double delta) {
        if (this.isVisible()) {
            this.scrollY = delta > 0.0 ? this.clampScroll(this.scrollY - 1) : this.clampScroll(this.scrollY + 1);
        }
    }

    public int clampScroll(int newScroll) {
        int max = ClientDialogueUtil.FUNCTION_NAMES.size() - this.maxSize;
        if (max > 0) {
            return Mth.m_14045_((int)newScroll, (int)0, (int)max);
        }
        return this.scrollY;
    }

    static {
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        lineHeight = 2 + 9;
    }
}

