/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.client.gui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import flash.npcmod.client.gui.screen.TreeBuilderScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ListWidget<S extends TreeBuilderScreen> {
    private S screen;
    private Minecraft minecraft;
    private double x;
    private double y;
    private int width;
    private int height;
    private boolean visible;
    private int scrollY;
    private int maxSize = 7;
    private String selectedOption;
    private int selectedOptionIndex;
    private List<String> options;
    private static final int lineHeight;

    public ListWidget(S screen, Minecraft minecraft) {
        this.screen = screen;
        this.minecraft = minecraft;
        this.visible = false;
        this.selectedOption = "";
        this.selectedOptionIndex = -1;
        this.options = new ArrayList<String>();
    }

    public void calculatePositionAndDimensions() {
        this.width = 0;
        for (String name : this.options) {
            this.width = Math.max(this.width, this.minecraft.f_91062_.m_92895_(name) + 4);
        }
        if (this.x > (double)(((TreeBuilderScreen)((Object)this.screen)).f_96543_ / 2)) {
            this.x -= (double)this.width;
        }
        int n = Math.min(this.options.size(), this.maxSize);
        Objects.requireNonNull(this.minecraft.f_91062_);
        this.height = n * (9 + 2);
        if (this.y > (double)(((TreeBuilderScreen)((Object)this.screen)).f_96544_ / 2)) {
            this.y -= (double)this.height;
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.selectedOption = "";
        this.selectedOptionIndex = -1;
        this.calculatePositionAndDimensions();
    }

    public void setX(double posX) {
        this.x = posX;
    }

    public void setY(double posY) {
        this.y = posY;
    }

    public void setOptions(List<String> options) {
        this.options = options;
    }

    public void draw(PoseStack matrixStack) {
        if (this.isVisible()) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(this.x, this.y, 0.0);
            this.drawRectangles(matrixStack);
            this.drawText(matrixStack);
            matrixStack.m_85849_();
        }
    }

    private void drawRectangles(PoseStack matrixStack) {
        int black = -16777216;
        int grey = -3355444;
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)0, (int)0, (int)this.width, (int)1, (int)black);
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)0, (int)0, (int)1, (int)this.height, (int)black);
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)(this.width - 1), (int)0, (int)this.width, (int)this.height, (int)black);
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)0, (int)this.height, (int)this.width, (int)(this.height + 1), (int)black);
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)1, (int)1, (int)(this.width - 1), (int)this.height, (int)grey);
        int minY = lineHeight;
        int size = this.options.size();
        for (int i = 0; i < (size > this.maxSize ? this.maxSize : size); ++i) {
            GuiComponent.m_93172_((PoseStack)matrixStack, (int)1, (int)(minY - (i == 0 ? 0 : 1 * i)), (int)(this.width - 1), (int)(minY + 1 - (i == 0 ? 0 : 1 * i)), (int)black);
            minY += 1 + lineHeight;
        }
    }

    private void drawText(PoseStack matrixStack) {
        int size = this.options.size();
        for (int i = 0; i < (size > this.maxSize ? this.maxSize : size); ++i) {
            String name = this.options.get(i + this.scrollY);
            int y = 2 + i * lineHeight;
            this.minecraft.f_91062_.m_92883_(matrixStack, name, (float)(this.width / 2 - this.minecraft.f_91062_.m_92895_(name) / 2), (float)y, 0);
        }
    }

    public void clickedOn(double mouseX, double mouseY) {
        if (this.isVisible() && mouseX >= this.x && mouseX <= this.x + (double)this.width && mouseY >= this.y && mouseY <= this.y + (double)this.height && this.options.size() > 0) {
            double minY = this.y + 1.0;
            int size = this.options.size();
            for (int i = 0; i < (size > this.maxSize ? this.maxSize : size); ++i) {
                if (mouseY >= minY && mouseY <= minY + (double)lineHeight) {
                    this.clickedOnFunction(i);
                }
                minY += (double)(lineHeight + 1);
            }
        }
    }

    public void clickedOnFunction(int i) {
        int index = Mth.m_14045_((int)(i + this.scrollY), (int)0, (int)(this.options.size() - 1));
        String newSelection = this.options.get(index);
        if (i == -1) {
            this.selectedOption = "";
            this.selectedOptionIndex = -1;
        } else {
            this.selectedOption = newSelection;
            this.selectedOptionIndex = i;
        }
    }

    public String getSelectedOption() {
        return this.selectedOption;
    }

    public int getSelectedOptionIndex() {
        return this.selectedOptionIndex;
    }

    public void onScrolled(double delta) {
        if (this.isVisible()) {
            this.scrollY = delta > 0.0 ? this.clampScroll(this.scrollY - 1) : this.clampScroll(this.scrollY + 1);
        }
    }

    public int clampScroll(int newScroll) {
        int max = this.options.size() - this.maxSize;
        if (max > 0) {
            return Mth.m_14045_((int)newScroll, (int)0, (int)max);
        }
        return this.scrollY;
    }

    static {
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        lineHeight = 2 + 9;
    }
}

