/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import flash.npcmod.client.gui.screen.dialogue.DialogueScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TextButton
extends Button {
    List<List<FormattedCharSequence>> trimmedTexts = new ArrayList<List<FormattedCharSequence>>();

    public TextButton(int x, int y, int width, Component title, Button.OnPress pressedAction) {
        super(x, y, width, 9, title, pressedAction);
        String[] lines = DialogueScreen.splitTextIntoLines(title.getString());
        int height = 0;
        for (int i = lines.length - 1; i >= 0; --i) {
            Object line = i == lines.length - 1 ? "> " + lines[i] : lines[i];
            List trimmedText = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)new TextComponent((String)line), width);
            this.trimmedTexts.add(trimmedText);
            height += 9 * trimmedText.size();
        }
        this.setHeight(height);
    }

    public void m_6303_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Minecraft minecraft = Minecraft.m_91087_();
        matrixStack.m_85836_();
        Font fontrenderer = minecraft.f_91062_;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69482_();
        int j = this.m_198029_() ? 0xFFFF00 : this.getFGColor();
        this.drawMultilineText(matrixStack, fontrenderer, this.f_93620_, this.f_93621_, j | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
        if (this.m_198029_()) {
            this.m_7428_(matrixStack, mouseX, mouseY);
        }
        matrixStack.m_85849_();
    }

    private void drawMultilineText(PoseStack matrixStack, Font font, int x, int y, int color) {
        int h = 0;
        for (int i = 0; i < this.trimmedTexts.size(); ++i) {
            List<FormattedCharSequence> trimmedText = this.trimmedTexts.get(i);
            for (int j = 0; j < trimmedText.size(); ++j) {
                FormattedCharSequence processor = trimmedText.get(j);
                int k = i != 0 || j > 0 ? 4 : 0;
                font.m_92877_(matrixStack, processor, (float)(x + k), (float)(y + h), color);
                Objects.requireNonNull(font);
                h += 9 + 1;
            }
        }
    }
}

