/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import flash.npcmod.core.client.SkinUtil;
import flash.npcmod.entity.NpcEntity;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.BeeStingerLayer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.SpinAttackEffectLayer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class NpcEntityRenderer
extends LivingEntityRenderer<NpcEntity, PlayerModel<NpcEntity>> {
    private static PlayerModel<NpcEntity> STEVE_MODEL;
    private static PlayerModel<NpcEntity> ALEX_MODEL;
    private LivingEntity currentRenderedEntity;
    private EntityRenderer currentRenderer;
    private Map<String, EntityRenderer> renderers = new HashMap<String, EntityRenderer>();

    public NpcEntityRenderer(EntityRendererProvider.Context context) {
        this(context, false);
    }

    public NpcEntityRenderer(EntityRendererProvider.Context context, boolean useSmallArms) {
        super(context, (EntityModel)new PlayerModel(context.m_174023_(useSmallArms ? ModelLayers.f_171166_ : ModelLayers.f_171162_), useSmallArms), 0.5f);
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(context.m_174023_(useSmallArms ? ModelLayers.f_171167_ : ModelLayers.f_171164_)), new HumanoidModel(context.m_174023_(useSmallArms ? ModelLayers.f_171168_ : ModelLayers.f_171165_))));
        this.m_115326_((RenderLayer)new ItemInHandLayer((RenderLayerParent)this));
        this.m_115326_((RenderLayer)new ArrowLayer(context, (LivingEntityRenderer)this));
        this.m_115326_((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.m_174027_()));
        this.m_115326_((RenderLayer)new ElytraLayer((RenderLayerParent)this, context.m_174027_()));
        this.m_115326_((RenderLayer)new SpinAttackEffectLayer((RenderLayerParent)this, context.m_174027_()));
        this.m_115326_((RenderLayer)new BeeStingerLayer((LivingEntityRenderer)this));
        STEVE_MODEL = new PlayerModel(context.m_174023_(ModelLayers.f_171162_), false);
        ALEX_MODEL = new PlayerModel(context.m_174023_(ModelLayers.f_171166_), true);
    }

    public void render(NpcEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        if (this.shouldRenderAsPlayer(entityIn)) {
            this.f_115290_ = entityIn.isSlim() ? ALEX_MODEL : STEVE_MODEL;
            this.f_114477_ = 0.5f * Math.max(entityIn.getScaleX(), entityIn.getScaleZ());
            this.f_114478_ = 1.0f;
            this.setModelProperties(entityIn);
            this.renderPlayerModel(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        } else {
            this.setRenderer(entityIn);
            this.currentRenderedEntity.f_19797_ = entityIn.f_19797_;
            this.copyRotationsAndAnim(entityIn);
            this.f_114477_ = this.currentRenderer.f_114477_ * Math.max(entityIn.getScaleX(), entityIn.getScaleZ());
            this.f_114478_ = this.currentRenderer.f_114478_;
            matrixStackIn.m_85836_();
            matrixStackIn.m_85841_(entityIn.getScaleX(), entityIn.getScaleY(), entityIn.getScaleZ());
            this.currentRenderer.m_7392_((Entity)this.currentRenderedEntity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
            matrixStackIn.m_85849_();
        }
        RenderNameplateEvent renderNameplateEvent = new RenderNameplateEvent((Entity)entityIn, entityIn.m_5446_(), (EntityRenderer)this, matrixStackIn, bufferIn, packedLightIn, partialTicks);
        MinecraftForge.EVENT_BUS.post((Event)renderNameplateEvent);
        if (renderNameplateEvent.getResult() != Event.Result.DENY && (renderNameplateEvent.getResult() == Event.Result.ALLOW || this.m_6512_((LivingEntity)entityIn))) {
            this.renderNameTag(entityIn, renderNameplateEvent.getContent(), matrixStackIn, bufferIn, packedLightIn);
        }
        MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Post((LivingEntity)entityIn, (LivingEntityRenderer)this, partialTicks, matrixStackIn, bufferIn, packedLightIn));
    }

    private void copyRotationsAndAnim(NpcEntity npcEntity) {
        if (this.currentRenderedEntity != null) {
            this.currentRenderedEntity.m_146922_(npcEntity.m_146908_());
            this.currentRenderedEntity.f_19859_ = npcEntity.f_19859_;
            this.currentRenderedEntity.m_5618_(npcEntity.f_20883_);
            this.currentRenderedEntity.f_20884_ = npcEntity.f_20884_;
            this.currentRenderedEntity.m_5616_(npcEntity.m_6080_());
            this.currentRenderedEntity.f_20886_ = npcEntity.f_20886_;
            this.currentRenderedEntity.m_146926_(npcEntity.m_146909_());
            this.currentRenderedEntity.f_19860_ = npcEntity.f_19860_;
            this.currentRenderedEntity.f_20925_ = npcEntity.f_20925_;
            this.currentRenderedEntity.f_20923_ = npcEntity.f_20923_;
            this.currentRenderedEntity.f_20924_ = npcEntity.f_20924_;
        }
    }

    private void setRenderer(NpcEntity npcEntity) {
        LivingEntity renderedEntity = npcEntity.getRenderedEntity();
        if (this.currentRenderedEntity != renderedEntity) {
            String key = npcEntity.getRenderedEntityTypeKey();
            if (this.renderers.containsKey(key)) {
                this.currentRenderer = this.renderers.get(key);
                this.currentRenderedEntity = renderedEntity;
            } else {
                EntityRenderer renderer = this.f_114476_.m_114382_((Entity)renderedEntity);
                if (renderer instanceof LivingEntityRenderer) {
                    this.currentRenderedEntity = renderedEntity;
                    this.currentRenderer = renderer;
                    this.renderers.put(key, renderer);
                } else {
                    this.renderers.put(key, null);
                    npcEntity.clearRenderedEntity();
                    this.currentRenderedEntity = null;
                    this.currentRenderer = null;
                }
            }
        }
    }

    private boolean shouldRenderAsPlayer(NpcEntity npcEntity) {
        return npcEntity.getRenderedEntity() == null || npcEntity.getRenderedEntityType().equals((Object)npcEntity.m_6095_());
    }

    public ResourceLocation getTextureLocation(NpcEntity entity) {
        try {
            if (this.shouldRenderAsPlayer(entity)) {
                if (entity.isTextureResourceLocation()) {
                    ResourceLocation texture = ResourceLocation.m_135820_((String)entity.getTexture());
                    return texture == null ? DefaultPlayerSkin.m_118626_() : texture;
                }
                return SkinUtil.loadSkin(entity.getTexture(), DefaultPlayerSkin.m_118626_(), true);
            }
            return DefaultPlayerSkin.m_118626_();
        }
        catch (Exception ignored) {
            return DefaultPlayerSkin.m_118626_();
        }
    }

    private void setModelProperties(NpcEntity npcEntity) {
        PlayerModel playermodel = (PlayerModel)this.m_7200_();
        if (npcEntity.m_5833_()) {
            playermodel.m_8009_(false);
            playermodel.f_102808_.f_104207_ = true;
            playermodel.f_102809_.f_104207_ = true;
        } else {
            playermodel.m_8009_(true);
            playermodel.f_102809_.f_104207_ = npcEntity.isModelPartShown(PlayerModelPart.HAT);
            playermodel.f_103378_.f_104207_ = npcEntity.isModelPartShown(PlayerModelPart.JACKET);
            playermodel.f_103376_.f_104207_ = npcEntity.isModelPartShown(PlayerModelPart.LEFT_PANTS_LEG);
            playermodel.f_103377_.f_104207_ = npcEntity.isModelPartShown(PlayerModelPart.RIGHT_PANTS_LEG);
            playermodel.f_103374_.f_104207_ = npcEntity.isModelPartShown(PlayerModelPart.LEFT_SLEEVE);
            playermodel.f_103375_.f_104207_ = npcEntity.isModelPartShown(PlayerModelPart.RIGHT_SLEEVE);
            playermodel.f_102817_ = npcEntity.m_6047_();
            HumanoidModel.ArmPose mainHand = NpcEntityRenderer.getArmPose(npcEntity, InteractionHand.MAIN_HAND);
            HumanoidModel.ArmPose offHand = NpcEntityRenderer.getArmPose(npcEntity, InteractionHand.OFF_HAND);
            if (mainHand.m_102897_()) {
                HumanoidModel.ArmPose armPose = offHand = npcEntity.m_21206_().m_41619_() ? HumanoidModel.ArmPose.EMPTY : HumanoidModel.ArmPose.ITEM;
            }
            if (npcEntity.m_5737_() == HumanoidArm.RIGHT) {
                playermodel.f_102816_ = mainHand;
                playermodel.f_102815_ = offHand;
            } else {
                playermodel.f_102816_ = offHand;
                playermodel.f_102815_ = mainHand;
            }
        }
    }

    private static HumanoidModel.ArmPose getArmPose(NpcEntity player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41619_()) {
            return HumanoidModel.ArmPose.EMPTY;
        }
        if (player.m_7655_() == hand && player.m_21212_() > 0) {
            UseAnim useanim = itemstack.m_41780_();
            if (useanim == UseAnim.BLOCK) {
                return HumanoidModel.ArmPose.BLOCK;
            }
            if (useanim == UseAnim.BOW) {
                return HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
            if (useanim == UseAnim.SPEAR) {
                return HumanoidModel.ArmPose.THROW_SPEAR;
            }
            if (useanim == UseAnim.CROSSBOW && hand == player.m_7655_()) {
                return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
            }
            if (useanim == UseAnim.SPYGLASS) {
                return HumanoidModel.ArmPose.SPYGLASS;
            }
        } else if (!player.f_20911_ && itemstack.m_41720_() instanceof CrossbowItem && CrossbowItem.m_40932_((ItemStack)itemstack)) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return HumanoidModel.ArmPose.ITEM;
    }

    @Nullable
    protected RenderType getRenderType(NpcEntity npcEntity, boolean p_115323_, boolean p_115324_, boolean p_115325_) {
        ResourceLocation resourcelocation = this.getTextureLocation(npcEntity);
        if (p_115324_) {
            return RenderType.m_110467_((ResourceLocation)resourcelocation);
        }
        if (p_115323_ && (this.shouldRenderAsPlayer(npcEntity) || this.currentRenderer == null)) {
            return ((PlayerModel)this.f_115290_).m_103119_(resourcelocation);
        }
        return p_115325_ ? RenderType.m_110491_((ResourceLocation)resourcelocation) : null;
    }

    private void renderPlayerModel(NpcEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        Direction direction;
        Entity entity;
        boolean shouldSit;
        if (MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Pre((LivingEntity)entityIn, (LivingEntityRenderer)this, partialTicks, matrixStackIn, bufferIn, packedLightIn))) {
            return;
        }
        matrixStackIn.m_85836_();
        ((PlayerModel)this.f_115290_).f_102608_ = this.m_115342_((LivingEntity)entityIn, partialTicks);
        ((PlayerModel)this.f_115290_).f_102609_ = shouldSit = entityIn.isSitting() || entityIn.m_20159_() && entityIn.m_20202_() != null && entityIn.m_20202_().shouldRiderSit();
        ((PlayerModel)this.f_115290_).f_102610_ = entityIn.m_6162_();
        float f = Mth.m_14189_((float)partialTicks, (float)entityIn.f_20884_, (float)entityIn.f_20883_);
        float f1 = Mth.m_14189_((float)partialTicks, (float)entityIn.f_20886_, (float)entityIn.f_20885_);
        float f2 = f1 - f;
        if (shouldSit && (entity = entityIn.m_20202_()) instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            f = Mth.m_14189_((float)partialTicks, (float)livingentity.f_20884_, (float)livingentity.f_20883_);
            f2 = f1 - f;
            float f3 = Mth.m_14177_((float)f2);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            f2 = f1 - f;
        }
        float f6 = Mth.m_14179_((float)partialTicks, (float)entityIn.f_19860_, (float)entityIn.m_146909_());
        if (NpcEntityRenderer.m_194453_((LivingEntity)entityIn)) {
            f6 *= -1.0f;
            f2 *= -1.0f;
        }
        if (entityIn.m_20089_() == Pose.SLEEPING && (direction = entityIn.m_21259_()) != null) {
            float f4 = entityIn.m_20236_(Pose.STANDING) - 0.1f;
            matrixStackIn.m_85837_((double)((float)(-direction.m_122429_()) * f4), 0.0, (double)((float)(-direction.m_122431_()) * f4));
        }
        float f7 = this.m_6930_((LivingEntity)entityIn, partialTicks);
        this.m_7523_((LivingEntity)entityIn, matrixStackIn, f7, f, partialTicks);
        matrixStackIn.m_85841_(-1.0f, -1.0f, 1.0f);
        this.scale(entityIn, matrixStackIn, partialTicks);
        matrixStackIn.m_85841_(entityIn.getScaleX(), entityIn.getScaleY(), entityIn.getScaleZ());
        matrixStackIn.m_85837_(0.0, (double)-1.501f, 0.0);
        float f8 = 0.0f;
        float f5 = 0.0f;
        if (!shouldSit && entityIn.m_6084_()) {
            f8 = Mth.m_14179_((float)partialTicks, (float)entityIn.f_20923_, (float)entityIn.f_20924_);
            f5 = entityIn.f_20925_ - entityIn.f_20924_ * (1.0f - partialTicks);
            if (entityIn.m_6162_()) {
                f5 *= 3.0f;
            }
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
        }
        ((PlayerModel)this.f_115290_).m_6839_((LivingEntity)entityIn, f5, f8, partialTicks);
        ((PlayerModel)this.f_115290_).m_6973_((LivingEntity)entityIn, f5, f8, f7, f2, f6);
        Minecraft minecraft = Minecraft.m_91087_();
        boolean flag = this.m_5933_((LivingEntity)entityIn);
        boolean flag1 = !flag && !entityIn.m_20177_((Player)minecraft.f_91074_);
        boolean flag2 = minecraft.m_91314_((Entity)entityIn);
        RenderType rendertype = this.getRenderType(entityIn, flag, flag1, flag2);
        if (rendertype != null) {
            VertexConsumer vertexconsumer = bufferIn.m_6299_(rendertype);
            int i = NpcEntityRenderer.m_115338_((LivingEntity)entityIn, (float)this.m_6931_((LivingEntity)entityIn, partialTicks));
            ((PlayerModel)this.f_115290_).m_7695_(matrixStackIn, vertexconsumer, packedLightIn, i, 1.0f, 1.0f, 1.0f, flag1 ? 0.15f : 1.0f);
        }
        if (!entityIn.m_5833_()) {
            for (RenderLayer renderlayer : this.f_115291_) {
                renderlayer.m_6494_(matrixStackIn, bufferIn, packedLightIn, (Entity)entityIn, f5, f8, partialTicks, f7, f2, f6);
            }
        }
        matrixStackIn.m_85849_();
    }

    public Vec3 getRenderOffset(NpcEntity npcEntity, float p_117786_) {
        if (this.shouldRenderAsPlayer(npcEntity)) {
            return npcEntity.m_6047_() ? new Vec3(0.0, -0.125, 0.0) : (npcEntity.isSitting() ? new Vec3(0.0, -0.55, 0.0) : super.m_7860_((Entity)npcEntity, p_117786_));
        }
        return Vec3.f_82478_;
    }

    protected void scale(NpcEntity npcEntity, PoseStack matrixStackIn, float partialTickTime) {
        float scale = 0.9375f;
        matrixStackIn.m_85841_(scale, scale, scale);
    }

    protected void renderNameTag(NpcEntity entityIn, Component displayNameIn, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        double d0;
        if (entityIn.m_20151_() && ForgeHooksClient.isNameplateInRenderDistance((Entity)entityIn, (double)(d0 = this.f_114476_.m_114471_((Entity)entityIn)))) {
            boolean flag = !entityIn.m_20163_();
            boolean isTitleVisible = entityIn.isTitleVisible();
            float f = entityIn.m_20206_() + (entityIn.isSitting() ? 1.0f : 0.5f);
            int i = isTitleVisible ? -10 : 0;
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(0.0, (double)f, 0.0);
            matrixStackIn.m_85845_(this.f_114476_.m_114470_());
            matrixStackIn.m_85841_(-0.025f, -0.025f, 0.025f);
            Matrix4f matrix4f = matrixStackIn.m_85850_().m_85861_();
            float f1 = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
            int j = (int)(f1 * 255.0f) << 24;
            Font font = this.m_114481_();
            float f2 = -font.m_92852_((FormattedText)displayNameIn) / 2;
            font.m_92841_(displayNameIn, f2, (float)i, 0x20FFFFFF, false, matrix4f, bufferIn, flag, j, packedLightIn);
            if (flag) {
                font.m_92841_(displayNameIn, f2, (float)i, -1, false, matrix4f, bufferIn, false, 0, packedLightIn);
            }
            if (isTitleVisible) {
                Component title = entityIn.getTitleComponent();
                float f3 = -font.m_92852_((FormattedText)title) / 2;
                font.m_92841_(title, f3, 0.0f, 0x20FFFFFF, false, matrix4f, bufferIn, flag, j, packedLightIn);
                if (flag) {
                    font.m_92841_(title, f3, 0.0f, -1, false, matrix4f, bufferIn, false, 0, packedLightIn);
                }
            }
            matrixStackIn.m_85849_();
        }
    }
}

