/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import flash.npcmod.capability.quests.IQuestCapability;
import flash.npcmod.capability.quests.QuestCapabilityProvider;
import flash.npcmod.commands.Command;
import flash.npcmod.core.functions.FunctionUtil;
import flash.npcmod.core.quests.Quest;
import flash.npcmod.core.quests.QuestInstance;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class DebugCommand
extends Command {
    @Override
    public String getName() {
        return "debug";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 4;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.executes(context -> this.toggleFunctionDebugMode((CommandSourceStack)context.getSource()));
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }

    private int tracked(CommandSourceStack source, ServerPlayer player) {
        IQuestCapability capability = QuestCapabilityProvider.getCapability((Player)player);
        source.m_81354_((Component)new TextComponent(player.m_7755_().getString() + "'s tracked quest: " + (capability.getTrackedQuest() == null ? "" : capability.getTrackedQuest())), false);
        return 1;
    }

    private int accepted(CommandSourceStack source, ServerPlayer player) {
        IQuestCapability capability = QuestCapabilityProvider.getCapability((Player)player);
        source.m_81354_((Component)new TextComponent(player.m_7755_().getString() + "'s accepted quests:"), false);
        ArrayList<QuestInstance> accepted = capability.getAcceptedQuests();
        if (accepted.size() > 0) {
            for (QuestInstance questInstance : accepted) {
                Quest quest = questInstance.getQuest();
                source.m_81354_((Component)new TextComponent("- " + quest.getDisplayName() + " [" + quest.getName() + "]"), false);
            }
            return 1;
        }
        return 0;
    }

    private int completed(CommandSourceStack source, ServerPlayer player) {
        IQuestCapability capability = QuestCapabilityProvider.getCapability((Player)player);
        source.m_81354_((Component)new TextComponent(player.m_7755_().getString() + "'s completed quests:"), false);
        ArrayList<String> completed = capability.getCompletedQuests();
        if (completed.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < completed.size(); ++i) {
                sb.append(completed.get(i));
                if (i >= completed.size() - 1) continue;
                sb.append(", ");
            }
            source.m_81354_((Component)new TextComponent(sb.toString()), false);
            return 1;
        }
        return 0;
    }

    private int toggleFunctionDebugMode(CommandSourceStack source) {
        FunctionUtil.toggleDebugMode();
        boolean debugMode = FunctionUtil.isDebugMode();
        source.m_81354_((Component)new TextComponent("Toggled Debug Mode to " + debugMode).m_130940_(debugMode ? ChatFormatting.GREEN : ChatFormatting.RED), true);
        return 0;
    }
}

