/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import flash.npcmod.commands.Command;
import flash.npcmod.commands.argument.NpcFunctionArgument;
import flash.npcmod.core.functions.AbstractFunction;
import flash.npcmod.core.functions.Function;
import flash.npcmod.core.functions.FunctionUtil;
import flash.npcmod.entity.NpcEntity;
import flash.npcmod.init.EntityInit;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;

public class FunctionsCommand
extends Command {
    @Override
    public String getName() {
        return "functions";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 4;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"delete").then(Commands.m_82129_((String)"function", (ArgumentType)NpcFunctionArgument.function()).executes(context -> this.delete((CommandSourceStack)context.getSource(), NpcFunctionArgument.getName(context, "function")))));
        builder.then(Commands.m_82127_((String)"list").executes(context -> this.list((CommandSourceStack)context.getSource())));
        builder.then(Commands.m_82127_((String)"run").then(Commands.m_82129_((String)"function", (ArgumentType)NpcFunctionArgument.functionWithDefaults()).executes(context -> this.runAs((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).m_81375_(), NpcFunctionArgument.getName(context, "function")))));
        builder.then(Commands.m_82127_((String)"runAs").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"function", (ArgumentType)NpcFunctionArgument.functionWithDefaults()).executes(context -> this.runAs((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), NpcFunctionArgument.getName(context, "function"))))));
    }

    private int delete(CommandSourceStack source, String function) {
        if (!FunctionUtil.FUNCTIONS.stream().map(AbstractFunction::getName).toList().contains(function)) {
            source.m_81352_((Component)new TextComponent("Function doesn't exist..."));
        }
        if (FunctionUtil.deleteFunction(function)) {
            source.m_81354_((Component)new TextComponent("Successfully deleted function: " + function).m_130940_(ChatFormatting.GREEN), false);
        } else {
            source.m_81352_((Component)new TextComponent("Couldn't delete function..."));
        }
        return 0;
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }

    private int list(CommandSourceStack source) {
        ArrayList functions = new ArrayList();
        FunctionUtil.FUNCTIONS.forEach(abstractFunction -> {
            if (abstractFunction instanceof Function) {
                String functionName = abstractFunction.getName();
                String[] parameterNames = abstractFunction.getParamNames();
                TextComponent functionTextComponent = new TextComponent(functionName);
                if (!(parameterNames.length <= 0 || parameterNames.length == 1 && parameterNames[0].isEmpty())) {
                    functionTextComponent.m_130946_("::");
                    for (int i = 0; i < parameterNames.length; ++i) {
                        functionTextComponent.m_7220_((Component)new TextComponent(parameterNames[i]).m_130940_(ChatFormatting.AQUA));
                        if (i >= parameterNames.length - 1) continue;
                        functionTextComponent.m_130946_(",");
                    }
                }
                StringBuilder callables = new StringBuilder();
                for (int i = 0; i < abstractFunction.getCallables().length; ++i) {
                    String callable = abstractFunction.getCallables()[i];
                    callables.append(callable);
                    if (i >= abstractFunction.getCallables().length - 1) continue;
                    callables.append("\n");
                }
                functions.add(functionTextComponent.m_6270_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent(callables.toString())))));
            }
        });
        TextComponent functionsComponent = new TextComponent("List of Functions: ");
        for (int i = 0; i < functions.size(); ++i) {
            functionsComponent.m_7220_((Component)ComponentUtils.m_130748_((Component)((Component)functions.get(i))).m_130940_(ChatFormatting.GREEN));
            if (i >= functions.size() - 1) continue;
            functionsComponent.m_130946_(", ");
        }
        source.m_81354_((Component)functionsComponent, false);
        return functions.size();
    }

    private int runAs(CommandSourceStack source, ServerPlayer player, String name) {
        NpcEntity npcEntity = (NpcEntity)((EntityType)EntityInit.NPC_ENTITY.get()).m_20615_(player.f_19853_);
        npcEntity.m_6593_((Component)new TextComponent("FAKE NPC"));
        FunctionUtil.callFromName(name, player, npcEntity);
        source.m_81354_((Component)new TextComponent("Called Function " + name + " as " + player.m_7755_().getString()).m_130940_(ChatFormatting.GREEN), true);
        return 0;
    }
}

