/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import flash.npcmod.capability.quests.IQuestCapability;
import flash.npcmod.capability.quests.QuestCapabilityProvider;
import flash.npcmod.commands.Command;
import flash.npcmod.commands.argument.QuestArgument;
import flash.npcmod.core.quests.CommonQuestUtil;
import flash.npcmod.core.quests.Quest;
import flash.npcmod.core.quests.QuestInstance;
import flash.npcmod.core.quests.QuestObjective;
import flash.npcmod.network.PacketDispatcher;
import flash.npcmod.network.packets.server.SOpenScreen;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class QuestsCommand
extends Command {
    @Override
    public String getName() {
        return "quests";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 4;
    }

    @Override
    public void build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"list").executes(context -> this.list((CommandSourceStack)context.getSource())));
        builder.then(Commands.m_82127_((String)"edit").then(Commands.m_82129_((String)"quest", (ArgumentType)QuestArgument.quest()).executes(context -> this.edit((CommandSourceStack)context.getSource(), QuestArgument.getName(context, "quest")))));
        builder.then(Commands.m_82127_((String)"completeObjective").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"quest", (ArgumentType)QuestArgument.quest()).then(Commands.m_82129_((String)"objective", (ArgumentType)StringArgumentType.greedyString()).executes(context -> this.completeObjective((CommandSourceStack)context.getSource(), (Player)EntityArgument.m_91474_((CommandContext)context, (String)"player"), QuestArgument.getName(context, "quest"), StringArgumentType.getString((CommandContext)context, (String)"objective")))))));
        builder.then(Commands.m_82127_((String)"completeQuest").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"quest", (ArgumentType)QuestArgument.quest()).then(Commands.m_82129_((String)"completeAllObjectives", (ArgumentType)BoolArgumentType.bool()).executes(context -> this.completeQuest((CommandSourceStack)context.getSource(), (Player)EntityArgument.m_91474_((CommandContext)context, (String)"player"), QuestArgument.getName(context, "quest"), BoolArgumentType.getBool((CommandContext)context, (String)"completeAllObjetives")))))));
        builder.then(Commands.m_82127_((String)"delete").then(Commands.m_82129_((String)"quest", (ArgumentType)QuestArgument.quest()).executes(context -> this.deleteQuest((CommandSourceStack)context.getSource(), QuestArgument.getName(context, "quest")))));
        builder.then(Commands.m_82127_((String)"reload").executes(context -> this.reloadAllQuests((CommandSourceStack)context.getSource())));
        builder.then(Commands.m_82127_((String)"reset").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82127_((String)"quest").then(Commands.m_82129_((String)"quest", (ArgumentType)QuestArgument.quest()).executes(context -> this.reset((CommandSourceStack)context.getSource(), (Player)EntityArgument.m_91474_((CommandContext)context, (String)"player"), QuestArgument.getName(context, "quest")))))).then(Commands.m_82127_((String)"all").executes(context -> this.resetAll((CommandSourceStack)context.getSource(), (Player)EntityArgument.m_91474_((CommandContext)context, (String)"player"))))));
    }

    private int deleteQuest(CommandSourceStack source, String quest) {
        if (CommonQuestUtil.fromName(quest) == null) {
            source.m_81352_((Component)new TextComponent("Quest doesn't exist..."));
        }
        if (CommonQuestUtil.deleteQuest(quest)) {
            source.m_81354_((Component)new TextComponent("Successfully deleted quest: " + quest).m_130940_(ChatFormatting.GREEN), false);
        } else {
            source.m_81352_((Component)new TextComponent("Couldn't delete quest..."));
        }
        return 0;
    }

    @Override
    public boolean isDedicatedServerOnly() {
        return false;
    }

    private int list(CommandSourceStack source) {
        ArrayList quests = new ArrayList();
        CommonQuestUtil.QUESTS.forEach(quest -> quests.add(new TextComponent(quest.getName()).m_6270_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent(quest.getDisplayName()))).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/flashnpcs quests edit " + quest.getName())))));
        TextComponent questsComponent = new TextComponent("List of Quests: ");
        for (int i = 0; i < quests.size(); ++i) {
            questsComponent.m_7220_((Component)ComponentUtils.m_130748_((Component)((Component)quests.get(i))).m_130940_(ChatFormatting.GREEN));
            if (i >= quests.size() - 1) continue;
            questsComponent.m_130946_(", ");
        }
        source.m_81354_((Component)questsComponent, false);
        return quests.size();
    }

    private int edit(CommandSourceStack source, String quest) throws CommandSyntaxException {
        ServerPlayer player = source.m_81375_();
        PacketDispatcher.sendTo(new SOpenScreen(SOpenScreen.EScreens.QUESTEDITOR, quest, 0), (Player)player);
        return 0;
    }

    private int completeObjective(CommandSourceStack source, Player player, String questName, String objectiveName) {
        if (player.m_6084_()) {
            IQuestCapability capability = QuestCapabilityProvider.getCapability(player);
            QuestInstance instance = null;
            for (QuestInstance questInstance : capability.getAcceptedQuests()) {
                if (!questInstance.getQuest().getName().equals(questName)) continue;
                instance = questInstance;
                break;
            }
            if (instance != null) {
                Quest quest = instance.getQuest();
                QuestObjective objective = null;
                for (QuestObjective questObjective : quest.getObjectives()) {
                    if (!questObjective.getName().equals(objectiveName)) continue;
                    objective = questObjective;
                    break;
                }
                if (objective != null) {
                    objective.forceComplete();
                    source.m_81354_((Component)new TextComponent("Completed quest objective " + objectiveName + " in " + questName + " for " + player.m_7755_().getString()).m_130940_(ChatFormatting.GREEN), true);
                } else {
                    source.m_81354_((Component)new TextComponent("The Quest " + questName + " doesn't have an Objective named " + objectiveName).m_130940_(ChatFormatting.RED), true);
                }
            } else {
                source.m_81354_((Component)new TextComponent(player.m_7755_().getString() + " doesn't have the Quest " + questName).m_130940_(ChatFormatting.RED), true);
            }
        }
        return 0;
    }

    private int completeQuest(CommandSourceStack source, Player player, String questName, boolean completeAllObjectives) {
        if (player.m_6084_()) {
            IQuestCapability capability = QuestCapabilityProvider.getCapability(player);
            QuestInstance instance = null;
            for (QuestInstance questInstance : capability.getAcceptedQuests()) {
                if (!questInstance.getQuest().getName().equals(questName)) continue;
                instance = questInstance;
                break;
            }
            if (instance != null) {
                Quest quest = instance.getQuest();
                if (completeAllObjectives) {
                    for (QuestObjective questObjective : quest.getObjectives()) {
                        if (questObjective.isComplete()) continue;
                        questObjective.forceComplete();
                    }
                }
                capability.completeQuest(instance);
            } else {
                source.m_81354_((Component)new TextComponent(player.m_7755_().getString() + " doesn't have the Quest " + questName).m_130940_(ChatFormatting.RED), true);
            }
        }
        return 0;
    }

    private int reloadAllQuests(CommandSourceStack source) {
        CommonQuestUtil.loadAllQuests();
        List playerList = source.m_81377_().m_6846_().m_11314_();
        for (ServerPlayer player : playerList) {
            CommonQuestUtil.syncPlayerQuests(player);
        }
        source.m_81354_((Component)new TextComponent("Reloaded all quests!").m_130940_(ChatFormatting.GREEN), true);
        return 0;
    }

    private int reset(CommandSourceStack source, Player player, String quest) {
        if (player != null && player.m_6084_()) {
            Quest quest1 = CommonQuestUtil.fromName(quest);
            if (quest1 != null) {
                IQuestCapability capability = QuestCapabilityProvider.getCapability(player);
                QuestInstance toRemoveInstance = null;
                for (QuestInstance questInstance : capability.getAcceptedQuests()) {
                    if (!questInstance.getQuest().equals(quest1)) continue;
                    toRemoveInstance = questInstance;
                    break;
                }
                String toRemoveName = null;
                for (String questName : capability.getCompletedQuests()) {
                    if (!questName.equals(quest)) continue;
                    toRemoveName = quest;
                    break;
                }
                if (toRemoveInstance != null || toRemoveName != null) {
                    if (toRemoveInstance != null) {
                        capability.abandonQuest(toRemoveInstance);
                    }
                    if (toRemoveName != null) {
                        capability.getCompletedQuests().remove(toRemoveName);
                    }
                    source.m_81354_((Component)new TextComponent("Reset " + player.m_7755_().getString() + "'s quest progress for quest " + quest).m_130940_(ChatFormatting.GREEN), true);
                } else {
                    source.m_81354_((Component)new TextComponent(player.m_7755_().getString() + " doesn't have any progress in " + quest).m_130940_(ChatFormatting.RED), true);
                }
            } else {
                source.m_81354_((Component)new TextComponent(quest + " does not exist").m_130940_(ChatFormatting.RED), true);
            }
        }
        return 0;
    }

    private int resetAll(CommandSourceStack source, Player player) {
        if (player != null && player.m_6084_()) {
            IQuestCapability capability = QuestCapabilityProvider.getCapability(player);
            capability.resetAllQuestProgress();
            source.m_81354_((Component)new TextComponent("Reset " + player.m_7755_().getString() + "'s quest data").m_130940_(ChatFormatting.GREEN), true);
        }
        return 0;
    }
}

