/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import flash.npcmod.Main;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.server.ServerLifecycleHooks;

public class ConfigHolder {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    @OnlyIn(value=Dist.CLIENT)
    public static Client CLIENT;
    public static Common COMMON;
    public static Server SERVER;

    private static JsonElement buildJsonConfig(String name, JsonElement config) {
        try {
            File jsonFile = ConfigHolder.getJsonConfigFile("", name);
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(jsonFile), StandardCharsets.UTF_8);
            GSON.toJson(config, (Appendable)fw);
            ((Writer)fw).flush();
            ((Writer)fw).close();
        }
        catch (Exception e) {
            Main.LOGGER.warn("Could not create config file " + name + ".json");
            e.printStackTrace();
        }
        return config;
    }

    private static JsonElement loadJsonConfig(String path, String name) {
        try {
            InputStreamReader is = new InputStreamReader((InputStream)new FileInputStream(ConfigHolder.getJsonConfigFile(path, name)), StandardCharsets.UTF_8);
            return (JsonElement)GSON.fromJson((Reader)is, JsonElement.class);
        }
        catch (FileNotFoundException e) {
            Main.LOGGER.warn("Could not find config file " + name + ".json");
            return null;
        }
    }

    private static JsonElement loadPerWorldJsonConfigOrDefault(String name, JsonElement defaultConfig) {
        JsonElement loadedConfig = null;
        try {
            InputStreamReader is = new InputStreamReader((InputStream)new FileInputStream(ConfigHolder.getPerWorldJsonConfigFile("", name)), StandardCharsets.UTF_8);
            loadedConfig = (JsonElement)GSON.fromJson((Reader)is, JsonElement.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (loadedConfig == null) {
            Main.LOGGER.warn("Creating new config file " + name + ".json");
            return ConfigHolder.buildJsonConfig(name, defaultConfig);
        }
        return loadedConfig;
    }

    private static JsonElement loadJsonConfigOrDefault(String name, JsonElement defaultConfig) {
        JsonElement loadedConfig = ConfigHolder.loadJsonConfig("", name);
        if (loadedConfig == null) {
            Main.LOGGER.warn("Creating new config file " + name + ".json");
            return ConfigHolder.buildJsonConfig(name, defaultConfig);
        }
        return loadedConfig;
    }

    @Nullable
    private static File readFileFrom(String path, String name) {
        File directory = ConfigHolder.readDirectory(path);
        try {
            File file = new File(directory.getCanonicalPath(), name);
            return file;
        }
        catch (IOException e) {
            Main.LOGGER.warn("Could not read file " + path + "/" + name);
            return null;
        }
    }

    @Nullable
    private static File readDirectory(String path) {
        File directory = new File(".", path);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        return directory;
    }

    private static File getJsonConfigFile(String path, String name) {
        path = "config/" + (String)path;
        return ConfigHolder.readFileFrom((String)path, name + ".json");
    }

    private static File getPerWorldJsonConfigFile(String path, String name) {
        path = ConfigHolder.getWorldName() + "/serverconfig/" + (String)path;
        return ConfigHolder.readFileFrom((String)path, name + ".json");
    }

    private static String getWorldName() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        String worldName = server.m_129910_().m_5462_();
        if (server.m_6982_()) {
            return worldName;
        }
        return "saves/" + worldName;
    }

    public static void initServer() {
        SERVER = new Server();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void initClient() {
        if (CLIENT == null) {
            CLIENT = new Client();
        }
    }

    static {
        COMMON = new Common();
    }

    public static class Server
    extends JsonConfig {
        public Server() {
            super(ConfigType.SERVER);
        }

        @Override
        boolean isConfigRightType(JsonElement config) {
            return true;
        }

        @Override
        Predicate<Object> getConfigValidator() {
            return text -> {
                JsonElement jsonElement = this.prevalidateConfig(text);
                return jsonElement != null;
            };
        }

        @Override
        JsonElement getDefaultConfig() {
            return null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Client
    extends JsonConfig {
        public Client() {
            super(ConfigType.CLIENT);
        }

        @Override
        boolean isConfigRightType(JsonElement config) {
            return true;
        }

        @Override
        Predicate<Object> getConfigValidator() {
            return text -> {
                JsonElement jsonElement = this.prevalidateConfig(text);
                return jsonElement != null;
            };
        }

        @Override
        JsonElement getDefaultConfig() {
            return null;
        }
    }

    public static class Common
    extends JsonConfig {
        private static final List<String> DEFAULT_INVALID_COMMANDS = Arrays.asList("/ban", "/ban-ip", "/deop", "/forceload", "/op", "/pardon", "/pardon-ip", "/save-off", "/setidletimeout", "/setworldspawn", "/stop", "/whitelist", "/flashnpcs");
        private static final int DEFAULT_MAX_SAVED_NPCS = 20;
        private static final String INVALID_COMMANDS_KEY = "invalid_commands";
        private static final String MAX_SAVED_NPCS_KEY = "max_saved_npcs";

        public Common() {
            super(ConfigType.COMMON);
        }

        @Override
        public void reloadConfig() {
            super.reloadConfig();
            JsonObject config = this.getConfig().getAsJsonObject();
            JsonArray invalidCommands = config.getAsJsonArray(INVALID_COMMANDS_KEY);
            for (int i = 0; i < invalidCommands.size(); ++i) {
                String command = invalidCommands.get(i).getAsString();
                if (command.startsWith("/")) continue;
                invalidCommands.set(i, (JsonElement)new JsonPrimitive("/".concat(command)));
            }
            config.add(INVALID_COMMANDS_KEY, (JsonElement)invalidCommands);
        }

        @Override
        boolean isConfigRightType(JsonElement config) {
            return config.isJsonObject();
        }

        @Override
        Predicate<Object> getConfigValidator() {
            return text -> {
                try {
                    JsonElement jsonElement = this.prevalidateConfig(text);
                    if (jsonElement == null) {
                        return false;
                    }
                    JsonObject config = jsonElement.getAsJsonObject();
                    return config.has(INVALID_COMMANDS_KEY) && config.get(INVALID_COMMANDS_KEY).isJsonArray() && config.has(MAX_SAVED_NPCS_KEY) && config.get(MAX_SAVED_NPCS_KEY).isJsonPrimitive() && config.getAsJsonPrimitive(MAX_SAVED_NPCS_KEY).isNumber();
                }
                catch (Exception e) {
                    return false;
                }
            };
        }

        @Override
        JsonElement getDefaultConfig() {
            JsonObject config = new JsonObject();
            JsonArray defaultInvalidCommands = new JsonArray();
            DEFAULT_INVALID_COMMANDS.forEach(arg_0 -> ((JsonArray)defaultInvalidCommands).add(arg_0));
            config.add(INVALID_COMMANDS_KEY, (JsonElement)defaultInvalidCommands);
            config.addProperty(MAX_SAVED_NPCS_KEY, (Number)20);
            return config;
        }

        public boolean isInvalidCommand(String command) {
            JsonObject config = this.getConfig().getAsJsonObject();
            JsonArray invalidCommands = config.getAsJsonArray(INVALID_COMMANDS_KEY);
            for (int i = 0; i < invalidCommands.size(); ++i) {
                String invalidCommand = invalidCommands.get(i).getAsString();
                if (!command.equals(invalidCommand)) continue;
                return true;
            }
            return false;
        }

        public int getMaxSavedNpcs() {
            return this.getConfig().getAsJsonObject().getAsJsonPrimitive(MAX_SAVED_NPCS_KEY).getAsInt();
        }
    }

    private static abstract class JsonConfig {
        private JsonElement config;
        private ConfigType type;

        JsonConfig(ConfigType type) {
            this.type = type;
            this.reloadConfig();
        }

        public void reloadConfig() {
            JsonElement config = this.type == ConfigType.SERVER ? ConfigHolder.loadPerWorldJsonConfigOrDefault("flashnpcs-" + this.type.name().toLowerCase(), this.getDefaultConfig()) : ConfigHolder.loadJsonConfigOrDefault("flashnpcs-" + this.type.name().toLowerCase(), this.getDefaultConfig());
            if (this.isConfigRightType(config) && this.getConfigValidator().test(config.toString())) {
                this.config = config;
            } else {
                Main.LOGGER.warn("Config file flashnpcs-" + this.type.name().toLowerCase() + ".json has invalid data, returning default config instead.");
                this.config = this.getDefaultConfig();
            }
        }

        abstract boolean isConfigRightType(JsonElement var1);

        JsonElement prevalidateConfig(Object text) {
            if (text == null) {
                return null;
            }
            if (!text.getClass().isAssignableFrom(String.class)) {
                return null;
            }
            JsonElement jsonElement = (JsonElement)GSON.fromJson(String.valueOf(text), JsonElement.class);
            if (this.isConfigRightType(jsonElement)) {
                return jsonElement;
            }
            return null;
        }

        abstract Predicate<Object> getConfigValidator();

        abstract JsonElement getDefaultConfig();

        public JsonElement getConfig() {
            return this.config.deepCopy();
        }

        @OnlyIn(value=Dist.CLIENT)
        public void setConfig(JsonElement config) {
            this.config = config;
        }
    }

    private static enum ConfigType {
        CLIENT,
        COMMON,
        SERVER;

    }
}

