/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.core;

import com.google.gson.Gson;
import flash.npcmod.Main;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.server.ServerLifecycleHooks;

public class FileUtil {
    public static final Gson GSON = new Gson();
    private static final String SEPARATOR = Path.of(".", new String[0]).getFileSystem().getSeparator();

    public static String getGlobalDirectoryName() {
        return "flashnpcs/global";
    }

    public static String getWorldDirectory() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        Path rootPath = Path.of(".", new String[0]);
        try {
            String worldPath = server.m_129843_(LevelResource.f_78182_).toFile().getCanonicalPath();
            return worldPath.replace(rootPath.toFile().getCanonicalPath() + SEPARATOR, "");
        }
        catch (IOException e) {
            Main.LOGGER.warn("Error while getting world directory, falling back to the old method");
            e.printStackTrace();
            String worldName = server.m_129910_().m_5462_();
            if (server.m_6982_()) {
                return worldName;
            }
            return "saves" + SEPARATOR + worldName;
        }
    }

    @Nullable
    public static File getFileFromPath(String path, String name) {
        if (FileUtil.shouldGetFromWorld()) {
            path = FileUtil.getWorldDirectory() + SEPARATOR + (String)path;
        }
        File directory = FileUtil.getOrCreateDirectory((String)path);
        try {
            return new File(directory.getCanonicalPath(), name);
        }
        catch (IOException e) {
            Main.LOGGER.warn("Could not get file " + (String)path + SEPARATOR + name);
            return null;
        }
    }

    @Nullable
    public static File getFileFromGlobal(String path, String name) {
        File directory = FileUtil.getOrCreateDirectory(FileUtil.getGlobalDirectoryName() + SEPARATOR + path);
        try {
            return new File(directory.getCanonicalPath(), name);
        }
        catch (IOException e) {
            Main.LOGGER.warn("Could not get file " + path + SEPARATOR + name);
            return null;
        }
    }

    public static File getOrCreateDirectory(String path) {
        File directory = new File(".", path);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        return directory;
    }

    private static File getFile(String path, String name, String extension) {
        File globalFile;
        if (!((String)name).endsWith(extension)) {
            name = (String)name + extension;
        }
        if ((globalFile = FileUtil.getFileFromGlobal(path, (String)name)) != null && globalFile.exists()) {
            return globalFile;
        }
        return FileUtil.getFileForWriting(path, (String)name, extension);
    }

    private static File getFileForWriting(String path, String name, String extension) {
        if (!((String)name).endsWith(extension)) {
            name = (String)name + extension;
        }
        path = "flashnpcs" + SEPARATOR + (String)path;
        return FileUtil.getFileFromPath((String)path, (String)name);
    }

    public static File getJsonFile(String path, String name) {
        return FileUtil.getFile(path, name, ".json");
    }

    public static File getJsonFileForWriting(String path, String name) {
        return FileUtil.getFileForWriting(path, name, ".json");
    }

    public static File getFunctionFile(String path, String name) {
        return FileUtil.getFile(path, name, ".npcfunction");
    }

    public static File getFunctionFileForWriting(String path, String name) {
        return FileUtil.getFileForWriting(path, name, ".npcfunction");
    }

    public static boolean shouldGetFromWorld() {
        return Main.PROXY.shouldSaveInWorld();
    }

    public static File[] getAllFiles(String path) {
        File[] globalDirectory = FileUtil.getAllFromGlobal(path);
        File[] worldDirectory = FileUtil.getAllFromWorld(path);
        File[] out = new File[globalDirectory.length + worldDirectory.length];
        System.arraycopy(globalDirectory, 0, out, 0, globalDirectory.length);
        System.arraycopy(worldDirectory, 0, out, globalDirectory.length, worldDirectory.length);
        return out;
    }

    public static File[] getAllFromGlobal(String path) {
        try {
            return FileUtil.getOrCreateDirectory(FileUtil.getGlobalDirectoryName() + "/" + path).listFiles();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new File[0];
        }
    }

    public static File[] getAllFromWorld(String path) {
        try {
            return FileUtil.getOrCreateDirectory((String)(FileUtil.shouldGetFromWorld() ? FileUtil.getWorldDirectory() + "/" : "") + "flashnpcs/" + path).listFiles();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new File[0];
        }
    }
}

