/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.core;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ItemUtil {
    public static boolean matches(ItemStack stack1, ItemStack stack2) {
        return ItemStack.m_41746_((ItemStack)stack1, (ItemStack)stack2) && ItemStack.m_41658_((ItemStack)stack1, (ItemStack)stack2);
    }

    public static void takeStack(Player player, ItemStack itemStack) {
        ItemUtil.takeStack(player, itemStack, itemStack.m_41613_());
    }

    public static void takeStack(Player player, ItemStack itemStack, int neededCount) {
        if (itemStack.m_41619_()) {
            return;
        }
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (ItemUtil.matches(itemStack, stack)) {
                int count = stack.m_41613_();
                stack.m_41774_(neededCount);
                neededCount -= count;
            }
            if (neededCount > 0) continue;
            break;
        }
    }

    public static void giveStack(Player player, ItemStack itemstack) {
        if (itemstack.m_41619_()) {
            return;
        }
        ItemEntity itemEntity = player.m_7197_(itemstack, true, true);
        if (itemEntity != null) {
            itemEntity.m_32061_();
            itemEntity.m_32047_(player.m_142081_());
        }
    }

    public static boolean hasAmount(Player sender, ItemStack itemStackIn) {
        if (itemStackIn.m_41619_()) {
            return true;
        }
        int neededCount = itemStackIn.m_41613_();
        int currentCount = 0;
        for (ItemStack itemStack : sender.m_150109_().f_35974_) {
            if (ItemUtil.matches(itemStackIn, itemStack)) {
                currentCount += itemStack.m_41613_();
            }
            if (currentCount < neededCount) continue;
            return true;
        }
        return false;
    }

    public static boolean hasItem(Player sender, ItemStack itemStackIn) {
        if (itemStackIn.m_41619_()) {
            return true;
        }
        for (ItemStack itemStack : sender.m_150109_().f_35974_) {
            if (!ItemUtil.matches(itemStackIn, itemStack)) continue;
            return true;
        }
        return false;
    }

    public static int getAmount(Player sender, ItemStack itemStackIn) {
        if (itemStackIn.m_41619_()) {
            return 0;
        }
        int currentCount = 0;
        for (ItemStack itemStack : sender.m_150109_().f_35974_) {
            if (!ItemUtil.matches(itemStackIn, itemStack)) continue;
            currentCount += itemStack.m_41613_();
        }
        return currentCount;
    }

    public static ItemStack stackFromString(String s) {
        ItemArgument itemArgument = new ItemArgument();
        try {
            ItemInput itemInput = itemArgument.parse(new StringReader(s));
            return itemInput.m_120980_(1, false);
        }
        catch (CommandSyntaxException e) {
            return ItemStack.f_41583_;
        }
    }

    public static String stackToString(ItemStack itemStack) {
        return itemStack == null || itemStack.m_41619_() ? "minecraft:empty" : itemStack.m_41720_().getRegistryName() + (itemStack.m_41782_() ? itemStack.m_41783_().toString() : "");
    }
}

