/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.core.client.dialogues;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import flash.npcmod.Main;
import flash.npcmod.capability.quests.IQuestCapability;
import flash.npcmod.capability.quests.QuestCapabilityProvider;
import flash.npcmod.client.gui.screen.dialogue.DialogueScreen;
import flash.npcmod.core.FileUtil;
import flash.npcmod.core.quests.QuestInstance;
import flash.npcmod.core.quests.QuestObjective;
import flash.npcmod.network.PacketDispatcher;
import flash.npcmod.network.packets.client.CRequestDialogue;
import flash.npcmod.network.packets.client.CRequestDialogueEditor;
import flash.npcmod.network.packets.client.CTalkObjectiveComplete;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientDialogueUtil {
    public static final List<String> FUNCTION_NAMES = new ArrayList<String>();
    @Nullable
    public static JsonObject currentDialogue = null;
    @Nullable
    public static JsonObject currentDialogueEditor = null;
    private static String currentText = "";
    private static String currentResponse = "";
    private static String currentFunction = "";
    private static JsonArray currentChildren = new JsonArray();

    public static void loadDialogue(String name) {
        if (name == null || name.isEmpty()) {
            currentDialogue = null;
            return;
        }
        try {
            File jsonFile = FileUtil.getJsonFile("dialogues", name);
            FileInputStream fis = new FileInputStream(jsonFile);
            InputStreamReader is = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);
            currentDialogue = (JsonObject)FileUtil.GSON.fromJson((Reader)is, JsonObject.class);
            is.close();
            Main.LOGGER.debug("Loaded dialogue file " + name);
        }
        catch (Exception e) {
            Main.LOGGER.debug("Requesting dialogue file " + name);
            PacketDispatcher.sendToServer(new CRequestDialogue(name));
        }
    }

    public static void loadDialogueEditor(String name) {
        if (name == null || name.isEmpty()) {
            currentDialogue = null;
            return;
        }
        try {
            InputStreamReader is = new InputStreamReader((InputStream)new FileInputStream(FileUtil.getJsonFile("dialogue_editor", name)), StandardCharsets.UTF_8);
            currentDialogueEditor = (JsonObject)FileUtil.GSON.fromJson((Reader)is, JsonObject.class);
            is.close();
        }
        catch (Exception e) {
            PacketDispatcher.sendToServer(new CRequestDialogueEditor(name));
        }
    }

    public static void initDialogue() {
        ClientDialogueUtil.loadDialogueOption("init");
    }

    public static void loadDialogueOption(String name) {
        ClientDialogueUtil.findText(name, currentDialogue);
    }

    private static boolean findText(String name, JsonObject currentObject) {
        if (!currentObject.has("entries")) {
            if (name.equals(currentObject.get("name").getAsString())) {
                currentDialogue = currentObject;
                ClientDialogueUtil.setVars(currentObject);
                return true;
            }
            if (currentObject.has("children")) {
                JsonArray children = currentObject.getAsJsonArray("children");
                for (int i = 0; i < children.size(); ++i) {
                    JsonObject currentChild = children.get(i).getAsJsonObject();
                    boolean result = ClientDialogueUtil.findText(name, currentChild);
                    if (!result) continue;
                    return true;
                }
            }
            ClientDialogueUtil.resetVars();
            return false;
        }
        JsonArray entries = currentObject.getAsJsonArray("entries");
        for (int i = 0; i < entries.size(); ++i) {
            JsonObject entry = entries.get(i).getAsJsonObject();
            boolean b = ClientDialogueUtil.findText(name, entry);
            if (!b) continue;
            return true;
        }
        ClientDialogueUtil.resetVars();
        return false;
    }

    private static void resetVars() {
        currentText = "";
        currentResponse = "";
        currentFunction = "";
        currentChildren = new JsonArray();
    }

    private static void setVars(JsonObject object) {
        currentText = object.get("text").getAsString();
        currentResponse = object.has("response") ? object.get("response").getAsString() : "";
        currentFunction = object.has("function") ? object.get("function").getAsString() : "";
        currentChildren = object.has("children") ? object.getAsJsonArray("children") : new JsonArray();
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof DialogueScreen) {
            DialogueScreen dialogueScreen = (DialogueScreen)screen;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null && player.m_6084_()) {
                IQuestCapability capability = QuestCapabilityProvider.getCapability((Player)player);
                ArrayList<QuestInstance> acceptedQuests = capability.getAcceptedQuests();
                for (QuestInstance questInstance : acceptedQuests) {
                    List<QuestObjective> objectives = questInstance.getQuest().getObjectives();
                    for (QuestObjective objective : objectives) {
                        if (!objective.getType().equals((Object)QuestObjective.ObjectiveType.Talk) || !objective.getObjective().equals(dialogueScreen.getNpcName()) || !Objects.equals(objective.getSecondaryObjective(), object.get("name").getAsString())) continue;
                        String objectiveName = questInstance.getQuest().getName() + ":::" + objective.getName();
                        PacketDispatcher.sendToServer(new CTalkObjectiveComplete(objectiveName));
                    }
                }
            }
        }
    }

    public static String getCurrentText() {
        return currentText;
    }

    public static String getCurrentResponse() {
        return currentResponse;
    }

    public static String getCurrentFunction() {
        return currentFunction;
    }

    public static String[] getDialogueOptionNamesFromChildren() {
        int childrenAmount = currentChildren.size();
        if (childrenAmount > 0) {
            String[] options = new String[childrenAmount];
            for (int i = 0; i < childrenAmount; ++i) {
                options[i] = currentChildren.get(i).getAsJsonObject().get("name").getAsString();
            }
            return options;
        }
        return new String[0];
    }

    public static String[] getDialogueOptionsFromChildren() {
        int childrenAmount = currentChildren.size();
        if (childrenAmount > 0) {
            String[] options = new String[childrenAmount];
            for (int i = 0; i < childrenAmount; ++i) {
                JsonObject childJson = currentChildren.get(i).getAsJsonObject();
                options[i] = childJson.get("text").getAsString();
            }
            return options;
        }
        return new String[0];
    }
}

