/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.core.functions;

import flash.npcmod.Main;
import flash.npcmod.core.functions.FunctionUtil;
import flash.npcmod.entity.NpcEntity;
import net.minecraft.Util;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;

public abstract class AbstractFunction {
    protected static final String[] empty = new String[0];
    protected String name;
    protected String[] paramNames;
    protected String[] callables;

    public AbstractFunction(String name, String[] paramNames, String[] callables) {
        this.name = name;
        this.paramNames = paramNames;
        this.callables = callables;
    }

    public String[] getCallables() {
        return this.callables;
    }

    public abstract void call(String[] var1, ServerPlayer var2, NpcEntity var3);

    public String getName() {
        return this.name;
    }

    public String[] getParamNames() {
        return this.paramNames;
    }

    protected void warnParameterAmount(ServerPlayer sender, NpcEntity npcEntity) {
        String warningMessage = "Function " + this.name + " in " + npcEntity.m_7755_().getString() + " does not have the right amount of parameters";
        if (FunctionUtil.isDebugMode()) {
            sender.m_9146_((Component)new TextComponent("[FlashNPCs] ".concat(warningMessage)), ChatType.SYSTEM, Util.f_137441_);
        }
        Main.LOGGER.warn(warningMessage);
    }

    protected void debugUsage(ServerPlayer sender, NpcEntity npcEntity) {
        Main.LOGGER.debug(sender.m_7755_().getString() + " used function " + this.name + " from npc " + npcEntity.m_7755_().getString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractFunction function = (AbstractFunction)o;
        return this.name.equals(function.name);
    }
}

