/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.core.functions;

import flash.npcmod.Main;
import flash.npcmod.core.FileUtil;
import flash.npcmod.core.functions.AbstractFunction;
import flash.npcmod.core.functions.Function;
import flash.npcmod.core.functions.defaultfunctions.AcceptQuestFunction;
import flash.npcmod.core.functions.defaultfunctions.CloseDialogueFunction;
import flash.npcmod.core.functions.defaultfunctions.MoveOnAcceptedQuestFunction;
import flash.npcmod.core.functions.defaultfunctions.MoveOnCompleteQuestFunction;
import flash.npcmod.core.functions.defaultfunctions.MoveOnDataFunction;
import flash.npcmod.core.functions.defaultfunctions.MoveOnScoreboardFunction;
import flash.npcmod.core.functions.defaultfunctions.MoveOnTagFunction;
import flash.npcmod.core.functions.defaultfunctions.MoveOnTeamFunction;
import flash.npcmod.core.functions.defaultfunctions.MoveToDialogueFunction;
import flash.npcmod.core.functions.defaultfunctions.OpenTradesFunction;
import flash.npcmod.core.functions.defaultfunctions.PlaySoundFunction;
import flash.npcmod.core.functions.defaultfunctions.RandomOptionFunction;
import flash.npcmod.entity.NpcEntity;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import org.apache.commons.io.FilenameUtils;

public class FunctionUtil {
    private static boolean DEBUG_MODE = false;
    public static final List<AbstractFunction> FUNCTIONS = new ArrayList<AbstractFunction>();
    private static List<AbstractFunction> DEFAULT_FUNCTIONS;
    private static final AcceptQuestFunction ACCEPT_QUEST;
    private static final CloseDialogueFunction CLOSE_DIALOGUE;
    private static final MoveOnAcceptedQuestFunction MOVE_ON_ACCEPTED_QUEST;
    private static final MoveOnCompleteQuestFunction MOVE_ON_COMPLETE_QUEST;
    private static final MoveOnDataFunction MOVE_ON_DATA_FUNCTION;
    private static final MoveOnScoreboardFunction MOVE_ON_SCOREBOARD;
    private static final MoveOnTagFunction MOVE_ON_TAG;
    private static final MoveOnTeamFunction MOVE_ON_TEAM;
    private static final MoveToDialogueFunction MOVE_TO_DIALOGUE;
    private static final OpenTradesFunction OPEN_TRADES;
    private static final PlaySoundFunction PLAY_SOUND;
    private static final RandomOptionFunction RANDOM_OPTION;

    private static void addDefaultFunctions() {
        FUNCTIONS.add(ACCEPT_QUEST);
        FUNCTIONS.add(CLOSE_DIALOGUE);
        FUNCTIONS.add(MOVE_ON_ACCEPTED_QUEST);
        FUNCTIONS.add(MOVE_ON_COMPLETE_QUEST);
        FUNCTIONS.add(MOVE_ON_DATA_FUNCTION);
        FUNCTIONS.add(MOVE_ON_SCOREBOARD);
        FUNCTIONS.add(MOVE_ON_TAG);
        FUNCTIONS.add(MOVE_ON_TEAM);
        FUNCTIONS.add(MOVE_TO_DIALOGUE);
        FUNCTIONS.add(OPEN_TRADES);
        FUNCTIONS.add(PLAY_SOUND);
        FUNCTIONS.add(RANDOM_OPTION);
        DEFAULT_FUNCTIONS = List.copyOf(FUNCTIONS);
    }

    public static List<AbstractFunction> getDefaultFunctions() {
        return DEFAULT_FUNCTIONS;
    }

    public static void toggleDebugMode() {
        DEBUG_MODE = !DEBUG_MODE;
    }

    public static boolean isDebugMode() {
        return DEBUG_MODE;
    }

    public static void build(String name, String function) {
        try {
            String[] lines = function.split("\n");
            String[] paramNames = lines[0].split(",");
            ArrayList<String> callables = new ArrayList<String>();
            File functionFile = FileUtil.getFunctionFileForWriting("functions", name);
            if (functionFile.exists()) {
                functionFile.delete();
            }
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(functionFile), StandardCharsets.UTF_8);
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                if (i > 0) {
                    callables.add(line);
                }
                writer.write(line);
                if (i >= lines.length - 1) continue;
                writer.write(System.lineSeparator());
            }
            ((Writer)writer).flush();
            ((Writer)writer).close();
            Function newFunction = new Function(name, paramNames, callables.toArray(new String[0]));
            FUNCTIONS.remove(newFunction);
            FUNCTIONS.add(newFunction);
        }
        catch (IOException e) {
            Main.LOGGER.warn("Could not build function file " + name + ".npcfunction");
        }
    }

    public static void loadAllFunctions() {
        File[] files;
        FUNCTIONS.clear();
        FunctionUtil.addDefaultFunctions();
        for (File entry : files = FileUtil.getAllFiles("functions")) {
            if (entry.isDirectory()) continue;
            FunctionUtil.loadFunctionFile(FilenameUtils.removeExtension((String)entry.getName()));
        }
    }

    public static boolean loadFunctionFile(String name) {
        try {
            FileInputStream is = new FileInputStream(FileUtil.getFunctionFile("functions", name));
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is, StandardCharsets.UTF_8));
            ArrayList<String> lines = new ArrayList<String>();
            String line = reader.readLine();
            String[] paramNames = line.split(",");
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
            Function function = new Function(name, paramNames, lines.toArray(new String[0]));
            FUNCTIONS.remove(function);
            FUNCTIONS.add(function);
            reader.close();
            ((InputStream)is).close();
            return true;
        }
        catch (FileNotFoundException e) {
            Main.LOGGER.warn("Could not find function file " + name + ".npcfunction");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean deleteFunction(String name) {
        try {
            File file = FileUtil.getFunctionFileForWriting("functions", name);
            if (file != null) {
                FUNCTIONS.removeIf(function -> function.getName().equals(name));
                return file.delete();
            }
        }
        catch (Exception e) {
            Main.LOGGER.warn("Error deleting function " + name);
        }
        return false;
    }

    public static void callFromName(String name, ServerPlayer sender, NpcEntity npcEntity) {
        name = name.replaceFirst("function:", "");
        String[] params = new String[]{};
        if (name.contains("::")) {
            String[] splitName = name.split("::");
            name = splitName[0];
            params = splitName[1].split(",");
        }
        boolean found = false;
        for (AbstractFunction function : FUNCTIONS) {
            if (!function.getName().equals(name)) continue;
            function.call(params, sender, npcEntity);
            found = true;
            break;
        }
        if (!found && FunctionUtil.loadFunctionFile(name)) {
            FunctionUtil.callFromName(name, sender, npcEntity);
        }
    }

    public static String replaceSelectors(String s, ServerPlayer sender, NpcEntity npcEntity) {
        return s.replaceAll("@p", sender.m_7755_().getString()).replaceAll("@npc", npcEntity.m_20149_());
    }

    public static String replaceParameters(String s, String paramName, String param) {
        return s.replaceAll(paramName, param);
    }

    static {
        ACCEPT_QUEST = new AcceptQuestFunction();
        CLOSE_DIALOGUE = new CloseDialogueFunction();
        MOVE_ON_ACCEPTED_QUEST = new MoveOnAcceptedQuestFunction();
        MOVE_ON_COMPLETE_QUEST = new MoveOnCompleteQuestFunction();
        MOVE_ON_DATA_FUNCTION = new MoveOnDataFunction();
        MOVE_ON_SCOREBOARD = new MoveOnScoreboardFunction();
        MOVE_ON_TAG = new MoveOnTagFunction();
        MOVE_ON_TEAM = new MoveOnTeamFunction();
        MOVE_TO_DIALOGUE = new MoveToDialogueFunction();
        OPEN_TRADES = new OpenTradesFunction();
        PLAY_SOUND = new PlaySoundFunction();
        RANDOM_OPTION = new RandomOptionFunction();
    }
}

