/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.core.node;

import com.mojang.blaze3d.vertex.PoseStack;
import flash.npcmod.client.gui.screen.TreeBuilderScreen;
import flash.npcmod.core.node.NodeData;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class BuilderNode {
    protected static final ResourceLocation TEXTURES = new ResourceLocation("flashnpcs", "textures/gui/edit_dialogue/textures.png");
    protected final TreeBuilderScreen builderScreen;
    protected final Minecraft minecraft;
    protected boolean dragging;
    protected boolean isQueuedForRemoval;
    protected int x;
    protected int y;
    protected int width;
    protected int nameBarHeight;
    protected int functionBarHeight;
    protected int[] connectionBarsHeights;
    protected int[] extraFieldsHeight;
    protected int actualHeight;
    protected static final int maxWidth = 120;
    protected static final int defaultTextHeight;
    public boolean hasConflictingName;
    @Nullable
    public BuilderNode parent;

    public BuilderNode(TreeBuilderScreen screen, Minecraft minecraft, int x, int y, int width) {
        this.builderScreen = screen;
        this.minecraft = minecraft;
        this.setPosition(x, y);
        this.setWidth(width);
        this.nameBarHeight = defaultTextHeight;
    }

    public void addChild(NodeData nodeData) {
        if (!this.getNodeData().isChild(nodeData)) {
            this.getNodeData().addChild(nodeData);
            this.calculateDimensions();
        }
    }

    public void addChild(NodeData nodeData, int index) {
        if (!this.getNodeData().isChild(nodeData)) {
            this.getNodeData().addChild(nodeData, index);
            this.calculateDimensions();
        }
    }

    protected void adjustWidth(String text) {
        int textWidth = this.minecraft.f_91062_.m_92895_(text);
        if (textWidth > this.width && textWidth < 120) {
            this.setWidth(textWidth);
        } else {
            this.setWidth(120);
        }
    }

    public void calculateDimensions() {
        String function = this.getFunction();
        this.adjustWidth(function);
        this.extraFieldsHeight = new int[this.getNumExtraFields()];
        List trimmedFunction = this.minecraft.f_91062_.m_92923_((FormattedText)new TextComponent(function), this.width - 4);
        int numOfFunctionLines = trimmedFunction.size() > 0 ? trimmedFunction.size() : 1;
        this.functionBarHeight = defaultTextHeight * numOfFunctionLines;
        String[] connectionNames = this.getConnectionNames();
        this.connectionBarsHeights = new int[connectionNames.length + 1];
        this.actualHeight = 0;
        for (int i = 0; i < connectionNames.length; ++i) {
            List trimmedOption = this.minecraft.f_91062_.m_92923_((FormattedText)new TextComponent(connectionNames[i]), this.width - 4);
            this.connectionBarsHeights[i] = defaultTextHeight * Math.max(trimmedOption.size(), 1);
            this.actualHeight += this.connectionBarsHeights[i] + 1;
        }
        this.connectionBarsHeights[this.getConnectionNames().length] = defaultTextHeight;
        this.actualHeight += 1 + this.nameBarHeight + 1 + this.functionBarHeight + 1 + defaultTextHeight + 1;
    }

    public boolean checkIfConnectingNodes() {
        BuilderNode selectedNode = this.builderScreen.getSelectedNode();
        if (selectedNode != null) {
            int index = this.builderScreen.getSelectedNodeIndex();
            if (index >= 0 || index == -1) {
                if (index == -1) {
                    this.builderScreen.setSelectedNode(selectedNode, selectedNode.getConnectionNames().length);
                }
                this.setParent(selectedNode);
            } else if (index == -2) {
                if (selectedNode.isInit()) {
                    return false;
                }
                this.builderScreen.setSelectedNode(selectedNode, selectedNode.getConnectionNames().length);
                selectedNode.setParent(this);
            }
            this.builderScreen.setSelectedNode(null, 0);
            return true;
        }
        return false;
    }

    public abstract void clickedOn(double var1, double var3, int var5, int var6, int var7, double var8, double var10);

    public void clickedOnNameBar(int button) {
        if (!this.isInit() && button == 1) {
            this.isQueuedForRemoval = true;
            return;
        }
        if (button == 0 && !this.isInit()) {
            this.builderScreen.setNodeBeingEdited(this, TreeBuilderScreen.EditType.NAME);
        }
    }

    public void clickedOnFunctionBar() {
        this.builderScreen.setNodeBeingEdited(this, TreeBuilderScreen.EditType.FUNCTION);
    }

    public void clickedOnOptionBar(int optionIndex, int button) {
        BuilderNode child;
        if (optionIndex >= 0 && optionIndex < this.getNodeData().getChildren().length && (child = this.findChild(optionIndex)) != null) {
            if (button == 0) {
                this.builderScreen.centerScreenOnNode(child);
            } else if (button == 1) {
                child.setParent(null);
            }
        }
    }

    public void clickedOnSelectIcon(int index) {
        if (this.builderScreen.allNodes.contains(this)) {
            if (index == -2) {
                this.builderScreen.setSelectedNode(this, index);
                this.setParent(null);
            } else if (index == -1) {
                this.builderScreen.setSelectedNode(this, this.getConnectionNames().length);
            } else {
                for (BuilderNode builderNode : this.builderScreen.allNodes) {
                    if (!builderNode.getName().equals(this.getConnectionNames()[index - 1]) || builderNode.parent == null || !builderNode.parent.equals(this)) continue;
                    builderNode.setParent(null);
                    this.builderScreen.setSelectedNode(this, this.getConnectionNames().length);
                    break;
                }
            }
        }
    }

    public void draw(PoseStack matrixStack, double scrollX, double scrollY) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(scrollX, scrollY, 0.0);
        matrixStack.m_85837_((double)this.x, (double)this.y, 0.0);
        this.drawLinesToParent(matrixStack);
        this.drawIcons(matrixStack);
        if (this.isVisible(scrollX, scrollY)) {
            this.drawRectangles(matrixStack);
            this.minecraft.f_91062_.m_92883_(matrixStack, this.getName(), 3.0f, 3.0f, 0);
            int minY = 2 + this.nameBarHeight;
            minY = this.drawExtraTexts(matrixStack, minY);
            String function = this.getFunction();
            this.drawMultilineText(matrixStack, function.isEmpty() ? "Function" : function, minY, function.isEmpty());
            this.drawOptionsText(matrixStack, minY += this.functionBarHeight);
        }
        matrixStack.m_85849_();
    }

    protected abstract int drawExtraRectangles(PoseStack var1, int var2);

    protected abstract int drawExtraTexts(PoseStack var1, int var2);

    protected abstract void drawIcons(PoseStack var1);

    protected abstract void drawLinesToParent(PoseStack var1);

    protected void drawMultilineText(PoseStack matrixStack, String text, int y, boolean isEmpty) {
        List lines = this.minecraft.f_91062_.m_92923_((FormattedText)new TextComponent(text), this.width - 4);
        for (int i = 0; i < lines.size(); ++i) {
            FormattedCharSequence processor = (FormattedCharSequence)lines.get(i);
            this.minecraft.f_91062_.m_92877_(matrixStack, processor, 3.0f, (float)(y + 2 + defaultTextHeight * i), isEmpty ? -4473925 : 0);
        }
    }

    protected void drawOptionsText(PoseStack matrixStack, int minY) {
        for (int i = 0; i < this.getConnectionNames().length; ++i) {
            this.drawMultilineText(matrixStack, this.getConnectionNames()[i], minY += (i > 0 ? this.connectionBarsHeights[i - 1] : 0) + 1, false);
        }
        minY = this.getConnectionNames().length > 0 ? (minY += this.connectionBarsHeights[this.connectionBarsHeights.length - 1] + 1) : ++minY;
        this.drawMultilineText(matrixStack, "New Option", minY, true);
    }

    protected void drawRectangles(PoseStack matrixStack) {
        int black = -16777216;
        int gray = -3355444;
        int nameBar = this.hasConflictingName ? -65536 : -16711681;
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)0, (int)0, (int)this.width, (int)1, (int)black);
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)0, (int)0, (int)1, (int)this.actualHeight, (int)black);
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)(this.width - 1), (int)0, (int)this.width, (int)this.actualHeight, (int)black);
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)0, (int)(this.actualHeight - 1), (int)this.width, (int)this.actualHeight, (int)black);
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)1, (int)1, (int)(this.width - 1), (int)(this.actualHeight - 1), (int)gray);
        int minY = 1 + this.nameBarHeight;
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)1, (int)1, (int)(this.width - 1), (int)minY, (int)nameBar);
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)1, (int)minY, (int)(this.width - 1), (int)(minY + 1), (int)black);
        minY = this.drawExtraRectangles(matrixStack, minY);
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)1, (int)(minY += 1 + this.functionBarHeight), (int)(this.width - 1), (int)(minY + 1), (int)black);
        for (int i = 0; i < this.getConnectionNames().length; ++i) {
            GuiComponent.m_93172_((PoseStack)matrixStack, (int)1, (int)(minY += 1 + this.connectionBarsHeights[i]), (int)(this.width - 1), (int)(minY + 1), (int)black);
        }
    }

    protected void drawSingleLineText(PoseStack matrixStack, String text, int y, boolean isEmpty) {
        this.minecraft.f_91062_.m_92883_(matrixStack, text, 3.0f, (float)(y + 2), isEmpty ? -4473925 : 0);
    }

    public abstract boolean equals(Object var1);

    @Nullable
    protected BuilderNode findChild(int index) {
        NodeData child = this.getNodeData().getChildren()[index];
        for (BuilderNode node : this.builderScreen.allNodes) {
            if (!node.getNodeData().equals(child)) continue;
            return node;
        }
        return null;
    }

    public int[] getConnectionBarsHeights() {
        return this.connectionBarsHeights;
    }

    public String[] getConnectionNames() {
        String[] options = new String[this.getNodeData().getChildren().length];
        for (int i = 0; i < options.length; ++i) {
            options[i] = this.getNodeData().getChildren()[i].getName();
        }
        return options;
    }

    public int[] getEndPointLocation() {
        int x = -12;
        int y = 2 + this.nameBarHeight;
        if (this.extraFieldsHeight.length > 0) {
            y += this.extraFieldsHeight[0] / 2 - 4;
        }
        return new int[]{x, y};
    }

    public String getFunction() {
        return this.getNodeData().getFunction();
    }

    public int getHeight() {
        return this.actualHeight;
    }

    public String getName() {
        return this.getNodeData().getName();
    }

    public abstract NodeData getNodeData();

    public abstract int getNumExtraFields();

    public int[] getStartPointLocation(int index) {
        int x = this.width + 4;
        int minY = 2 + this.nameBarHeight + 1 + this.functionBarHeight;
        for (int height : this.extraFieldsHeight) {
            minY += height + 1;
        }
        for (int i = 0; i < index; ++i) {
            minY += 1 + this.connectionBarsHeights[i];
        }
        int y = minY + 1 + this.connectionBarsHeights[index] / 2 - 4;
        return new int[]{x, y};
    }

    public int getWidth() {
        return this.width;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public boolean isQueuedForRemoval() {
        return this.isQueuedForRemoval;
    }

    public boolean isStart() {
        return this.parent == null;
    }

    public boolean isInit() {
        return this.getName().equals("init");
    }

    public boolean isVisible(double scrollX, double scrollY) {
        return -scrollX <= (double)(this.x + 9 + this.width + 12) && -scrollY <= (double)(this.y + 18 + this.actualHeight) && -scrollX + (double)this.minecraft.m_91268_().m_85445_() >= (double)(this.x + 9 - 12) && -scrollY + (double)this.minecraft.m_91268_().m_85446_() >= (double)(this.y + 18);
    }

    public void remove() {
        if (this.builderScreen.allNodes.contains(this)) {
            this.setParent(null);
            this.builderScreen.allNodes.remove(this);
        }
    }

    public void removeChild(NodeData childData) {
        if (this.getNodeData().isChild(childData)) {
            this.getNodeData().removeChild(childData);
            this.calculateDimensions();
        }
    }

    public void setPosition(int x, int y) {
        this.x = Mth.m_14045_((int)x, (int)0, (int)this.builderScreen.maxX);
        this.y = Mth.m_14045_((int)y, (int)0, (int)this.builderScreen.maxY);
    }

    private void setWidth(int width) {
        this.width = Math.min(Math.max(50, width), 120);
    }

    public abstract void setParent(@Nullable BuilderNode var1);

    public void stopDragging() {
        this.dragging = false;
    }

    public String toString() {
        return "BuilderNode{nodeData=" + this.getNodeData() + "}";
    }

    static {
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        defaultTextHeight = 2 + 9;
    }
}

