/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.core.node;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class NodeData {
    public static final String INIT_NODE_NAME = "init";
    protected String name;
    protected String function;
    protected List<NodeData> children;
    protected boolean isInitData;

    public NodeData(String name, String function, NodeData[] children) {
        this.name = name;
        this.function = function;
        this.setChildren(children);
        this.isInitData = name.equals(INIT_NODE_NAME);
    }

    public void addChild(NodeData nodeData, int index) {
    }

    public void addChild(NodeData nodeData) {
        if (!nodeData.equals(this) && !this.children.contains(nodeData)) {
            this.children.add(nodeData);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeData nodeData = (NodeData)o;
        return this.name.equals(nodeData.name) && this.function.equals(nodeData.function) && this.children.equals(nodeData.children);
    }

    public String getName() {
        return this.name;
    }

    public String getFunction() {
        return this.function;
    }

    public abstract NodeData[] getChildren();

    public boolean isChild(NodeData nodeData) {
        return this.children.contains(nodeData);
    }

    public boolean isInitData() {
        return this.isInitData;
    }

    public void removeChild(NodeData nodeData) {
        if (this.isChild(nodeData)) {
            this.children.remove(nodeData);
        }
    }

    public void setChildren(NodeData[] children) {
        this.children = new ArrayList<NodeData>();
        Collections.addAll(this.children, children);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public JsonObject toJSON() {
        String name = this.getName();
        if (name.length() == 0) {
            throw new InvalidParameterException("This node has no name. How did you even manage to do that?");
        }
        String function = this.getFunction();
        JsonObject dialogueObject = new JsonObject();
        dialogueObject.addProperty("name", name);
        dialogueObject.addProperty("function", function);
        JsonArray childrenAsObjects = new JsonArray();
        for (NodeData child : this.getChildren()) {
            childrenAsObjects.add((JsonElement)child.toJSON());
        }
        dialogueObject.add("children", (JsonElement)childrenAsObjects);
        return dialogueObject;
    }

    public String toString() {
        return "NodeData{name='" + this.name + "', children=" + this.children + "}";
    }
}

