/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.core.quests;

import com.google.gson.JsonObject;
import flash.npcmod.Main;
import flash.npcmod.capability.quests.IQuestCapability;
import flash.npcmod.capability.quests.QuestCapabilityProvider;
import flash.npcmod.core.FileUtil;
import flash.npcmod.core.quests.Quest;
import flash.npcmod.core.quests.QuestInstance;
import flash.npcmod.network.PacketDispatcher;
import flash.npcmod.network.packets.server.SSendQuestInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.io.FilenameUtils;

public class CommonQuestUtil {
    public static final List<Quest> QUESTS = new ArrayList<Quest>();
    public static final List<QuestInstance> QUEST_INSTANCE_LIST = new ArrayList<QuestInstance>();
    private static Writer fw;

    public static void loadAllQuests() {
        QUESTS.clear();
        Object path = "flashnpcs/quests";
        if (FileUtil.shouldGetFromWorld()) {
            path = FileUtil.getWorldDirectory() + "/" + (String)path;
        }
        File directory = FileUtil.getOrCreateDirectory((String)path);
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) continue;
            CommonQuestUtil.loadQuestFile(FilenameUtils.removeExtension((String)file.getName()));
        }
    }

    public static void syncPlayerQuests(ServerPlayer player) {
        if (player != null && player.m_6084_()) {
            IQuestCapability capability = QuestCapabilityProvider.getCapability((Player)player);
            ArrayList<QuestInstance> acceptedQuests = capability.getAcceptedQuests();
            ArrayList markedForRemoval = new ArrayList();
            acceptedQuests.forEach(questInstance -> {
                JsonObject quest = CommonQuestUtil.loadQuestAsJson(questInstance.getQuest().getName());
                if (quest != null) {
                    PacketDispatcher.sendTo(new SSendQuestInfo(questInstance.getQuest().getName(), quest.toString()), (Player)player);
                } else {
                    markedForRemoval.add(questInstance);
                }
            });
            for (QuestInstance instance : markedForRemoval) {
                capability.abandonQuest(instance);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void buildQuest(String name, String jsonText) {
        CommonQuestUtil.removeQuest(name);
        try {
            File jsonFile = FileUtil.getJsonFileForWriting("quests", name);
            JsonObject jsonObject = (JsonObject)FileUtil.GSON.fromJson(jsonText, JsonObject.class);
            fw = new OutputStreamWriter((OutputStream)new FileOutputStream(jsonFile), StandardCharsets.UTF_8);
            fw.write(jsonObject.toString());
        }
        catch (Exception e) {
            Main.LOGGER.warn("Could not build quest file " + name + ".json");
        }
        finally {
            try {
                fw.flush();
                fw.close();
            }
            catch (IOException e) {
                Main.LOGGER.warn("Could not close FileWriter for quest file " + name + ".json");
            }
        }
    }

    public static boolean deleteQuest(String name) {
        try {
            File file = FileUtil.getJsonFileForWriting("quests", name);
            if (file != null) {
                CommonQuestUtil.removeQuest(name);
                return file.delete();
            }
        }
        catch (Exception e) {
            Main.LOGGER.warn("Error deleting quest " + name);
        }
        return false;
    }

    @Nullable
    public static Quest fromName(String name) {
        for (Quest quest : QUESTS) {
            if (!quest.getName().equals(name)) continue;
            return quest;
        }
        return CommonQuestUtil.loadQuestFile(name);
    }

    @Nullable
    public static JsonObject loadQuestAsJson(String name) {
        Quest fromName = CommonQuestUtil.fromName(name);
        if (fromName != null) {
            return fromName.toJson();
        }
        return null;
    }

    @Nullable
    public static Quest loadQuestFile(String name) {
        try {
            InputStreamReader is = new InputStreamReader((InputStream)new FileInputStream(FileUtil.getJsonFile("quests", name)), StandardCharsets.UTF_8);
            JsonObject object = (JsonObject)FileUtil.GSON.fromJson((Reader)is, JsonObject.class);
            is.close();
            Quest quest = Quest.fromJson(object);
            CommonQuestUtil.removeQuest(name);
            QUESTS.add(quest);
            return quest;
        }
        catch (Exception e) {
            if (!name.isEmpty()) {
                Main.LOGGER.warn("Could not find quests file " + name + ".json");
            }
            return null;
        }
    }

    private static void removeQuest(String name) {
        int toRemoveIndex = -1;
        for (int i = 0; i < QUESTS.size(); ++i) {
            if (!QUESTS.get(i).getName().equals(name)) continue;
            toRemoveIndex = i;
            break;
        }
        if (toRemoveIndex != -1) {
            QUESTS.remove(toRemoveIndex);
        }
    }
}

