/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.core.quests;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import flash.npcmod.capability.quests.QuestCapabilityProvider;
import flash.npcmod.config.ConfigHolder;
import flash.npcmod.core.ItemUtil;
import flash.npcmod.core.quests.CommonQuestUtil;
import flash.npcmod.core.quests.QuestInstance;
import flash.npcmod.core.quests.QuestObjective;
import flash.npcmod.core.quests.QuestObjectiveTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.server.ServerLifecycleHooks;

public class Quest {
    private final String name;
    private final String displayName;
    private final List<QuestObjective> objectives;
    private final int xpReward;
    private List<ItemStack> itemRewards;
    private final boolean repeatable;
    private final List<String> runOnComplete;

    public Quest(String name, String displayName, List<QuestObjective> objectives) {
        this(name, displayName, objectives, 0);
    }

    public Quest(String name, String displayName, List<QuestObjective> objectives, int xpReward) {
        this(name, displayName, objectives, xpReward, new ArrayList<ItemStack>(), true, new ArrayList<String>());
    }

    public Quest(String name, String displayName, List<QuestObjective> objectives, List<ItemStack> itemRewards) {
        this(name, displayName, objectives, 0, itemRewards, true, new ArrayList<String>());
    }

    public Quest(String name, String displayName, List<QuestObjective> objectives, int xpReward, List<ItemStack> itemRewards, boolean repeatable, List<String> runOnComplete) {
        this.name = name;
        this.displayName = displayName;
        this.objectives = objectives;
        this.xpReward = xpReward;
        this.itemRewards = itemRewards;
        this.repeatable = repeatable;
        this.runOnComplete = runOnComplete;
        objectives.forEach(objective -> objective.setQuest(this));
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<QuestObjective> getObjectives() {
        return this.objectives;
    }

    public int getXpReward() {
        return this.xpReward;
    }

    public List<ItemStack> getItemRewards() {
        return this.itemRewards;
    }

    public void setItemRewards(List<ItemStack> itemRewards) {
        this.itemRewards = itemRewards;
    }

    public boolean isRepeatable() {
        return this.repeatable;
    }

    public List<String> getRunOnComplete() {
        return this.runOnComplete;
    }

    public boolean canComplete() {
        for (QuestObjective objective : this.objectives) {
            if (objective.isOptional() || objective.isComplete()) continue;
            return false;
        }
        return true;
    }

    public void complete(Player player, UUID pickedUpFrom, String pickedUpFromName, QuestInstance.TurnInType turnInType) {
        if (!this.canComplete()) {
            return;
        }
        for (QuestObjective objective : this.objectives) {
            if (!(objective instanceof QuestObjectiveTypes.GatherObjective)) continue;
            ItemUtil.takeStack(player, (ItemStack)objective.getObjective(), objective.getAmount());
        }
        player.m_6756_(this.xpReward);
        if (!this.itemRewards.isEmpty()) {
            for (ItemStack stack : this.itemRewards) {
                ItemUtil.giveStack(player, stack);
            }
        }
        for (String command : this.runOnComplete) {
            Quest quest;
            if (command.startsWith("/")) {
                if (player.f_19853_.f_46443_ || ConfigHolder.COMMON.isInvalidCommand(command)) continue;
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                server.m_129892_().m_82117_(server.m_129893_().m_81324_(), command.replaceAll("@p", player.m_7755_().getString()));
                continue;
            }
            if (!command.startsWith("acceptQuest:") || (quest = CommonQuestUtil.fromName(command.substring(12))) == null) continue;
            QuestCapabilityProvider.getCapability(player).acceptQuest(new QuestInstance(quest, pickedUpFrom, pickedUpFromName, turnInType, player));
        }
    }

    @Nullable
    public static QuestObjective getObjectiveFromName(Quest quest, String name) {
        for (QuestObjective questObjective : quest.objectives) {
            if (!questObjective.getName().equals(name)) continue;
            return questObjective;
        }
        return null;
    }

    public static Quest fromJson(JsonObject object) {
        String name = object.get("name").getAsString();
        String displayName = object.get("displayName").getAsString();
        ArrayList<QuestObjective> objectives = new ArrayList<QuestObjective>();
        if (object.has("objectives")) {
            JsonArray objectivesArray = object.getAsJsonArray("objectives");
            for (int i = 0; i < objectivesArray.size(); ++i) {
                JsonObject objectiveObject = objectivesArray.get(i).getAsJsonObject();
                objectives.add(QuestObjective.fromJson(objectiveObject));
            }
        }
        int xpReward = 0;
        if (object.has("xpReward")) {
            xpReward = object.get("xpReward").getAsInt();
        }
        ArrayList<ItemStack> itemRewards = new ArrayList<ItemStack>();
        if (object.has("itemRewards")) {
            JsonArray itemsArray = object.getAsJsonArray("itemRewards");
            for (int i = 0; i < itemsArray.size(); ++i) {
                JsonObject itemObject = itemsArray.get(i).getAsJsonObject();
                ItemStack item = ItemUtil.stackFromString(itemObject.get("stack").getAsString());
                item.m_41764_(itemObject.get("count").getAsInt());
                itemRewards.add(item);
            }
        }
        boolean repeatable = true;
        if (object.has("repeatable")) {
            repeatable = object.get("repeatable").getAsBoolean();
        }
        ArrayList<String> runOnComplete = new ArrayList<String>();
        if (object.has("runOnComplete")) {
            JsonArray runArray = object.getAsJsonArray("runOnComplete");
            for (int i = 0; i < runArray.size(); ++i) {
                runOnComplete.add(runArray.get(i).getAsString());
            }
        }
        return new Quest(name, displayName, objectives, xpReward, itemRewards, repeatable, runOnComplete);
    }

    public JsonObject toJson() {
        JsonObject object = new JsonObject();
        object.addProperty("name", this.getName());
        object.addProperty("displayName", this.getDisplayName());
        JsonArray objectives = new JsonArray();
        for (QuestObjective questObjective : this.getObjectives()) {
            objectives.add((JsonElement)questObjective.toJson());
        }
        if (!objectives.isEmpty()) {
            object.add("objectives", (JsonElement)objectives);
        }
        object.addProperty("xpReward", (Number)this.getXpReward());
        JsonArray itemRewards = new JsonArray();
        for (ItemStack stack : this.getItemRewards()) {
            JsonObject stackObject = new JsonObject();
            stackObject.addProperty("stack", ItemUtil.stackToString(stack));
            stackObject.addProperty("count", (Number)stack.m_41613_());
            itemRewards.add((JsonElement)stackObject);
        }
        if (!itemRewards.isEmpty()) {
            object.add("itemRewards", (JsonElement)itemRewards);
        }
        if (!this.isRepeatable()) {
            object.addProperty("repeatable", Boolean.valueOf(false));
        }
        JsonArray jsonArray = new JsonArray();
        for (String command : this.getRunOnComplete()) {
            jsonArray.add(command);
        }
        if (!jsonArray.isEmpty()) {
            object.add("runOnComplete", (JsonElement)jsonArray);
        }
        return object;
    }

    public Quest copy() {
        ArrayList<QuestObjective> objectives = new ArrayList<QuestObjective>();
        for (QuestObjective objective : this.objectives) {
            objectives.add(objective.copy());
        }
        return new Quest(this.name, this.displayName, objectives, this.xpReward, this.itemRewards, this.repeatable, this.runOnComplete);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Quest quest = (Quest)o;
        return this.name.equals(quest.name);
    }
}

