/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.core.quests;

import flash.npcmod.core.quests.Quest;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Player;

public class QuestInstance {
    private final Quest quest;
    private final UUID pickedUpFrom;
    private final String pickedUpFromName;
    private final TurnInType turnInType;
    @Nullable
    private Player player;

    public QuestInstance(Quest quest, UUID pickedUpFrom, String pickedUpFromName, TurnInType turnInType) {
        this(quest, pickedUpFrom, pickedUpFromName, turnInType, null);
    }

    public QuestInstance(Quest quest, UUID pickedUpFrom, String pickedUpFromName, TurnInType turnInType, @Nullable Player player) {
        this(quest, pickedUpFrom, pickedUpFromName, turnInType, player, true);
    }

    public QuestInstance(Quest quest, UUID pickedUpFrom, String pickedUpFromName, TurnInType turnInType, @Nullable Player player, boolean copy) {
        this.quest = copy ? quest.copy() : quest;
        this.pickedUpFrom = pickedUpFrom;
        this.pickedUpFromName = pickedUpFromName;
        this.turnInType = turnInType;
        this.player = player;
    }

    public Quest getQuest() {
        return this.quest;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public UUID getPickedUpFrom() {
        return this.pickedUpFrom;
    }

    public String getPickedUpFromName() {
        return this.pickedUpFromName;
    }

    public TurnInType getTurnInType() {
        return this.turnInType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuestInstance that = (QuestInstance)o;
        if (this.player != null && that.player == null || this.player == null && that.player != null) {
            return false;
        }
        boolean playerNamesMatch = true;
        if (this.player != null && that.player != null) {
            playerNamesMatch = this.player.m_7755_().getString().equals(that.player.m_7755_().getString());
        }
        return playerNamesMatch && this.quest.getName().equals(that.quest.getName()) && this.pickedUpFrom.equals(that.pickedUpFrom) && this.turnInType.equals((Object)that.turnInType);
    }

    public static enum TurnInType {
        QuestGiver,
        NpcByUuid,
        AutoTurnIn;

    }
}

