/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.core.quests;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import flash.npcmod.config.ConfigHolder;
import flash.npcmod.core.ItemUtil;
import flash.npcmod.core.pathing.Path;
import flash.npcmod.core.quests.Quest;
import flash.npcmod.core.quests.QuestObjectiveTypes;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IExtensibleEnum;
import net.minecraftforge.server.ServerLifecycleHooks;

public abstract class QuestObjective {
    private int id;
    private Quest quest;
    private String name;
    private ObjectiveType type;
    private int amount;
    private int progress;
    private boolean hidden;
    private boolean completed;
    private boolean forceComplete;
    private boolean displayProgress;
    private boolean optional;
    private List<String> onComplete;
    private boolean onCompleteRan;

    public QuestObjective(int id, String name, ObjectiveType type, int amount) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.amount = amount;
        this.displayProgress = true;
    }

    public int getId() {
        return this.id;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setId(int id) {
        this.id = id;
    }

    public Quest getQuest() {
        return this.quest;
    }

    public void setQuest(Quest quest) {
        this.quest = quest;
    }

    public String getName() {
        return this.name;
    }

    public ObjectiveType getType() {
        return this.type;
    }

    public int getAmount() {
        return this.amount;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = Mth.m_14045_((int)progress, (int)0, (int)this.amount);
    }

    public void progress(int amount) {
        this.progress = Mth.m_14045_((int)(this.progress + amount), (int)0, (int)this.amount);
    }

    public boolean isComplete() {
        if (this.forceComplete && !this.completed) {
            this.progress = this.amount;
        }
        this.completed = this.progress == this.amount;
        return this.completed;
    }

    public List<String> getRunOnComplete() {
        return this.onComplete;
    }

    public void setRunOnComplete(List<String> runOnComplete) {
        this.onComplete = runOnComplete;
    }

    public void onComplete(Player playerEntity) {
        if (this.onComplete != null && this.isComplete()) {
            for (String s : this.onComplete) {
                QuestObjective objective;
                String objectiveName;
                if (s.startsWith("hide:")) {
                    objectiveName = s.substring(5);
                    if (objectiveName.isEmpty() || (objective = Quest.getObjectiveFromName(this.quest, objectiveName)) == null) continue;
                    objective.setHidden(true);
                    continue;
                }
                if (s.startsWith("unhide:")) {
                    objectiveName = s.substring(7);
                    if (objectiveName.isEmpty() || (objective = Quest.getObjectiveFromName(this.quest, objectiveName)) == null) continue;
                    objective.setHidden(false);
                    continue;
                }
                if (s.startsWith("forceComplete:")) {
                    objectiveName = s.substring(14);
                    if (objectiveName.isEmpty() || (objective = Quest.getObjectiveFromName(this.quest, objectiveName)) == null) continue;
                    objective.forceComplete();
                    continue;
                }
                if (!s.startsWith("/") || playerEntity.f_19853_.f_46443_ || this.onCompleteRan || ConfigHolder.COMMON.isInvalidCommand(s)) continue;
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                server.m_129892_().m_82117_(server.m_129893_().m_81324_(), s.replaceAll("@p", playerEntity.m_7755_().getString()));
            }
            if (!this.onCompleteRan) {
                playerEntity.m_5661_((Component)new TranslatableComponent("msg.flashnpcs.objectivecomplete").m_130940_(ChatFormatting.YELLOW), true);
            }
            this.onCompleteRan = true;
        }
    }

    public void setOnCompleteRan(boolean b) {
        this.onCompleteRan = b;
    }

    public boolean getOnCompleteRan() {
        return this.onCompleteRan;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean b) {
        this.hidden = b;
    }

    public void forceComplete() {
        this.forceComplete = true;
    }

    public boolean isForceComplete() {
        return this.forceComplete;
    }

    public boolean shouldDisplayProgress() {
        return this.displayProgress;
    }

    public void setShouldDisplayProgress(boolean b) {
        this.displayProgress = b;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean b) {
        this.optional = b;
    }

    public abstract <T> T getObjective();

    @Nullable
    public <T> T getSecondaryObjective() {
        return null;
    }

    public abstract String primaryToString();

    @Nullable
    public String secondaryToString() {
        return null;
    }

    public abstract QuestObjective copy();

    public void copyTo(QuestObjective to) {
        to.setQuest(this.getQuest());
        to.setHidden(this.isHidden());
        to.setShouldDisplayProgress(this.shouldDisplayProgress());
        to.setProgress(this.getProgress());
        to.setOptional(this.isOptional());
        to.onCompleteRan = this.onCompleteRan;
        to.id = this.id;
        if (this.isForceComplete()) {
            to.forceComplete();
        }
        to.setRunOnComplete(this.getRunOnComplete());
    }

    public QuestObjective setItemStackObjective(ItemStack itemStack) {
        if (itemStack == null || itemStack.m_41619_()) {
            return this;
        }
        QuestObjective questObjective = this;
        if (this.type.equals((Object)ObjectiveType.Gather)) {
            questObjective = new QuestObjectiveTypes.GatherObjective(this.id, this.name, itemStack, this.amount);
        } else if (this.type.equals((Object)ObjectiveType.DeliverToEntity)) {
            questObjective = new QuestObjectiveTypes.DeliverToEntityObjective(this.id, this.name, itemStack, (String)this.getSecondaryObjective(), this.amount);
        } else if (this.type.equals((Object)ObjectiveType.DeliverToLocation)) {
            questObjective = new QuestObjectiveTypes.DeliverToLocationObjective(this.id, this.name, itemStack, (BlockPos[])this.getSecondaryObjective(), this.amount);
        } else if (this.type.equals((Object)ObjectiveType.UseOnEntity)) {
            questObjective = new QuestObjectiveTypes.UseOnEntityObjective(this.id, this.name, itemStack, (String)this.getSecondaryObjective(), this.amount);
        } else if (this.type.equals((Object)ObjectiveType.UseOnBlock)) {
            questObjective = new QuestObjectiveTypes.UseOnBlockObjective(this.id, this.name, itemStack, (BlockState)this.getSecondaryObjective(), this.amount);
        } else if (this.type.equals((Object)ObjectiveType.Use)) {
            questObjective = new QuestObjectiveTypes.UseObjective(this.id, this.name, itemStack, this.amount);
        } else if (this.type.equals((Object)ObjectiveType.CraftItem)) {
            questObjective = new QuestObjectiveTypes.CraftItemObjective(this.id, this.name, itemStack, this.amount);
        } else if (this.type.equals((Object)ObjectiveType.SmeltItem)) {
            questObjective = new QuestObjectiveTypes.SmeltItemObjective(this.id, this.name, itemStack, this.amount);
        }
        if (questObjective != this) {
            questObjective.setQuest(this.getQuest());
            questObjective.setHidden(this.isHidden());
            questObjective.setOptional(this.isOptional());
            questObjective.setShouldDisplayProgress(this.shouldDisplayProgress());
            questObjective.setRunOnComplete(this.getRunOnComplete());
        }
        return questObjective;
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("index", (Number)this.id);
        jsonObject.addProperty("name", this.getName());
        jsonObject.addProperty("type", (Number)this.getType().ordinal());
        jsonObject.addProperty("amount", (Number)this.getAmount());
        jsonObject.addProperty("primaryObjective", this.primaryToString());
        if (this.getSecondaryObjective() != null && !this.secondaryToString().isEmpty()) {
            jsonObject.addProperty("secondaryObjective", this.secondaryToString());
        }
        if (this.isHidden()) {
            jsonObject.addProperty("isHidden", Boolean.valueOf(true));
        }
        if (this.isOptional()) {
            jsonObject.addProperty("isOptional", Boolean.valueOf(true));
        }
        if (!this.shouldDisplayProgress()) {
            jsonObject.addProperty("displayProgress", Boolean.valueOf(false));
        }
        if (this.getRunOnComplete() != null && !this.getRunOnComplete().isEmpty()) {
            JsonArray runOnCompleteArray = new JsonArray();
            for (String s : this.getRunOnComplete()) {
                runOnCompleteArray.add(s);
            }
            jsonObject.add("objectiveRunOnComplete", (JsonElement)runOnCompleteArray);
        }
        return jsonObject;
    }

    public static QuestObjective fromJson(JsonObject jsonObject) {
        QuestObjective questObjective;
        int id = jsonObject.get("index").getAsInt();
        String objectiveName = jsonObject.get("name").getAsString();
        int type = Mth.m_14045_((int)jsonObject.get("type").getAsInt(), (int)0, (int)ObjectiveType.values().length);
        ObjectiveType objectiveType = ObjectiveType.values()[type];
        int objectiveAmount = jsonObject.get("amount").getAsInt();
        String primaryObjective = jsonObject.get("primaryObjective").getAsString();
        String secondaryObjective = "";
        if (jsonObject.has("secondaryObjective")) {
            secondaryObjective = jsonObject.get("secondaryObjective").getAsString();
        }
        switch (objectiveType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case Gather: {
                QuestObjective questObjective2 = new QuestObjectiveTypes.GatherObjective(id, objectiveName, ItemUtil.stackFromString(primaryObjective), objectiveAmount);
                break;
            }
            case Kill: {
                QuestObjective questObjective2 = new QuestObjectiveTypes.KillObjective(id, objectiveName, primaryObjective, objectiveAmount);
                break;
            }
            case DeliverToEntity: {
                QuestObjective questObjective2 = new QuestObjectiveTypes.DeliverToEntityObjective(id, objectiveName, ItemUtil.stackFromString(primaryObjective), secondaryObjective, objectiveAmount);
                break;
            }
            case DeliverToLocation: {
                QuestObjective questObjective2 = new QuestObjectiveTypes.DeliverToLocationObjective(id, objectiveName, ItemUtil.stackFromString(primaryObjective), QuestObjectiveTypes.areaFromString(secondaryObjective), objectiveAmount);
                break;
            }
            case Escort: {
                QuestObjective questObjective2 = new QuestObjectiveTypes.EscortObjective(id, objectiveName, primaryObjective, Path.fromString(secondaryObjective));
                break;
            }
            case Talk: {
                QuestObjective questObjective2 = new QuestObjectiveTypes.TalkObjective(id, objectiveName, primaryObjective, secondaryObjective);
                break;
            }
            case Find: {
                QuestObjective questObjective2 = new QuestObjectiveTypes.FindObjective(id, objectiveName, QuestObjectiveTypes.areaFromString(primaryObjective));
                break;
            }
            case UseOnEntity: {
                QuestObjective questObjective2 = new QuestObjectiveTypes.UseOnEntityObjective(id, objectiveName, ItemUtil.stackFromString(primaryObjective), secondaryObjective, objectiveAmount);
                break;
            }
            case UseOnBlock: {
                QuestObjective questObjective2 = new QuestObjectiveTypes.UseOnBlockObjective(id, objectiveName, ItemUtil.stackFromString(primaryObjective), QuestObjectiveTypes.blockStateFromString(secondaryObjective), objectiveAmount);
                break;
            }
            case Use: {
                QuestObjective questObjective2 = new QuestObjectiveTypes.UseObjective(id, objectiveName, ItemUtil.stackFromString(primaryObjective), objectiveAmount);
                break;
            }
            case Scoreboard: {
                QuestObjective questObjective2 = new QuestObjectiveTypes.ScoreboardObjective(id, objectiveName, primaryObjective, objectiveAmount);
                break;
            }
            case CraftItem: {
                QuestObjective questObjective2 = new QuestObjectiveTypes.CraftItemObjective(id, objectiveName, ItemUtil.stackFromString(primaryObjective), objectiveAmount);
                break;
            }
            case SmeltItem: {
                QuestObjective questObjective2 = questObjective = new QuestObjectiveTypes.SmeltItemObjective(id, objectiveName, ItemUtil.stackFromString(primaryObjective), objectiveAmount);
            }
        }
        if (jsonObject.has("isHidden")) {
            questObjective.setHidden(jsonObject.get("isHidden").getAsBoolean());
        }
        if (jsonObject.has("isOptional")) {
            questObjective.setOptional(jsonObject.get("isOptional").getAsBoolean());
        }
        if (jsonObject.has("displayProgress")) {
            questObjective.setShouldDisplayProgress(jsonObject.get("displayProgress").getAsBoolean());
        }
        if (jsonObject.has("objectiveRunOnComplete")) {
            JsonArray runOnCompleteArray = jsonObject.getAsJsonArray("objectiveRunOnComplete");
            ArrayList<String> runOnCompleteList = new ArrayList<String>();
            for (int j = 0; j < runOnCompleteArray.size(); ++j) {
                String s = runOnCompleteArray.get(j).getAsString();
                runOnCompleteList.add(s);
            }
            questObjective.setRunOnComplete(runOnCompleteList);
        }
        return questObjective;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuestObjective that = (QuestObjective)o;
        if (this.quest != null && that.quest == null || this.quest == null && that.quest != null || this.quest != null && that.quest != null && !this.quest.getName().equals(that.quest.getName())) {
            return false;
        }
        if (this.getSecondaryObjective() != null && that.getSecondaryObjective() == null || this.getSecondaryObjective() == null && that.getSecondaryObjective() != null || this.getSecondaryObjective() != null && that.getSecondaryObjective() != null && !this.secondaryToString().equals(that.secondaryToString())) {
            return false;
        }
        return this.id == that.id && this.name.equals(that.name) && this.isComplete() == that.isComplete() && this.isHidden() == that.isHidden() && this.primaryToString().equals(that.primaryToString());
    }

    public static enum ObjectiveType implements IExtensibleEnum
    {
        Gather,
        Kill,
        DeliverToEntity,
        DeliverToLocation,
        Escort,
        Talk,
        Find,
        UseOnEntity,
        UseOnBlock,
        Use,
        Scoreboard,
        CraftItem,
        SmeltItem;


        public static ObjectiveType create(String name) {
            throw new IllegalStateException("Enum not extended");
        }
    }
}

