/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.core.quests;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import flash.npcmod.Main;
import flash.npcmod.core.ItemUtil;
import flash.npcmod.core.pathing.Path;
import flash.npcmod.core.quests.QuestObjective;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class QuestObjectiveTypes {
    public static String entityToString(LivingEntity livingEntity) {
        return livingEntity.m_20078_();
    }

    public static String areaToString(BlockPos[] area) {
        StringBuilder sb = new StringBuilder();
        sb.append(area[0].m_123341_()).append(";").append(area[0].m_123342_()).append(";").append(area[0].m_123343_()).append(",");
        sb.append(area[1].m_123341_()).append(";").append(area[1].m_123342_()).append(";").append(area[1].m_123343_());
        return sb.toString();
    }

    public static LivingEntity entityFromString(String s) {
        String[] parts = s.split(":");
        return (LivingEntity)((EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(parts[0], parts[1]))).m_20615_(Main.PROXY.getWorld());
    }

    public static BlockPos[] areaFromString(String s) {
        BlockPos corner2Pos;
        BlockPos corner1Pos;
        String[] corners = s.split(",");
        if (corners.length != 2) {
            return new BlockPos[]{BlockPos.f_121853_, BlockPos.f_121853_};
        }
        String[] corner1 = corners[0].split(";");
        String[] corner2 = corners[1].split(";");
        try {
            corner1Pos = new BlockPos(Integer.parseInt(corner1[0]), Integer.parseInt(corner1[1]), Integer.parseInt(corner1[2]));
        }
        catch (Exception e) {
            corner1Pos = BlockPos.f_121853_;
        }
        try {
            corner2Pos = new BlockPos(Integer.parseInt(corner2[0]), Integer.parseInt(corner2[1]), Integer.parseInt(corner2[2]));
        }
        catch (Exception e) {
            corner2Pos = BlockPos.f_121853_;
        }
        return new BlockPos[]{corner1Pos, corner2Pos};
    }

    public static BlockState blockStateFromString(String s) {
        try {
            return BlockStateArgument.m_116120_().parse(new StringReader(s)).m_114669_();
        }
        catch (CommandSyntaxException e) {
            return Blocks.f_50016_.m_49966_();
        }
    }

    private static Pair<String, CompoundTag> getEntityObjectiveFromString(String s) {
        if (s.contains("::")) {
            String[] obj = s.split("::");
            CompoundTag tag = new CompoundTag();
            try {
                tag = new TagParser(new StringReader(obj[1])).m_129373_();
                if (tag.m_128441_("id")) {
                    tag.m_128473_("id");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new Pair((Object)obj[0], (Object)tag);
        }
        return new Pair((Object)s, (Object)new CompoundTag());
    }

    public static class SmeltItemObjective
    extends QuestObjective {
        private final ItemStack itemStack;

        public SmeltItemObjective(int id, String name, ItemStack itemStack, int amount) {
            super(id, name, QuestObjective.ObjectiveType.SmeltItem, amount);
            this.itemStack = itemStack;
        }

        public ItemStack getObjective() {
            return this.itemStack;
        }

        @Override
        public String primaryToString() {
            return ItemUtil.stackToString(this.itemStack);
        }

        @Override
        public SmeltItemObjective copy() {
            SmeltItemObjective copy = new SmeltItemObjective(this.getId(), this.getName(), this.itemStack, this.getAmount());
            this.copyTo(copy);
            return copy;
        }
    }

    public static class CraftItemObjective
    extends QuestObjective {
        private final ItemStack itemStack;

        public CraftItemObjective(int id, String name, ItemStack itemStack, int amount) {
            super(id, name, QuestObjective.ObjectiveType.CraftItem, amount);
            this.itemStack = itemStack;
        }

        public ItemStack getObjective() {
            return this.itemStack;
        }

        @Override
        public String primaryToString() {
            return ItemUtil.stackToString(this.itemStack);
        }

        @Override
        public CraftItemObjective copy() {
            CraftItemObjective copy = new CraftItemObjective(this.getId(), this.getName(), this.itemStack, this.getAmount());
            this.copyTo(copy);
            return copy;
        }
    }

    public static class ScoreboardObjective
    extends QuestObjective {
        private final String objectiveName;

        public ScoreboardObjective(int id, String name, String objectiveName, int amount) {
            super(id, name, QuestObjective.ObjectiveType.Scoreboard, amount);
            this.objectiveName = objectiveName;
        }

        public String getObjective() {
            return this.objectiveName;
        }

        @Override
        public String primaryToString() {
            return this.objectiveName;
        }

        @Override
        public ScoreboardObjective copy() {
            ScoreboardObjective copy = new ScoreboardObjective(this.getId(), this.getName(), this.objectiveName, this.getAmount());
            this.copyTo(copy);
            return copy;
        }
    }

    public static class UseObjective
    extends QuestObjective {
        private final ItemStack itemStack;

        public UseObjective(int id, String name, ItemStack itemStack, int amount) {
            super(id, name, QuestObjective.ObjectiveType.Use, amount);
            this.itemStack = itemStack;
        }

        public ItemStack getObjective() {
            return this.itemStack;
        }

        @Override
        public String primaryToString() {
            return ItemUtil.stackToString(this.itemStack);
        }

        @Override
        public UseObjective copy() {
            UseObjective copy = new UseObjective(this.getId(), this.getName(), this.itemStack, this.getAmount());
            this.copyTo(copy);
            return copy;
        }
    }

    public static class UseOnBlockObjective
    extends QuestObjective {
        private final ItemStack itemStack;
        private final BlockState blockState;

        public UseOnBlockObjective(int id, String name, ItemStack itemStack, BlockState blockState, int amount) {
            super(id, name, QuestObjective.ObjectiveType.UseOnBlock, amount);
            this.itemStack = itemStack;
            this.blockState = blockState;
        }

        public ItemStack getObjective() {
            return this.itemStack;
        }

        public BlockState getSecondaryObjective() {
            return this.blockState;
        }

        @Override
        public String primaryToString() {
            return ItemUtil.stackToString(this.itemStack);
        }

        @Override
        public String secondaryToString() {
            String block = this.blockState.toString();
            return block.substring(6).replaceFirst("}", "");
        }

        @Override
        public UseOnBlockObjective copy() {
            UseOnBlockObjective copy = new UseOnBlockObjective(this.getId(), this.getName(), this.itemStack, this.blockState, this.getAmount());
            this.copyTo(copy);
            return copy;
        }
    }

    public static class UseOnEntityObjective
    extends QuestObjective {
        private final ItemStack itemStack;
        private final String entityObjective;
        private final String livingEntityKey;
        private final CompoundTag livingEntityTag;

        public UseOnEntityObjective(int id, String name, ItemStack itemStack, String entityObjective, int amount) {
            super(id, name, QuestObjective.ObjectiveType.UseOnEntity, amount);
            this.itemStack = itemStack;
            this.entityObjective = entityObjective;
            Pair<String, CompoundTag> keyAndTagPair = QuestObjectiveTypes.getEntityObjectiveFromString(entityObjective);
            this.livingEntityKey = (String)keyAndTagPair.getFirst();
            this.livingEntityTag = (CompoundTag)keyAndTagPair.getSecond();
        }

        public ItemStack getObjective() {
            return this.itemStack;
        }

        public String getSecondaryObjective() {
            return this.entityObjective;
        }

        public String getEntityKey() {
            return this.livingEntityKey;
        }

        public CompoundTag getEntityTag() {
            return this.livingEntityTag;
        }

        @Override
        public String primaryToString() {
            return ItemUtil.stackToString(this.itemStack);
        }

        @Override
        public String secondaryToString() {
            return this.entityObjective;
        }

        @Override
        public UseOnEntityObjective copy() {
            UseOnEntityObjective copy = new UseOnEntityObjective(this.getId(), this.getName(), this.itemStack, this.entityObjective, this.getAmount());
            this.copyTo(copy);
            return copy;
        }
    }

    public static class FindObjective
    extends QuestObjective {
        private final BlockPos[] area;

        public FindObjective(int id, String name, BlockPos[] area) {
            super(id, name, QuestObjective.ObjectiveType.Find, 1);
            this.area = area;
            this.setShouldDisplayProgress(false);
        }

        public BlockPos[] getObjective() {
            return this.area;
        }

        @Override
        public String primaryToString() {
            return QuestObjectiveTypes.areaToString(this.area);
        }

        @Override
        public FindObjective copy() {
            FindObjective copy = new FindObjective(this.getId(), this.getName(), this.area);
            this.copyTo(copy);
            return copy;
        }
    }

    public static class TalkObjective
    extends QuestObjective {
        private final String npcName;
        private final String dialogueNodeName;

        public TalkObjective(int id, String name, String npcName, String dialogueNodeName) {
            super(id, name, QuestObjective.ObjectiveType.Talk, 1);
            this.npcName = npcName;
            this.dialogueNodeName = dialogueNodeName;
            this.setShouldDisplayProgress(false);
        }

        public String getObjective() {
            return this.npcName;
        }

        public String getSecondaryObjective() {
            return this.dialogueNodeName;
        }

        @Override
        public String primaryToString() {
            return this.npcName;
        }

        @Override
        public String secondaryToString() {
            return this.dialogueNodeName;
        }

        @Override
        public TalkObjective copy() {
            TalkObjective copy = new TalkObjective(this.getId(), this.getName(), this.npcName, this.dialogueNodeName);
            this.copyTo(copy);
            return copy;
        }
    }

    public static class EscortObjective
    extends QuestObjective {
        private final String npcName;
        private final Path path;

        public EscortObjective(int id, String name, String npcName, Path path) {
            super(id, name, QuestObjective.ObjectiveType.Escort, 1);
            this.npcName = npcName;
            this.path = path;
            this.setShouldDisplayProgress(false);
        }

        public String getObjective() {
            return this.npcName;
        }

        public Path getSecondaryObjective() {
            return this.path;
        }

        @Override
        public String primaryToString() {
            return this.npcName;
        }

        @Override
        @Nullable
        public String secondaryToString() {
            return this.path.toString();
        }

        @Override
        public EscortObjective copy() {
            EscortObjective copy = new EscortObjective(this.getId(), this.getName(), this.npcName, this.path);
            this.copyTo(copy);
            return copy;
        }
    }

    public static class DeliverToLocationObjective
    extends QuestObjective {
        private final ItemStack itemStack;
        private final BlockPos[] area;

        public DeliverToLocationObjective(int id, String name, ItemStack itemStack, BlockPos[] area, int amount) {
            super(id, name, QuestObjective.ObjectiveType.DeliverToLocation, amount);
            this.itemStack = itemStack;
            this.area = area;
        }

        public ItemStack getObjective() {
            return this.itemStack;
        }

        public BlockPos[] getSecondaryObjective() {
            return this.area;
        }

        @Override
        public String primaryToString() {
            return ItemUtil.stackToString(this.itemStack);
        }

        @Override
        public String secondaryToString() {
            return QuestObjectiveTypes.areaToString(this.area);
        }

        @Override
        public DeliverToLocationObjective copy() {
            DeliverToLocationObjective copy = new DeliverToLocationObjective(this.getId(), this.getName(), this.itemStack, this.area, this.getAmount());
            this.copyTo(copy);
            return copy;
        }
    }

    public static class DeliverToEntityObjective
    extends QuestObjective {
        private final ItemStack itemStack;
        private final String entityObjective;
        private final String livingEntityKey;
        private final CompoundTag livingEntityTag;

        public DeliverToEntityObjective(int id, String name, ItemStack itemStack, String entityObjective, int amount) {
            super(id, name, QuestObjective.ObjectiveType.DeliverToEntity, amount);
            this.itemStack = itemStack;
            this.entityObjective = entityObjective;
            Pair<String, CompoundTag> keyAndTagPair = QuestObjectiveTypes.getEntityObjectiveFromString(entityObjective);
            this.livingEntityKey = (String)keyAndTagPair.getFirst();
            this.livingEntityTag = (CompoundTag)keyAndTagPair.getSecond();
        }

        public ItemStack getObjective() {
            return this.itemStack;
        }

        public String getSecondaryObjective() {
            return this.entityObjective;
        }

        @Override
        public String primaryToString() {
            return ItemUtil.stackToString(this.itemStack);
        }

        @Override
        public String secondaryToString() {
            return this.entityObjective;
        }

        public String getEntityKey() {
            return this.livingEntityKey;
        }

        public CompoundTag getEntityTag() {
            return this.livingEntityTag;
        }

        @Override
        public DeliverToEntityObjective copy() {
            DeliverToEntityObjective copy = new DeliverToEntityObjective(this.getId(), this.getName(), this.itemStack, this.entityObjective, this.getAmount());
            this.copyTo(copy);
            return copy;
        }
    }

    public static class KillObjective
    extends QuestObjective {
        private final String entityObjective;
        private final String livingEntityKey;
        private final CompoundTag livingEntityTag;

        public KillObjective(int id, String name, String entityObjective, int amount) {
            super(id, name, QuestObjective.ObjectiveType.Kill, amount);
            this.entityObjective = entityObjective;
            Pair<String, CompoundTag> keyAndTagPair = QuestObjectiveTypes.getEntityObjectiveFromString(entityObjective);
            this.livingEntityKey = (String)keyAndTagPair.getFirst();
            this.livingEntityTag = (CompoundTag)keyAndTagPair.getSecond();
        }

        public String getObjective() {
            return this.livingEntityKey;
        }

        public String getEntityKey() {
            return this.livingEntityKey;
        }

        public CompoundTag getEntityTag() {
            return this.livingEntityTag;
        }

        @Override
        public String primaryToString() {
            return this.entityObjective;
        }

        @Override
        public KillObjective copy() {
            KillObjective copy = new KillObjective(this.getId(), this.getName(), this.entityObjective, this.getAmount());
            this.copyTo(copy);
            return copy;
        }
    }

    public static class GatherObjective
    extends QuestObjective {
        private final ItemStack itemStack;

        public GatherObjective(int id, String name, ItemStack itemStack, int amount) {
            super(id, name, QuestObjective.ObjectiveType.Gather, amount);
            this.itemStack = itemStack;
        }

        public ItemStack getObjective() {
            return this.itemStack;
        }

        @Override
        public String primaryToString() {
            return ItemUtil.stackToString(this.itemStack);
        }

        @Override
        public GatherObjective copy() {
            GatherObjective copy = new GatherObjective(this.getId(), this.getName(), this.itemStack, this.getAmount());
            this.copyTo(copy);
            return copy;
        }
    }
}

