/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.core.saves;

import com.google.gson.JsonObject;
import flash.npcmod.Main;
import flash.npcmod.config.ConfigHolder;
import flash.npcmod.core.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;

public class NpcSaveUtil {
    public static final int MAX_SAVED_NPCS = ConfigHolder.COMMON.getMaxSavedNpcs();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BuildResult build(String uuid, String npcJson) {
        Writer fw = null;
        JsonObject jsonObject = (JsonObject)FileUtil.GSON.fromJson(npcJson, JsonObject.class);
        String name = jsonObject.get("name").getAsString();
        try {
            File directory = FileUtil.getOrCreateDirectory(FileUtil.getWorldDirectory() + "/flashnpcs/saves/" + uuid);
            String path = "saves/" + uuid;
            try {
                if (directory.listFiles().length + 1 > MAX_SAVED_NPCS) {
                    BuildResult buildResult = BuildResult.TOOMANY;
                    return buildResult;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            jsonObject.addProperty("internalName", name);
            File jsonFile = FileUtil.getJsonFileForWriting(path, name);
            if (jsonFile.exists()) {
                BuildResult buildResult = BuildResult.EXISTS;
                return buildResult;
            }
            fw = new OutputStreamWriter((OutputStream)new FileOutputStream(jsonFile), StandardCharsets.UTF_8);
            fw.write(jsonObject.toString());
            BuildResult buildResult = BuildResult.SUCCESS;
            return buildResult;
        }
        catch (Exception e) {
            Main.LOGGER.warn("Could not build Saved NPC file " + name + ".json");
        }
        finally {
            try {
                if (fw != null) {
                    fw.flush();
                    fw.close();
                } else {
                    Main.LOGGER.debug("Could not close FileWriter for Saved NPC " + name + ".json, fw is null");
                }
            }
            catch (IOException e) {
                Main.LOGGER.warn("Could not close FileWriter for Saved NPC " + name + ".json");
            }
        }
        return BuildResult.FAILED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BuildResult buildGlobal(JsonObject jsonObject) {
        if (!jsonObject.has("internalName")) {
            jsonObject.addProperty("internalName", jsonObject.get("name").getAsString());
        }
        String name = jsonObject.get("internalName").getAsString();
        Writer fw = null;
        try {
            File jsonFile = FileUtil.getFileFromGlobal("saves", name + ".json");
            if (jsonFile.exists()) {
                BuildResult buildResult = BuildResult.EXISTS;
                return buildResult;
            }
            fw = new OutputStreamWriter((OutputStream)new FileOutputStream(jsonFile), StandardCharsets.UTF_8);
            fw.write(jsonObject.toString());
            BuildResult buildResult = BuildResult.SUCCESS;
            return buildResult;
        }
        catch (Exception e) {
            Main.LOGGER.warn("Could not build Saved NPC file " + name + ".json");
        }
        finally {
            try {
                if (fw != null) {
                    fw.flush();
                    fw.close();
                } else {
                    Main.LOGGER.debug("Could not close FileWriter for Saved NPC " + name + ".json, fw is null");
                }
            }
            catch (IOException e) {
                Main.LOGGER.warn("Could not close FileWriter for Saved NPC " + name + ".json");
            }
        }
        return BuildResult.FAILED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean rename(String uuid, String previousName, String newName, boolean isGlobal) {
        Object path = isGlobal ? "saves" : "saves/" + uuid;
        File jsonFile = isGlobal ? FileUtil.getFileFromGlobal((String)path, previousName + ".json") : FileUtil.getJsonFileForWriting((String)path, previousName);
        Writer fw = null;
        if (jsonFile.exists()) {
            try {
                File newFile = isGlobal ? FileUtil.getFileFromGlobal((String)path, newName + ".json") : FileUtil.getJsonFileForWriting((String)path, newName);
                boolean success = jsonFile.renameTo(newFile);
                if (success) {
                    InputStreamReader is = new InputStreamReader((InputStream)new FileInputStream(newFile), StandardCharsets.UTF_8);
                    JsonObject jsonObject = (JsonObject)FileUtil.GSON.fromJson((Reader)is, JsonObject.class);
                    jsonObject.addProperty("internalName", newName);
                    is.close();
                    fw = new OutputStreamWriter((OutputStream)new FileOutputStream(newFile), StandardCharsets.UTF_8);
                    fw.write(jsonObject.toString());
                }
                boolean bl = success;
                return bl;
            }
            catch (Exception e) {
                Main.LOGGER.warn("Could not rename Saved NPC file " + previousName + ".json");
            }
            finally {
                try {
                    if (fw != null) {
                        fw.flush();
                        fw.close();
                    } else {
                        Main.LOGGER.debug("Could not close FileWriter for Saved NPC " + newName + ".json, fw is null");
                    }
                }
                catch (IOException e) {
                    Main.LOGGER.warn("Could not close FileWriter for Saved NPC " + newName + ".json");
                }
            }
        }
        return false;
    }

    public static boolean delete(ServerPlayer sender, String name, boolean isGlobal) {
        File file = isGlobal ? FileUtil.getFileFromGlobal("saves", name + ".json") : FileUtil.getJsonFileForWriting("saves/" + sender.m_20149_(), name);
        return file != null && file.exists() && file.delete();
    }

    public static List<String> loadGlobal() {
        ArrayList<String> savedNpcs = new ArrayList<String>();
        File[] globalFiles = FileUtil.getAllFromGlobal("saves");
        NpcSaveUtil.putFileArrayIntoList(globalFiles, savedNpcs);
        return savedNpcs;
    }

    public static List<String> load(String uuid) {
        ArrayList<String> savedNpcs = new ArrayList<String>();
        File[] worldFiles = FileUtil.getAllFromWorld("saves/" + uuid);
        NpcSaveUtil.putFileArrayIntoList(worldFiles, savedNpcs);
        return savedNpcs;
    }

    private static void putFileArrayIntoList(@Nullable File[] files, List<String> list) {
        if (files != null) {
            for (File file : files) {
                try {
                    InputStreamReader is = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
                    String jsonString = ((JsonObject)FileUtil.GSON.fromJson((Reader)is, JsonObject.class)).toString();
                    list.add(jsonString);
                    is.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static enum BuildResult {
        SUCCESS,
        TOOMANY,
        FAILED,
        EXISTS;

    }
}

