/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.core.trades;

import flash.npcmod.core.ItemUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class TradeOffer {
    private final ItemStack[] buyingStacks;
    private final ItemStack[] sellingStacks;

    public TradeOffer() {
        this(ItemStack.f_41583_, ItemStack.f_41583_, ItemStack.f_41583_, ItemStack.f_41583_, ItemStack.f_41583_, ItemStack.f_41583_);
    }

    public TradeOffer(CompoundTag dataTag) {
        this(ItemStack.m_41712_((CompoundTag)dataTag.m_128469_("buyA")), ItemStack.m_41712_((CompoundTag)dataTag.m_128469_("buyB")), ItemStack.m_41712_((CompoundTag)dataTag.m_128469_("buyC")), ItemStack.m_41712_((CompoundTag)dataTag.m_128469_("sellA")), ItemStack.m_41712_((CompoundTag)dataTag.m_128469_("sellB")), ItemStack.m_41712_((CompoundTag)dataTag.m_128469_("sellC")));
    }

    public TradeOffer(ItemStack buyingFirst, ItemStack buyingSecond, ItemStack buyingThird, ItemStack sellingFirst, ItemStack sellingSecond, ItemStack sellingThird) {
        this(new ItemStack[]{buyingFirst, buyingSecond, buyingThird}, new ItemStack[]{sellingFirst, sellingSecond, sellingThird});
    }

    public TradeOffer(ItemStack[] buyingStacks, ItemStack[] sellingStacks) {
        this.buyingStacks = buyingStacks;
        this.sellingStacks = sellingStacks;
    }

    public ItemStack[] getBuyingStacks() {
        return this.buyingStacks;
    }

    public ItemStack[] getSellingStacks() {
        return this.sellingStacks;
    }

    public void setBuyingStack(int index, ItemStack stack) {
        if (index >= 0 && index <= 2) {
            this.buyingStacks[index] = stack;
        }
    }

    public void setSellingStack(int index, ItemStack stack) {
        if (index >= 0 && index <= 2) {
            this.sellingStacks[index] = stack;
        }
    }

    public CompoundTag write() {
        CompoundTag compoundnbt = new CompoundTag();
        compoundnbt.m_128365_("buyA", (Tag)this.buyingStacks[0].m_41739_(new CompoundTag()));
        compoundnbt.m_128365_("buyB", (Tag)this.buyingStacks[1].m_41739_(new CompoundTag()));
        compoundnbt.m_128365_("buyC", (Tag)this.buyingStacks[2].m_41739_(new CompoundTag()));
        compoundnbt.m_128365_("sellA", (Tag)this.sellingStacks[0].m_41739_(new CompoundTag()));
        compoundnbt.m_128365_("sellB", (Tag)this.sellingStacks[1].m_41739_(new CompoundTag()));
        compoundnbt.m_128365_("sellC", (Tag)this.sellingStacks[2].m_41739_(new CompoundTag()));
        return compoundnbt;
    }

    public boolean canDoTransaction(Player sender) {
        for (ItemStack stack : this.buyingStacks) {
            if (ItemUtil.hasAmount(sender, stack)) continue;
            return false;
        }
        return true;
    }

    public void doTransaction(ServerPlayer sender) {
        if (this.isEmpty() || !this.canDoTransaction((Player)sender)) {
            return;
        }
        for (ItemStack stack : this.buyingStacks) {
            if (stack.m_41619_()) continue;
            ItemUtil.takeStack((Player)sender, stack);
        }
        for (ItemStack stack : this.sellingStacks) {
            if (stack.m_41619_()) continue;
            ItemUtil.giveStack((Player)sender, stack);
        }
    }

    public boolean equals(Object o) {
        int i;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TradeOffer that = (TradeOffer)o;
        if (this.buyingStacks.length != that.buyingStacks.length || this.sellingStacks.length != that.sellingStacks.length) {
            return false;
        }
        for (i = 0; i < this.buyingStacks.length; ++i) {
            if (ItemUtil.matches(this.buyingStacks[i], that.buyingStacks[i])) continue;
            return false;
        }
        for (i = 0; i < this.sellingStacks.length; ++i) {
            if (ItemUtil.matches(this.sellingStacks[i], that.sellingStacks[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        if (this.buyingStacks.length == 0 || this.sellingStacks.length == 0) {
            return true;
        }
        boolean hasBuyingStack = false;
        boolean hasSellingStack = false;
        for (ItemStack stack : this.buyingStacks) {
            if (stack.m_41619_()) continue;
            hasBuyingStack = true;
            break;
        }
        for (ItemStack stack : this.sellingStacks) {
            if (stack.m_41619_()) continue;
            hasSellingStack = true;
            break;
        }
        return !hasBuyingStack || !hasSellingStack;
    }
}

