/*
 * Decompiled with CFR 0.152.
 */
package flash.npcmod.core.trades;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import flash.npcmod.core.trades.TradeOffer;
import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;

public class TradeOffers
extends ArrayList<TradeOffer> {
    public TradeOffers() {
    }

    public TradeOffers(CompoundTag nbt) {
        ListTag listnbt = nbt.m_128437_("Recipes", 10);
        for (int i = 0; i < listnbt.size(); ++i) {
            this.add(new TradeOffer(listnbt.m_128728_(i)));
        }
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeByte((int)((byte)(this.size() & 0xFF)));
        for (int i = 0; i < this.size(); ++i) {
            int j;
            TradeOffer merchantoffer = (TradeOffer)this.get(i);
            for (j = 0; j < merchantoffer.getBuyingStacks().length; ++j) {
                buffer.m_130055_(merchantoffer.getBuyingStacks()[i]);
            }
            for (j = 0; j < merchantoffer.getSellingStacks().length; ++j) {
                buffer.m_130055_(merchantoffer.getSellingStacks()[i]);
            }
        }
    }

    public static TradeOffers read(FriendlyByteBuf buffer) {
        TradeOffers merchantoffers = new TradeOffers();
        int i = buffer.readByte() & 0xFF;
        for (int j = 0; j < i; ++j) {
            ItemStack buyingStack1 = buffer.m_130267_();
            ItemStack buyingStack2 = buffer.m_130267_();
            ItemStack buyingStack3 = buffer.m_130267_();
            ItemStack sellingStack1 = buffer.m_130267_();
            ItemStack sellingStack2 = buffer.m_130267_();
            ItemStack sellingStack3 = buffer.m_130267_();
            TradeOffer merchantoffer = new TradeOffer(buyingStack1, buyingStack2, buyingStack3, sellingStack1, sellingStack2, sellingStack3);
            merchantoffers.add(merchantoffer);
        }
        return merchantoffers;
    }

    public CompoundTag write() {
        CompoundTag compoundnbt = new CompoundTag();
        ListTag listnbt = new ListTag();
        for (int i = 0; i < this.size(); ++i) {
            TradeOffer merchantoffer = (TradeOffer)this.get(i);
            listnbt.add((Object)merchantoffer.write());
        }
        compoundnbt.m_128365_("Recipes", (Tag)listnbt);
        return compoundnbt;
    }

    public static TradeOffers read(String s) {
        try {
            CompoundTag tag = new TagParser(new StringReader(s)).m_129373_();
            return new TradeOffers(tag);
        }
        catch (CommandSyntaxException e) {
            return new TradeOffers();
        }
    }

    @Override
    public boolean isEmpty() {
        if (this.size() == 0) {
            return true;
        }
        for (TradeOffer offer : this) {
            if (offer.isEmpty()) continue;
            return false;
        }
        return true;
    }
}

